/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.dynamictreestfc.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.labellum.mc.dynamictreestfc.FeatureGenMoundTFC;
import org.labellum.mc.dynamictreestfc.ModBlocks;
import org.labellum.mc.dynamictreestfc.blocks.BlockBranchBasicTFC;
import org.labellum.mc.dynamictreestfc.blocks.BlockBranchThickTFC;
import org.labellum.mc.dynamictreestfc.blocks.BlockLogDTTFC;
import org.labellum.mc.dynamictreestfc.dropcreators.DropCreatorTFCLog;

public class TreeFamilyTFC
extends TreeFamily {
    public boolean hasConiferVariants = false;
    private boolean thick = false;

    public boolean isThick() {
        return this.thick;
    }

    public void setThick(boolean thick) {
        this.thick = thick;
    }

    public TreeFamilyTFC(ResourceLocation name, Tree tree) {
        super(name);
        switch (this.getName().func_110623_a()) {
            case "sequoia": 
            case "kapok": {
                this.setThick(true);
                this.setDynamicBranch(this.createBranch());
            }
        }
    }

    public TreeFamily setPrimitiveLog(IBlockState primLog) {
        BlockLogDTTFC primLogBlock = (BlockLogDTTFC)primLog.func_177230_c();
        BlockLogTFC log = BlockLogTFC.get((Tree)primLogBlock.wood);
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)log));
        return super.setPrimitiveLog(primLog, stack);
    }

    public void createSpecies() {
        this.setCommonSpecies(new TreeTFCSpecies(this, ModBlocks.leafMap.get(this.getName().toString())));
        this.getCommonSpecies().generateSeed();
    }

    public BlockBranch createBranch() {
        String branchName = "branch/" + this.getName().func_110623_a();
        return this.isThick() ? new BlockBranchThickTFC(branchName) : new BlockBranchBasicTFC(branchName);
    }

    public class TreeTFCSpecies
    extends Species {
        public TreeTFCSpecies(TreeFamilyTFC treeFamily, LeavesProperties prop) {
            super(treeFamily.getName(), (TreeFamily)treeFamily, (ILeavesProperties)prop);
            this.setupStandardSeedDropping();
            this.remDropCreator(new ResourceLocation("dynamictrees", "logs"));
            this.addDropCreator((IDropCreator)new DropCreatorTFCLog(treeFamily.getName().func_110623_a()));
            switch (treeFamily.getName().func_110623_a()) {
                case "kapok": {
                    this.addGenFeature((IGenFeature)new FeatureGenVine().setQuantity(8).setMaxLength(32).setRayDistance(32.0f));
                }
                case "sequoia": {
                    this.addGenFeature((IGenFeature)new FeatureGenMoundTFC(2));
                    this.setSoilLongevity(36);
                    this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
                }
            }
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            return ModBlocks.blockRootyDirt;
        }

        public float getSignalEnergy() {
            return this.signalEnergy;
        }

        public Species generateSeed() {
            Seed seed = new Seed("seed/" + this.getRegistryName().func_110623_a());
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }

        public boolean canBoneMeal() {
            return false;
        }
    }
}

