/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.dynamictreestfc;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKits;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.labellum.mc.dynamictreestfc.ModBlocks;
import org.labellum.mc.dynamictreestfc.blocks.BlockLogDTTFC;
import org.labellum.mc.dynamictreestfc.trees.TreeFamilyTFC;

public class ModTrees {
    public static ArrayList<TreeFamilyTFC> tfcTrees = new ArrayList();
    public static Map<String, Species> tfcSpecies = new HashMap<String, Species>();

    public static void preInit() {
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        ArrayList<Object> treeBlocks = new ArrayList<Object>();
        HashMap<String, float[]> paramMap = new HashMap<String, float[]>();
        HashMap<String, IGrowthLogicKit> logicMap = new HashMap<String, IGrowthLogicKit>();
        ModTrees.fillMaps(paramMap, logicMap);
        for (Tree t1 : TFCRegistries.TREES.getValuesCollection()) {
            float[] fArray;
            String treeName = t1.toString();
            ResourceLocation resLoc = new ResourceLocation("dynamictreestfc", treeName);
            TreeFamilyTFC family = new TreeFamilyTFC(resLoc, t1);
            tfcTrees.add(family);
            if (paramMap.get(treeName) == null) {
                float[] fArray2 = new float[5];
                fArray2[0] = 0.2f;
                fArray2[1] = 10.0f;
                fArray2[2] = 3.0f;
                fArray2[3] = 3.0f;
                fArray = fArray2;
                fArray2[4] = 1.0f;
            } else {
                fArray = (float[])paramMap.get(treeName);
            }
            float[] map = fArray;
            Species species = family.getCommonSpecies().setGrowthLogicKit((IGrowthLogicKit)(logicMap.get(treeName) == null ? GrowthLogicKits.nullLogic : (IGrowthLogicKit)logicMap.get(treeName))).setBasicGrowingParameters(map[0], map[1], (int)map[2], (int)map[3], map[4]);
            tfcSpecies.put(treeName, species);
            Species.REGISTRY.register((IForgeRegistryEntry)species);
            treeBlocks.add(new BlockLogDTTFC(t1).setRegistryName("dynamictreestfc", "block/log/" + treeName));
        }
        HashMap saplingMap = new HashMap();
        BlocksTFC.getAllSaplingBlocks().forEach(s -> saplingMap.put(s.getWood().toString(), s));
        for (Map.Entry<String, Species> entry : tfcSpecies.entrySet()) {
            TreeRegistry.registerSaplingReplacer((IBlockState)((BlockSaplingTFC)saplingMap.get(entry.getKey())).func_176223_P(), (Species)entry.getValue());
        }
        tfcTrees.forEach(t -> {
            String treeName = t.getName().func_110623_a();
            ModBlocks.leafMap.get(treeName).setTree((TreeFamily)t);
            Species species = tfcSpecies.get(treeName);
            species.setLeavesProperties((ILeavesProperties)ModBlocks.leafMap.get(treeName));
            switch (treeName) {
                case "acacia": {
                    species.addAcceptableSoils(new String[]{"hardclaylike"});
                    break;
                }
                case "douglas_fir": 
                case "spruce": 
                case "pine": 
                case "sequoia": 
                case "white_cedar": {
                    species.addGenFeature((IGenFeature)new FeatureGenConiferTopper((ILeavesProperties)ModBlocks.leafMap.get(treeName)));
                    t.hasConiferVariants = true;
                }
            }
        });
        tfcTrees.forEach(tree -> tree.getRegisterableBlocks(treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dynamictreestfc").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[0]));
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        TFCRegistries.TREES.getValuesCollection().forEach(t -> {
            String treeName = t.toString();
            ((TreeFamilyTFC)tfcSpecies.get(treeName).getFamily()).setPrimitiveLog(BlockLogDTTFC.get(t).func_176223_P());
        });
    }

    public static void postInit() {
        for (BlockRockVariant rock : BlocksTFC.getAllBlockRockVariants()) {
            IBlockState def = rock.func_176223_P();
            if (BlocksTFC.isGrowableSoil((IBlockState)def)) {
                DirtHelper.registerSoil((Block)def.func_177230_c(), (String)"dirtlike");
                continue;
            }
            if (BlocksTFC.isSand((IBlockState)def)) {
                DirtHelper.registerSoil((Block)def.func_177230_c(), (String)"sandlike");
                continue;
            }
            if (!BlocksTFC.isSoilOrGravel((IBlockState)def)) continue;
            DirtHelper.registerSoil((Block)def.func_177230_c(), (String)"gravellike");
        }
        DirtHelper.registerSoil((Block)FluidsTFC.FRESH_WATER.get().getBlock(), (String)"waterlike");
        DirtHelper.registerSoil((Block)FluidsTFC.SALT_WATER.get().getBlock(), (String)"waterlike");
    }

    private static void fillMaps(Map<String, float[]> paramMap, Map<String, IGrowthLogicKit> logicMap) {
        paramMap.put("acacia", new float[]{0.1f, 14.0f, 6.0f, 6.0f, 0.9f});
        paramMap.put("ash", new float[]{0.25f, 12.0f, 4.0f, 3.0f, 1.0f});
        paramMap.put("aspen", new float[]{0.3f, 16.0f, 8.0f, 2.0f, 1.5f});
        paramMap.put("birch", new float[]{0.25f, 12.0f, 5.0f, 5.0f, 1.15f});
        paramMap.put("blackwood", new float[]{0.2f, 13.0f, 3.0f, 4.0f, 0.9f});
        paramMap.put("chestnut", new float[]{0.2f, 10.0f, 3.0f, 3.0f, 1.0f});
        paramMap.put("douglas_fir", new float[]{0.15f, 20.0f, 5.0f, 3.0f, 1.15f});
        paramMap.put("hickory", new float[]{0.2f, 14.0f, 5.0f, 3.0f, 0.8f});
        paramMap.put("kapok", new float[]{0.1f, 30.0f, 7.0f, 4.0f, 0.85f});
        paramMap.put("maple", new float[]{0.15f, 15.0f, 6.0f, 3.0f, 0.95f});
        paramMap.put("oak", new float[]{0.3f, 16.0f, 3.0f, 3.0f, 0.85f});
        paramMap.put("palm", new float[]{0.05f, 16.0f, 5.0f, 4.0f, 1.1f});
        paramMap.put("pine", new float[]{0.2f, 18.0f, 6.0f, 2.0f, 1.2f});
        paramMap.put("rosewood", new float[]{0.35f, 15.0f, 7.0f, 3.0f, 1.0f});
        paramMap.put("sequoia", new float[]{0.2f, 36.0f, 9.0f, 4.0f, 0.7f});
        paramMap.put("spruce", new float[]{0.15f, 12.0f, 6.0f, 3.0f, 1.1f});
        paramMap.put("sycamore", new float[]{0.2f, 10.0f, 4.0f, 3.0f, 0.9f});
        paramMap.put("white_cedar", new float[]{0.15f, 20.0f, 6.0f, 2.0f, 1.1f});
        paramMap.put("willow", new float[]{0.55f, 15.0f, 2.0f, 2.0f, 1.4f});
        paramMap.put("hevea", new float[]{0.2f, 13.0f, 3.0f, 7.0f, 1.25f});
        logicMap.put("acacia", (IGrowthLogicKit)GrowthLogicKits.nullLogic);
        logicMap.put("ash", (IGrowthLogicKit)GrowthLogicKits.nullLogic);
        logicMap.put("aspen", TreeRegistry.findGrowthLogicKit((String)"Conifer"));
        logicMap.put("birch", (IGrowthLogicKit)GrowthLogicKits.nullLogic);
        logicMap.put("blackwood", TreeRegistry.findGrowthLogicKit((String)"DarkOak"));
        logicMap.put("chestnut", TreeRegistry.findGrowthLogicKit((String)"DarkOak"));
        logicMap.put("douglas_fir", TreeRegistry.findGrowthLogicKit((String)"Conifer"));
        logicMap.put("hickory", TreeRegistry.findGrowthLogicKit((String)"DarkOak"));
        logicMap.put("kapok", TreeRegistry.findGrowthLogicKit((String)"Jungle"));
        logicMap.put("maple", (IGrowthLogicKit)GrowthLogicKits.nullLogic);
        logicMap.put("oak", TreeRegistry.findGrowthLogicKit((String)"DarkOak"));
        logicMap.put("palm", TreeRegistry.findGrowthLogicKit((String)"Jungle"));
        logicMap.put("pine", TreeRegistry.findGrowthLogicKit((String)"Conifer"));
        logicMap.put("rosewood", (IGrowthLogicKit)GrowthLogicKits.nullLogic);
        logicMap.put("sequoia", (IGrowthLogicKit)new ConiferLogic(5.0f));
        logicMap.put("spruce", TreeRegistry.findGrowthLogicKit((String)"Conifer"));
        logicMap.put("sycamore", (IGrowthLogicKit)GrowthLogicKits.nullLogic);
        logicMap.put("white_cedar", TreeRegistry.findGrowthLogicKit((String)"Conifer"));
        logicMap.put("willow", TreeRegistry.findGrowthLogicKit((String)"DarkOak"));
        logicMap.put("hevea", TreeRegistry.findGrowthLogicKit((String)"DarkOak"));
    }
}

