/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.dynamictreestfc;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.ICellKit;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLeavesTFC;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.labellum.mc.dynamictreestfc.blocks.BlockRootyTFC;

public class ModBlocks {
    public static LeavesProperties[] tfcLeavesProperties;
    public static Map<String, LeavesProperties> leafMap;
    public static Map<String, ICellKit> kitMap;
    public static BlockRooty blockRootyDirt;

    public static void preInit() {
        blockRootyDirt = new BlockRootyTFC();
        kitMap = new HashMap<String, ICellKit>();
        ModBlocks.fillMaps(kitMap);
    }

    public static void register(IForgeRegistry<Block> registry) {
        tfcLeavesProperties = new LeavesProperties[BlocksTFC.getAllLeafBlocks().size()];
        leafMap = new HashMap<String, LeavesProperties>();
        int i = 0;
        for (BlockLeavesTFC leaf : BlocksTFC.getAllLeafBlocks()) {
            LeavesProperties prop = new LeavesProperties(leaf.func_176223_P(), kitMap.get(leaf.wood.toString()));
            leafMap.put(leaf.wood.toString(), prop);
            ModBlocks.tfcLeavesProperties[i++] = prop;
        }
        for (LeavesProperties lp : tfcLeavesProperties) {
            LeavesPaging.getNextLeavesBlock((String)"dynamictreestfc", (ILeavesProperties)lp);
        }
        registry.register((IForgeRegistryEntry)blockRootyDirt);
    }

    private static void fillMaps(Map<String, ICellKit> kitMap) {
        kitMap.put("acacia", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "acacia")));
        kitMap.put("ash", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("aspen", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("birch", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("blackwood", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "darkoak")));
        kitMap.put("chestnut", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("douglas_fir", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "conifer")));
        kitMap.put("hickory", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("kapok", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("maple", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("oak", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("palm", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "palm")));
        kitMap.put("pine", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "conifer")));
        kitMap.put("rosewood", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("sequoia", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "conifer")));
        kitMap.put("spruce", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "conifer")));
        kitMap.put("sycamore", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("white_cedar", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("willow", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
        kitMap.put("hevea", TreeRegistry.findCellKit((ResourceLocation)new ResourceLocation("dynamictrees", "deciduous")));
    }
}

