/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.dynamictreestfc;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.Random;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.TemplateManager;
import org.labellum.mc.dynamictreestfc.ModTrees;
import org.labellum.mc.dynamictreestfc.TFCRadiusCoordinator;
import org.labellum.mc.dynamictreestfc.trees.TreeFamilyTFC;

public class DTFCGenerator
implements ITreeGenerator {
    private int dtRadius = 0;
    private static TFCRadiusCoordinator radiusCoordinator = null;

    public void generateTree(TemplateManager templateManager, World world, BlockPos blockPos, Tree tree, Random random, boolean isWorldGen) {
        Species dtSpecies = ModTrees.tfcSpecies.get(tree.toString());
        SafeChunkBounds bounds = new SafeChunkBounds(world, world.func_175726_f(blockPos).func_76632_l());
        dtSpecies.generate(world, blockPos.func_177977_b(), world.func_180494_b(blockPos), random, this.dtRadius <= 0 ? dtSpecies.maxBranchRadius() / 3 : this.dtRadius, bounds);
    }

    public boolean canGenerateTree(World world, BlockPos pos, Tree treeType) {
        int y;
        if (!BlocksTFC.isGrowableSoil((IBlockState)world.func_180495_p(pos.func_177977_b()))) {
            return false;
        }
        IBlockState locState = world.func_180495_p(pos);
        if (locState.func_185904_a().func_76224_d() || !locState.func_185904_a().func_76222_j() && !(locState.func_177230_c() instanceof BlockSaplingTFC)) {
            return false;
        }
        if (radiusCoordinator == null) {
            radiusCoordinator = new TFCRadiusCoordinator(null, world);
        }
        this.dtRadius = radiusCoordinator.getRadiusAtCoords(pos.func_177958_n(), pos.func_177952_p());
        Species dTree = ModTrees.tfcSpecies.get(treeType.toString());
        int nht = dTree.getLowestBranchHeight();
        int xht = (int)((TreeFamilyTFC.TreeTFCSpecies)dTree).getSignalEnergy();
        SafeChunkBounds bounds = new SafeChunkBounds(world, world.func_175726_f(pos).func_76632_l());
        for (y = 0; y <= nht; ++y) {
            if (this.openRadius(world, pos.func_177981_b(y), 0, 0, bounds)) continue;
            return false;
        }
        for (int x = -this.dtRadius - 1; x <= this.dtRadius + 1; ++x) {
            for (int z = -this.dtRadius - 1; z <= this.dtRadius + 1; ++z) {
                for (y = nht - 1; y < xht; ++y) {
                    if (this.openRadius(world, pos.func_177981_b(y), x, z, bounds)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean openRadius(World world, BlockPos pos, int x, int y, SafeChunkBounds bounds) {
        boolean origin = x == 0 && y == 0;
        return origin || !bounds.inBounds(pos.func_177982_a(x, 0, y), false) || this.isReplaceable(world, pos, x, 0, y) || (x > 1 || y > 1) && this.isReplaceable(world, pos, x, 1, y);
    }

    private boolean isDTBranch(IBlockState state) {
        Block block = state.func_177230_c();
        return block instanceof BlockBranch;
    }

    private boolean isReplaceable(World world, BlockPos pos, int x, int y, int z) {
        IBlockState state = world.func_180495_p(pos.func_177982_a(x, y, z));
        return state.func_185904_a().func_76222_j() && !this.isDTBranch(state);
    }
}

