/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.smallernetherportals.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Util {
    public static void processSmallerPortal(World world, BlockPos pos) {
        int heighti;
        BlockPos bottomleft;
        String airdirection = "none";
        Rotation rotation = null;
        if (Util.isObsidian(world.func_180495_p(pos.func_177974_f())).booleanValue()) {
            if (Util.isAir(world.func_180495_p(pos.func_177976_e())).booleanValue()) {
                bottomleft = pos.func_177976_e();
                airdirection = "east";
            } else {
                bottomleft = pos;
                rotation = Rotation.CLOCKWISE_180;
            }
        } else if (Util.isObsidian(world.func_180495_p(pos.func_177976_e())).booleanValue()) {
            if (Util.isAir(world.func_180495_p(pos.func_177974_f())).booleanValue()) {
                airdirection = "east";
            } else {
                rotation = Rotation.CLOCKWISE_180;
            }
            bottomleft = pos;
        } else if (Util.isObsidian(world.func_180495_p(pos.func_177978_c())).booleanValue()) {
            if (Util.isAir(world.func_180495_p(pos.func_177968_d())).booleanValue()) {
                airdirection = "south";
            } else {
                rotation = Rotation.CLOCKWISE_90;
            }
            bottomleft = pos;
        } else if (Util.isObsidian(world.func_180495_p(pos.func_177968_d())).booleanValue()) {
            if (Util.isAir(world.func_180495_p(pos.func_177978_c())).booleanValue()) {
                bottomleft = pos.func_177978_c();
                airdirection = "south";
            } else {
                bottomleft = pos;
                rotation = Rotation.CLOCKWISE_90;
            }
        } else {
            return;
        }
        bottomleft = bottomleft.func_185334_h();
        int height = -1;
        if (!world.func_180495_p(bottomleft.func_177977_b()).func_177230_c().equals(Blocks.field_150343_Z)) {
            return;
        }
        if (world.func_180495_p(bottomleft.func_177981_b(2)).func_177230_c().equals(Blocks.field_150343_Z)) {
            height = 2;
        } else if (world.func_180495_p(bottomleft.func_177981_b(3)).func_177230_c().equals(Blocks.field_150343_Z)) {
            height = 3;
        } else {
            return;
        }
        ArrayList<BlockPos> toportals = new ArrayList<BlockPos>();
        for (heighti = height; heighti > 0; --heighti) {
            Block wblock;
            toportals.add(bottomleft.func_177981_b(heighti - 1).func_185334_h());
            if (airdirection == "none") continue;
            if (airdirection == "south") {
                if (!world.func_180495_p(bottomleft.func_177978_c()).func_177230_c().equals(Blocks.field_150343_Z)) break;
                wblock = world.func_180495_p(bottomleft.func_177968_d()).func_177230_c();
                if (wblock.equals(Blocks.field_150350_a)) {
                    if (!world.func_180495_p(bottomleft.func_177970_e(2)).func_177230_c().equals(Blocks.field_150343_Z)) break;
                    toportals.add(bottomleft.func_177981_b(heighti - 1).func_177968_d().func_185334_h());
                    continue;
                }
                if (wblock.equals(Blocks.field_150343_Z)) continue;
                break;
            }
            if (airdirection != "east") continue;
            if (!world.func_180495_p(bottomleft.func_177976_e()).func_177230_c().equals(Blocks.field_150343_Z)) break;
            wblock = world.func_180495_p(bottomleft.func_177974_f()).func_177230_c();
            if (wblock.equals(Blocks.field_150350_a)) {
                if (!world.func_180495_p(bottomleft.func_177965_g(2)).func_177230_c().equals(Blocks.field_150343_Z)) break;
                toportals.add(bottomleft.func_177981_b(heighti - 1).func_177974_f().func_185334_h());
                continue;
            }
            if (!wblock.equals(Blocks.field_150343_Z)) break;
        }
        if (heighti == 0) {
            if (rotation == null) {
                rotation = airdirection == "east" ? Rotation.CLOCKWISE_180 : Rotation.CLOCKWISE_90;
            }
            for (BlockPos tp : toportals) {
                world.func_180501_a(tp, Blocks.field_150427_aO.func_176223_P().func_185907_a(rotation), 2);
            }
        }
    }

    public static List<BlockPos> getFrontBlocks(World world, BlockPos portalblock) {
        ArrayList<BlockPos> returnblocks = new ArrayList<BlockPos>();
        Boolean smallest = false;
        if (Util.isObsidian(world.func_180495_p(portalblock.func_177974_f())).booleanValue() && Util.isObsidian(world.func_180495_p(portalblock.func_177976_e())).booleanValue()) {
            smallest = true;
        } else if (Util.isObsidian(world.func_180495_p(portalblock.func_177978_c())).booleanValue() && Util.isObsidian(world.func_180495_p(portalblock.func_177968_d())).booleanValue()) {
            smallest = true;
        } else if (Util.isPortal(world.func_180495_p(portalblock.func_177978_c())).booleanValue()) {
            portalblock = portalblock.func_177978_c().func_185334_h();
        } else if (Util.isPortal(world.func_180495_p(portalblock.func_177976_e())).booleanValue()) {
            portalblock = portalblock.func_177976_e().func_185334_h();
        }
        if (Util.isNotPortalOrObsidian(world.func_180495_p(portalblock.func_177976_e())).booleanValue()) {
            returnblocks.add(portalblock.func_177976_e().func_177977_b().func_185334_h());
            if (!smallest.booleanValue()) {
                returnblocks.add(portalblock.func_177976_e().func_177968_d().func_177977_b().func_185334_h());
            }
        } else {
            returnblocks.add(portalblock.func_177968_d().func_177977_b().func_185334_h());
            if (!smallest.booleanValue()) {
                returnblocks.add(portalblock.func_177968_d().func_177974_f().func_177977_b().func_185334_h());
            }
        }
        return returnblocks;
    }

    public static BlockPos findPortalAround(World world, BlockPos pos) {
        BlockPos portalpos = null;
        for (int i = 0; i < 10; ++i) {
            BlockPos cpos = pos.func_177981_b(i).func_185334_h();
            for (BlockPos ap : BlockPos.func_191532_a((int)(cpos.func_177958_n() - 1), (int)cpos.func_177956_o(), (int)(cpos.func_177952_p() - 1), (int)(cpos.func_177958_n() + 1), (int)cpos.func_177956_o(), (int)(cpos.func_177952_p() + 1))) {
                if (!Util.isPortal(world.func_180495_p(ap)).booleanValue()) continue;
                portalpos = ap.func_185334_h();
                break;
            }
            if (portalpos != null) break;
        }
        return portalpos;
    }

    public static void setObsidian(World world, List<BlockPos> toblocks) {
        for (BlockPos tbs : toblocks) {
            if (Util.shouldMakeFront(world.func_180495_p(tbs)).booleanValue()) {
                world.func_175656_a(tbs, Blocks.field_150343_Z.func_176223_P());
            }
            for (int i = 1; i < 3; ++i) {
                BlockPos up = tbs.func_177981_b(i);
                if (Util.isAir(world.func_180495_p(up)).booleanValue()) continue;
                world.func_175656_a(up, Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public static Boolean shouldMakeFront(IBlockState bs) {
        Block block = bs.func_177230_c();
        if (block.equals(Blocks.field_150350_a) || block.equals(Blocks.field_150424_aL) || block.equals(Blocks.field_150425_aM)) {
            return true;
        }
        return false;
    }

    public static Boolean isObsidian(IBlockState bs) {
        Block block = bs.func_177230_c();
        if (block.equals(Blocks.field_150343_Z)) {
            return true;
        }
        return false;
    }

    public static Boolean isAir(IBlockState bs) {
        Block block = bs.func_177230_c();
        if (block.equals(Blocks.field_150350_a)) {
            return true;
        }
        return false;
    }

    public static Boolean isNotPortalOrObsidian(IBlockState bs) {
        Block block = bs.func_177230_c();
        if (!block.equals(Blocks.field_150427_aO) && !block.equals(Blocks.field_150343_Z)) {
            return true;
        }
        return false;
    }

    public static Boolean isPortal(IBlockState bs) {
        Block block = bs.func_177230_c();
        if (block.equals(Blocks.field_150427_aO)) {
            return true;
        }
        return false;
    }
}

