/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.jeivillagers.jei;

import com.buuz135.jeivillagers.FakeVillager;
import com.buuz135.jeivillagers.Jeivillagers;
import com.buuz135.jeivillagers.jei.VillagerCategory;
import com.buuz135.jeivillagers.jei.VillagerRecipe;
import com.buuz135.jeivillagers.jei.ingredient.VillageCareerRenderer;
import com.buuz135.jeivillagers.jei.ingredient.VillagerCareerFactory;
import com.buuz135.jeivillagers.jei.ingredient.VillagerCareerHelper;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.IRecipesGui;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

@JEIPlugin
public class VillagerPlugin
implements IModPlugin {
    private VillagerCategory category;
    private ISubtypeRegistry subtypes;
    private static IRecipesGui recipesGui;
    private static IRecipeRegistry recipeRegistry;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        this.subtypes = subtypeRegistry;
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        Preconditions.checkState((this.subtypes != null ? 1 : 0) != 0);
        registry.register(VillagerRegistry.VillagerCareer.class, VillagerCareerFactory.create(), (IIngredientHelper)new VillagerCareerHelper(), (IIngredientRenderer)new VillageCareerRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.category = new VillagerCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.category});
    }

    public void register(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)VillagerPlugin.getVillagerEgg(), new String[]{this.category.getUid()});
        Jeivillagers.tradeInfoMultimap.clear();
        FakeVillager merchant = new FakeVillager();
        Random random = new Random();
        for (VillagerRegistry.VillagerProfession profession : ForgeRegistries.VILLAGER_PROFESSIONS) {
            int id = 1;
            VillagerRegistry.VillagerCareer original = profession.getCareer(0);
            Jeivillagers.registerCareer(merchant, original, random);
            while (!original.equals((Object)profession.getCareer(id))) {
                Jeivillagers.registerCareer(merchant, profession.getCareer(id), random);
                ++id;
            }
        }
        for (Jeivillagers.VillagerTradeInfo tradeInfo : Jeivillagers.tradeInfoMultimap.values()) {
            tradeInfo.clean();
        }
        for (VillagerRegistry.VillagerCareer career : Jeivillagers.tradeInfoMultimap.keySet()) {
            registry.addRecipes((Collection)Jeivillagers.tradeInfoMultimap.get((Object)career).stream().filter(villagerTradeInfo -> !villagerTradeInfo.outputStack.func_190926_b()).map(villagerTradeInfo -> new VillagerRecipe(career, (Jeivillagers.VillagerTradeInfo)villagerTradeInfo)).collect(Collectors.toList()), this.category.getUid());
        }
        registry.addRecipeClickArea(GuiMerchant.class, 82, 52, 26, 15, new String[]{this.category.getUid()});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        recipesGui = jeiRuntime.getRecipesGui();
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }

    public static ItemStack getVillagerEgg() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound idnbt = new NBTTagCompound();
        idnbt.func_74778_a("id", "minecraft:villager");
        compound.func_74782_a("EntityTag", (NBTBase)idnbt);
        ItemStack stack = new ItemStack(Items.field_151063_bx);
        stack.func_77982_d(compound);
        return stack;
    }

    public static void showUses(VillagerRegistry.VillagerCareer career) {
        if (recipesGui != null && recipeRegistry != null) {
            recipesGui.show(recipeRegistry.createFocus(IFocus.Mode.OUTPUT, (Object)career));
        }
    }
}

