/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.jeivillagers;

import com.buuz135.jeivillagers.config.VillagerConfig;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

@Mod(modid="jeivillagers", name="Jeivillagers", version="1.0", dependencies="required-after:jei@[4.7.8.91,)", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class Jeivillagers {
    public static final String MOD_ID = "jeivillagers";
    public static final String MOD_NAME = "Jeivillagers";
    public static final String VERSION = "1.0";
    public static Multimap<VillagerRegistry.VillagerCareer, VillagerTradeInfo> tradeInfoMultimap = ArrayListMultimap.create();
    @Mod.Instance(value="jeivillagers")
    public static Jeivillagers INSTANCE;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    public static void registerCareer(IMerchant merchant, VillagerRegistry.VillagerCareer career, Random random) {
        if (Jeivillagers.isClassBlackListed(career.getClass())) {
            return;
        }
        for (int level = 0; career.getTrades(level) != null && level < 50; ++level) {
            for (EntityVillager.ITradeList list : career.getTrades(level)) {
                if (list.getClass().toString().endsWith("TreasureMapForEmeralds")) continue;
                try {
                    tradeInfoMultimap.put((Object)career, (Object)Jeivillagers.generateTradeInfo(merchant, list, random));
                }
                catch (Exception e) {
                    System.out.println("Error checking recipes for class " + list.getClass().toString());
                }
            }
        }
    }

    private static VillagerTradeInfo generateTradeInfo(IMerchant merchant, EntityVillager.ITradeList tradeList, Random random) {
        VillagerTradeInfo info = new VillagerTradeInfo();
        for (int i = 0; i < 100; ++i) {
            MerchantRecipeList list = new MerchantRecipeList();
            tradeList.func_190888_a(merchant, list, random);
            if (list.size() <= 0) continue;
            info.addMerchantRecipeInfo((MerchantRecipe)list.get(0));
        }
        return info;
    }

    public static boolean isClassBlackListed(Class<?> clazz) {
        for (String blackListedVillagerClasses : VillagerConfig.BlackListedVillagerClasses) {
            if (!clazz.getName().endsWith(blackListedVillagerClasses)) continue;
            return true;
        }
        return false;
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
    }

    @Mod.EventBusSubscriber
    public static class ObjectRegistryHandler {
        @SubscribeEvent
        public static void addItems(RegistryEvent.Register<Item> event) {
        }

        @SubscribeEvent
        public static void addBlocks(RegistryEvent.Register<Block> event) {
        }
    }

    @GameRegistry.ObjectHolder(value="jeivillagers")
    public static class Items {
    }

    @GameRegistry.ObjectHolder(value="jeivillagers")
    public static class Blocks {
    }

    public static class VillagerTradeInfo {
        public ItemStack firstInput = ItemStack.field_190927_a;
        public ItemStack secondInput = ItemStack.field_190927_a;
        public ItemStack outputStack = ItemStack.field_190927_a;
        public EntityVillager.PriceInfo first;
        public EntityVillager.PriceInfo second;
        public EntityVillager.PriceInfo output;

        public void addMerchantRecipeInfo(MerchantRecipe recipe) {
            this.firstInput = this.cleanStack(recipe.func_77394_a());
            this.secondInput = this.cleanStack(recipe.func_77396_b());
            this.outputStack = this.cleanStack(recipe.func_77397_d());
            this.first = this.checkPriceInfo(this.first, recipe.func_77394_a());
            this.second = this.checkPriceInfo(this.second, recipe.func_77396_b());
            this.output = this.checkPriceInfo(this.output, recipe.func_77397_d());
        }

        public ItemStack cleanStack(ItemStack stack) {
            if (stack.func_190926_b()) {
                return stack;
            }
            ItemStack cleaned = stack.func_77946_l();
            cleaned.func_190920_e(1);
            return cleaned;
        }

        public EntityVillager.PriceInfo checkPriceInfo(EntityVillager.PriceInfo info, ItemStack stack) {
            if (stack.func_190926_b()) {
                return info;
            }
            if (info == null) {
                return new EntityVillager.PriceInfo(stack.func_190916_E(), stack.func_190916_E());
            }
            return new EntityVillager.PriceInfo(stack.func_190916_E() < (Integer)info.func_76341_a() ? stack.func_190916_E() : ((Integer)info.func_76341_a()).intValue(), stack.func_190916_E() > (Integer)info.func_76340_b() ? stack.func_190916_E() : ((Integer)info.func_76340_b()).intValue());
        }

        public void clean() {
            this.first = this.cleanStackWithInfo(this.firstInput, this.first);
            this.second = this.cleanStackWithInfo(this.secondInput, this.second);
            this.output = this.cleanStackWithInfo(this.outputStack, this.output);
        }

        private EntityVillager.PriceInfo cleanStackWithInfo(ItemStack stack, EntityVillager.PriceInfo info) {
            if (info == null || stack.func_190926_b()) {
                return null;
            }
            if (((Integer)info.func_76341_a()).equals(info.func_76340_b())) {
                stack.func_190920_e(((Integer)info.func_76341_a()).intValue());
                return null;
            }
            return info;
        }
    }
}

