/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.common.data;

import com.mrcrayfish.obfuscate.common.data.IDataSerializer;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class SyncedDataKey<T> {
    private ResourceLocation key;
    private IDataSerializer<T> serializer;
    private Supplier<T> defaultValueSupplier;
    private boolean save;
    private boolean persistent;
    private boolean syncToClient;
    private boolean syncToAllPlayers;
    private int id;

    private SyncedDataKey(ResourceLocation key, IDataSerializer<T> serializer, Supplier<T> defaultValueSupplier) {
        this.key = key;
        this.serializer = serializer;
        this.defaultValueSupplier = defaultValueSupplier;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public IDataSerializer<T> getSerializer() {
        return this.serializer;
    }

    public Supplier<T> getDefaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    public boolean shouldSave() {
        return this.save;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean shouldSyncToClient() {
        return this.syncToClient;
    }

    public boolean shouldSyncToAllPlayers() {
        return this.syncToAllPlayers;
    }

    public int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncedDataKey that = (SyncedDataKey)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static <T> Builder<T> builder(IDataSerializer<T> serializer) {
        return new Builder(serializer);
    }

    public static class Builder<T> {
        private ResourceLocation id;
        private IDataSerializer<T> serializer;
        private Supplier<T> defaultValueSupplier;
        private boolean save = false;
        private boolean persistent = true;
        private boolean syncToClient = true;
        private boolean syncToAllPlayers = true;

        private Builder(IDataSerializer<T> serializer) {
            this.serializer = serializer;
        }

        public SyncedDataKey<T> build() {
            Validate.notNull((Object)this.id, (String)"Missing 'key' when building synced data key", (Object[])new Object[0]);
            Validate.notNull(this.serializer, (String)"Missing 'serializer' when building synced data key", (Object[])new Object[0]);
            Validate.notNull(this.defaultValueSupplier, (String)"Missing 'defaultValueSupplier' when building synced data key", (Object[])new Object[0]);
            SyncedDataKey key = new SyncedDataKey(this.id, this.serializer, this.defaultValueSupplier);
            key.save = this.save;
            key.persistent = this.persistent;
            key.syncToClient = this.syncToClient;
            key.syncToAllPlayers = this.syncToAllPlayers;
            return key;
        }

        public Builder<T> id(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder<T> key(String key) {
            this.id = new ResourceLocation(key);
            return this;
        }

        public Builder<T> defaultValueSupplier(Supplier<T> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
            return this;
        }

        public Builder<T> saveToFile() {
            this.save = true;
            return this;
        }

        public Builder<T> resetOnDeath() {
            this.persistent = false;
            return this;
        }

        public Builder<T> doNotSync() {
            this.syncToClient = false;
            return this;
        }

        public Builder<T> restrictSync() {
            this.syncToAllPlayers = false;
            return this;
        }
    }
}

