/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.asm;

import com.mrcrayfish.obfuscate.Obfuscate;
import com.mrcrayfish.obfuscate.asm.ObfName;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ObfuscateTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        boolean isObfuscated;
        if (bytes == null) {
            return null;
        }
        boolean bl = isObfuscated = !name.equals(transformedName);
        if (transformedName.equals("net.minecraft.client.renderer.RenderItem")) {
            return this.patchRenderItem(bytes, isObfuscated);
        }
        return bytes;
    }

    private byte[] patchRenderItem(byte[] bytes, boolean isObfuscated) {
        Obfuscate.LOGGER.info("Applying ASM to RenderItem");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        ObfName methodName = new ObfName("func_191962_a", "renderItemModelIntoGUI");
        String params = "(Lnet/minecraft/item/ItemStack;IILnet/minecraft/client/renderer/block/model/IBakedModel;)V";
        ObfName targetInstruction = new ObfName("func_180452_a", "setupGuiTransform");
        ObfName popInstruction = new ObfName("func_180454_a", "renderItem");
        for (MethodNode method : classNode.methods) {
            if (!methodName.equals(method.name) || !method.desc.equals(params)) continue;
            AbstractInsnNode target = null;
            AbstractInsnNode popNode = null;
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (!(node instanceof MethodInsnNode) || !targetInstruction.equals(((MethodInsnNode)node).name)) continue;
                target = node;
                break;
            }
            for (AbstractInsnNode node : method.instructions.toArray()) {
                if (node.getOpcode() != 182 || !popInstruction.equals(((MethodInsnNode)node).name) || node.getPrevious().getOpcode() != 25) continue;
                popNode = node;
                break;
            }
            if (target == null || popNode == null) continue;
            InsnList preEvent = new InsnList();
            preEvent.add((AbstractInsnNode)new LabelNode());
            preEvent.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lnet/minecraftforge/fml/common/eventhandler/EventBus;"));
            preEvent.add((AbstractInsnNode)new TypeInsnNode(187, "com/mrcrayfish/obfuscate/client/event/RenderItemEvent$Gui$Pre"));
            preEvent.add((AbstractInsnNode)new InsnNode(89));
            preEvent.add((AbstractInsnNode)new VarInsnNode(25, 1));
            preEvent.add((AbstractInsnNode)new MethodInsnNode(183, "com/mrcrayfish/obfuscate/client/event/RenderItemEvent$Gui$Pre", "<init>", "(Lnet/minecraft/item/ItemStack;)V", false));
            preEvent.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/common/eventhandler/EventBus", "post", "(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z", false));
            LabelNode jumpNode = new LabelNode();
            preEvent.add((AbstractInsnNode)new JumpInsnNode(154, jumpNode));
            method.instructions.insert(target, preEvent);
            InsnList postEvent = new InsnList();
            postEvent.add((AbstractInsnNode)new LabelNode());
            postEvent.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lnet/minecraftforge/fml/common/eventhandler/EventBus;"));
            postEvent.add((AbstractInsnNode)new TypeInsnNode(187, "com/mrcrayfish/obfuscate/client/event/RenderItemEvent$Gui$Post"));
            postEvent.add((AbstractInsnNode)new InsnNode(89));
            postEvent.add((AbstractInsnNode)new VarInsnNode(25, 1));
            postEvent.add((AbstractInsnNode)new MethodInsnNode(183, "com/mrcrayfish/obfuscate/client/event/RenderItemEvent$Gui$Post", "<init>", "(Lnet/minecraft/item/ItemStack;)V", false));
            postEvent.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/common/eventhandler/EventBus", "post", "(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z", false));
            postEvent.add((AbstractInsnNode)new InsnNode(87));
            postEvent.add((AbstractInsnNode)jumpNode);
            postEvent.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            method.instructions.insert(popNode, postEvent);
            Obfuscate.LOGGER.info("Successfully patched RenderItem");
            break;
        }
        ClassWriter writer = new ClassWriter(0);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

