/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BiomeTraitFluid
extends BiomeTrait {
    protected IBlockState blockToSpawn;
    protected IBlockState blockToTarget;
    protected boolean generateFalling;

    protected BiomeTraitFluid(Builder builder) {
        super(builder);
        this.blockToSpawn = builder.blockToSpawn;
        this.blockToTarget = builder.blockToTarget;
        this.generateFalling = builder.generateFalling;
    }

    public static BiomeTraitFluid create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public void readFromConfig(Config config) {
        super.readFromConfig(config);
        this.blockToSpawn = ConfigHelper.getBlockState(config, "blockToSpawn");
        this.blockToTarget = ConfigHelper.getBlockState(config, "blockToTarget");
        this.generateFalling = (Boolean)config.getOrElse("generateFalling", (Object)true);
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        ConfigHelper.setBlockState(config, "blockToTarget", this.blockToTarget);
        ConfigHelper.setBlockState(config, "blockToSpawn", this.blockToSpawn);
        config.add("generateFalling", (Object)this.generateFalling);
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.blockToSpawn == null || this.blockToTarget == null) {
            return false;
        }
        if (world.func_180495_p(pos.func_177984_a()) != this.blockToTarget) {
            return false;
        }
        if (!world.func_175623_d(pos) && world.func_180495_p(pos) != this.blockToTarget) {
            return false;
        }
        int i = 0;
        if (world.func_180495_p(pos.func_177976_e()) == this.blockToTarget) {
            ++i;
        }
        if (world.func_180495_p(pos.func_177974_f()) == this.blockToTarget) {
            ++i;
        }
        if (world.func_180495_p(pos.func_177978_c()) == this.blockToTarget) {
            ++i;
        }
        if (world.func_180495_p(pos.func_177968_d()) == this.blockToTarget) {
            ++i;
        }
        if (world.func_180495_p(pos.func_177977_b()) == this.blockToTarget) {
            ++i;
        }
        int j = 0;
        if (world.func_175623_d(pos.func_177976_e())) {
            ++j;
        }
        if (world.func_175623_d(pos.func_177974_f())) {
            ++j;
        }
        if (world.func_175623_d(pos.func_177978_c())) {
            ++j;
        }
        if (world.func_175623_d(pos.func_177968_d())) {
            ++j;
        }
        if (world.func_175623_d(pos.func_177977_b())) {
            ++j;
        }
        if (!this.generateFalling && i == 4 && j == 1 || i == 5) {
            world.func_180501_a(pos, this.blockToSpawn, 2);
            world.func_189507_a(pos, this.blockToSpawn, random);
        }
        return true;
    }

    public static class Builder
    extends BiomeTrait.Builder {
        private IBlockState blockToSpawn = Blocks.field_150355_j.func_176223_P();
        private IBlockState blockToTarget = Blocks.field_150348_b.func_176223_P();
        private boolean generateFalling = false;

        public Builder blockToSpawn(IBlockState blockToSpawn) {
            this.blockToSpawn = blockToSpawn;
            return this;
        }

        public Builder blockToTarget(IBlockState blockToTarget) {
            this.blockToTarget = blockToTarget;
            return this;
        }

        public Builder generateFalling(boolean generateFalling) {
            this.generateFalling = generateFalling;
            return this;
        }

        public BiomeTraitFluid create() {
            return new BiomeTraitFluid(this);
        }
    }
}

