/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import java.util.Random;
import java.util.function.Consumer;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitAbstractTree;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BiomeTraitDenseTree
extends BiomeTraitAbstractTree {
    protected BiomeTraitDenseTree(Builder builder) {
        super(builder);
        this.logBlock = builder.logBlock;
        this.leafBlock = builder.leafBlock;
        this.blockToTarget = builder.blockToTarget;
        this.minimumGrowthHeight = builder.minimumGrowthHeight;
        this.maximumGrowthHeight = builder.maximumGrowthHeight;
    }

    public static BiomeTraitDenseTree create(Consumer<Builder> consumer) {
        Builder builder = new Builder();
        consumer.accept(builder);
        return builder.create();
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random random) {
        if (this.logBlock == null || this.leafBlock == null) {
            return false;
        }
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        int height = RandomHelper.getNumberInRange(this.minimumGrowthHeight, this.maximumGrowthHeight, random);
        if (posY >= 1 && posY + height + 1 < 256) {
            int z;
            int x;
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            BlockPos downPos = pos.func_177977_b();
            if (this.blockToTarget != state || pos.func_177956_o() >= world.func_72800_K() - height - 1) {
                return false;
            }
            if (!this.placeTreeOfHeight(world, pos, height)) {
                return false;
            }
            this.onPlantGrow(world, downPos, pos);
            this.onPlantGrow(world, downPos.func_177974_f(), pos);
            this.onPlantGrow(world, downPos.func_177968_d(), pos);
            this.onPlantGrow(world, downPos.func_177968_d().func_177974_f(), pos);
            EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
            int adjustedHeight = height - random.nextInt(4);
            int bonusHeight = 2 - random.nextInt(3);
            int posXOffset = posX;
            int posZOffset = posZ;
            int posYOffset = posY + height - 1;
            for (int localHeight = 0; localHeight < height; ++localHeight) {
                int posYLocal;
                BlockPos offsetPos;
                if (localHeight >= adjustedHeight && bonusHeight > 0) {
                    posXOffset += facing.func_82601_c();
                    posZOffset += facing.func_82599_e();
                    --bonusHeight;
                }
                if (!(state = world.func_180495_p(offsetPos = new BlockPos(posXOffset, posYLocal = posY + localHeight, posZOffset))).func_177230_c().isAir(state, (IBlockAccess)world, offsetPos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, offsetPos)) continue;
                this.placeLogAt(world, offsetPos);
                this.placeLogAt(world, offsetPos.func_177974_f());
                this.placeLogAt(world, offsetPos.func_177968_d());
                this.placeLogAt(world, offsetPos.func_177974_f().func_177968_d());
            }
            for (x = -2; x <= 0; ++x) {
                for (z = -2; z <= 0; ++z) {
                    int y = -1;
                    this.placeLeafAt(world, posXOffset + x, posYOffset + y, posZOffset + z);
                    this.placeLeafAt(world, 1 + posXOffset - x, posYOffset + y, posZOffset + z);
                    this.placeLeafAt(world, posXOffset + x, posYOffset + y, 1 + posZOffset - z);
                    this.placeLeafAt(world, 1 + posXOffset - x, posYOffset + y, 1 + posZOffset - z);
                    if (x <= -2 && z <= -1 || x == -1 && z == -2) continue;
                    y = 1;
                    this.placeLeafAt(world, posXOffset + x, posYOffset + y, posZOffset + z);
                    this.placeLeafAt(world, 1 + posXOffset - x, posYOffset + y, posZOffset + z);
                    this.placeLeafAt(world, posXOffset + x, posYOffset + y, 1 + posZOffset - z);
                    this.placeLeafAt(world, 1 + posXOffset - x, posYOffset + y, 1 + posZOffset - z);
                }
            }
            if (random.nextBoolean()) {
                this.placeLeafAt(world, posXOffset, posYOffset + 2, posZOffset);
                this.placeLeafAt(world, posXOffset + 1, posYOffset + 2, posZOffset);
                this.placeLeafAt(world, posXOffset + 1, posYOffset + 2, posZOffset + 1);
                this.placeLeafAt(world, posXOffset, posYOffset + 2, posZOffset + 1);
            }
            for (x = -3; x <= 4; ++x) {
                for (z = -3; z <= 4; ++z) {
                    if (x == -3 && z == -3 || x == -3 && z == 4 || x == 4 && z == -3 || x == 4 && z == 4 || Math.abs(x) >= 3 && Math.abs(z) >= 3) continue;
                    this.placeLeafAt(world, posXOffset + x, posYOffset, posZOffset + z);
                }
            }
            for (int posXLog = -1; posXLog <= 2; ++posXLog) {
                for (int posZLog = -1; posZLog <= 2; ++posZLog) {
                    int posZLeaf;
                    int posXLeaf;
                    if (posXLog >= 0 && posXLog <= 1 && posZLog >= 0 && posZLog <= 1 || random.nextInt(3) > 0) continue;
                    for (int y = 0; y < random.nextInt(3) + 2; ++y) {
                        this.placeLogAt(world, new BlockPos(posX + posXLog, posYOffset - y - 1, posZ + posZLog));
                    }
                    for (posXLeaf = -1; posXLeaf <= 1; ++posXLeaf) {
                        for (posZLeaf = -1; posZLeaf <= 1; ++posZLeaf) {
                            this.placeLeafAt(world, posXOffset + posXLog + posXLeaf, posYOffset, posZOffset + posZLog + posZLeaf);
                        }
                    }
                    for (posXLeaf = -2; posXLeaf <= 2; ++posXLeaf) {
                        for (posZLeaf = -2; posZLeaf <= 2; ++posZLeaf) {
                            if (Math.abs(posXLeaf) == 2 && Math.abs(posZLeaf) == 2) continue;
                            this.placeLeafAt(world, posXOffset + posXLog + posXLeaf, posYOffset - 1, posZOffset + posZLog + posZLeaf);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().onPlantGrow(state, world, pos, source);
    }

    private void placeLeafAt(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            world.func_175656_a(pos, this.leafBlock);
        }
    }

    private boolean placeTreeOfHeight(World world, BlockPos pos, int height) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int y = 0; y <= height + 1; ++y) {
            int localHeight = 1;
            if (y == 0) {
                localHeight = 0;
            }
            if (y >= height - 1) {
                localHeight = 2;
            }
            for (int x = -localHeight; x <= localHeight; ++x) {
                for (int z = -localHeight; z <= localHeight; ++z) {
                    if (this.isReplaceable(world, (BlockPos)mutableBlockPos.func_181079_c(posX + x, posY + y, posZ + z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static class Builder
    extends BiomeTraitAbstractTree.Builder {
        @Override
        public BiomeTraitDenseTree create() {
            return new BiomeTraitDenseTree(this);
        }
    }
}

