/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.multiblock;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logictechcorp.libraryex.multiblock.IPatternComponent;
import logictechcorp.libraryex.multiblock.PatternElement;
import logictechcorp.libraryex.multiblock.PatternElementOre;
import logictechcorp.libraryex.multiblock.PatternLayer;
import logictechcorp.libraryex.multiblock.PatternRow;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Pattern {
    private static final PatternElement AIR_ELEMENT = new PatternElement(Blocks.field_150350_a.func_176223_P(), ' ');
    private static final PatternElement VOID_ELEMENT = new PatternElement(Blocks.field_189881_dj.func_176223_P(), '*');
    private List<PatternLayer> layers = new ArrayList<PatternLayer>();
    private Map<Character, PatternElement> elements = new HashMap<Character, PatternElement>();

    private Pattern(IPatternComponent ... components) {
        for (IPatternComponent component : components) {
            IPatternComponent.Type type = component.getType();
            if (type == IPatternComponent.Type.LAYER) {
                this.layers.add((PatternLayer)component);
                continue;
            }
            if (type != IPatternComponent.Type.ELEMENT) continue;
            PatternElement element = (PatternElement)component;
            this.elements.put(Character.valueOf(element.getIdentifier()), element);
        }
    }

    public static Pattern createPattern(IPatternComponent ... components) {
        return new Pattern(components);
    }

    public static PatternRow createRow(String sections) {
        return new PatternRow(sections);
    }

    public static PatternLayer createLayer(PatternRow ... rows) {
        return new PatternLayer(rows);
    }

    public static PatternElement createElement(IBlockState state, char identifier) {
        if (state == AIR_ELEMENT.getBlockState() || identifier == AIR_ELEMENT.getIdentifier()) {
            throw new InvalidParameterException("Tried to create a PatternElement with invalid parameters");
        }
        if (state == VOID_ELEMENT.getBlockState() || identifier == VOID_ELEMENT.getIdentifier()) {
            throw new InvalidParameterException("Tried to create a PatternElement with invalid parameters");
        }
        return new PatternElement(state, identifier);
    }

    public static PatternElementOre createElement(IBlockState state, char identifier, String ... ores) {
        if (state == AIR_ELEMENT.getBlockState() || identifier == AIR_ELEMENT.getIdentifier()) {
            throw new InvalidParameterException("Tried to create a PatternElement with invalid parameters");
        }
        if (state == VOID_ELEMENT.getBlockState() || identifier == VOID_ELEMENT.getIdentifier()) {
            throw new InvalidParameterException("Tried to create a PatternElement with invalid parameters");
        }
        return new PatternElementOre(state, identifier, ores);
    }

    public boolean placeInWorld(World world, BlockPos pos, boolean replaceExtraneousBlocks) {
        if (world == null) {
            return false;
        }
        int layerPos = 0;
        for (PatternLayer layer : this.layers) {
            int rowPos = 0;
            for (PatternRow row : layer.getRows()) {
                String sections = row.getSections();
                for (int depth = 0; depth < sections.length(); ++depth) {
                    char identifier = sections.charAt(depth);
                    BlockPos adjustedPos = pos.func_177982_a(rowPos, layerPos, depth);
                    if (identifier == VOID_ELEMENT.getIdentifier()) continue;
                    if (identifier == AIR_ELEMENT.getIdentifier()) {
                        if (!replaceExtraneousBlocks) continue;
                        world.func_175698_g(adjustedPos);
                        continue;
                    }
                    PatternElement element = this.elements.get(Character.valueOf(identifier));
                    if (element == null || !replaceExtraneousBlocks && !element.matches(world.func_180495_p(adjustedPos))) {
                        return false;
                    }
                    if (!replaceExtraneousBlocks && !world.func_175623_d(adjustedPos)) continue;
                    world.func_180501_a(adjustedPos, element.getBlockState(), 3);
                }
                ++rowPos;
            }
            ++layerPos;
        }
        return true;
    }

    public boolean hasFormed(World world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        int layerPos = 0;
        for (PatternLayer layer : this.layers) {
            int rowPos = 0;
            for (PatternRow row : layer.getRows()) {
                String sections = row.getSections();
                for (int depth = 0; depth < sections.length(); ++depth) {
                    PatternElement element;
                    char identifier = sections.charAt(depth);
                    BlockPos adjustedPos = pos.func_177982_a(rowPos, layerPos, depth);
                    if (identifier == VOID_ELEMENT.getIdentifier() || !(identifier == AIR_ELEMENT.getIdentifier() ? !world.func_175623_d(adjustedPos) : (element = this.elements.get(Character.valueOf(identifier))) == null || !element.matches(world.func_180495_p(adjustedPos)))) continue;
                    return false;
                }
                ++rowPos;
            }
            ++layerPos;
        }
        return true;
    }
}

