/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.client.render.block.model;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import logictechcorp.libraryex.block.BlockDynamic;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelDynamic
implements IBakedModel {
    private final IBakedModel originalModel;
    private final BlockDynamic.TexturePlacement texturePlacement;

    public BakedModelDynamic(IBakedModel originalModel, BlockDynamic.TexturePlacement texturePlacement) {
        this.originalModel = originalModel;
        this.texturePlacement = texturePlacement;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long random) {
        ArrayList<BakedQuad> quads;
        ArrayList<BakedQuad> originalQuads = new ArrayList<BakedQuad>(this.originalModel.func_188616_a(state, side, random));
        ArrayList dynamicQuads = new ArrayList(this.getDynamicModel(state).func_188616_a(state, side, random));
        if (this.texturePlacement == BlockDynamic.TexturePlacement.OVER) {
            quads = originalQuads;
            quads.addAll(dynamicQuads);
        } else {
            quads = dynamicQuads;
            quads.addAll(originalQuads);
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.originalModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.originalModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.originalModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.originalModel.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return this.originalModel.func_188617_f();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        return Pair.of((Object)this, (Object)this.originalModel.handlePerspective(type).getRight());
    }

    private IBakedModel getDynamicModel(IBlockState state) {
        IExtendedBlockState extendedState;
        IBlockState stateMask;
        if (state instanceof IExtendedBlockState && (stateMask = (IBlockState)(extendedState = (IExtendedBlockState)state).getValue((IUnlistedProperty)BlockDynamic.DYNAMIC)) != null) {
            Minecraft mc = Minecraft.func_71410_x();
            BlockRendererDispatcher dispatcher = mc.func_175602_ab();
            BlockModelShapes shapes = dispatcher.func_175023_a();
            return shapes.func_178125_b(stateMask);
        }
        return this.originalModel;
    }
}

