/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.event.InputEventHandler;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.recipes.CraftingRecipe;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.ItemType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotMerchantResult;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Mouse;

public class InventoryUtils {
    public static final Field fieldSelectedMerchantRecipe = ReflectionHelper.findField(GuiMerchant.class, (String[])new String[]{"field_147041_z", "selectedMerchantRecipe"});
    public static final Method method_GuiContainer_handleMouseClick = ReflectionHelper.findMethod(GuiContainer.class, (String)"handleMouseClick", (String)"func_184098_a", (Class[])new Class[]{Slot.class, Integer.TYPE, Integer.TYPE, ClickType.class});
    public static final ItemStack EMPTY_STACK = ItemStack.field_190927_a;

    public static void onSlotChangedCraftingGrid(World world, EntityPlayer player, InventoryCrafting inventoryCrafting, InventoryCraftResult inventoryCraftResult) {
        if (Configs.enableClientCraftingFix && world.field_72995_K && player instanceof EntityPlayerSP) {
            ItemStack stack = ItemStack.field_190927_a;
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inventoryCrafting, (World)world);
            if (recipe != null && (recipe.func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || ((EntityPlayerSP)player).func_192035_E().func_193830_f(recipe))) {
                inventoryCraftResult.func_193056_a(recipe);
                stack = recipe.func_77572_b(inventoryCrafting);
            }
            inventoryCraftResult.func_70299_a(0, stack);
        }
    }

    public static String getStackString(ItemStack stack) {
        if (!InventoryUtils.isStackEmpty(stack)) {
            ResourceLocation rl = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
            return String.format("[%s @ %d - display: %s - NBT: %s] (%s)", rl != null ? rl.toString() : "null", stack.func_77960_j(), stack.func_82833_r(), stack.func_77978_p() != null ? stack.func_77978_p().toString() : "<no NBT>", stack.toString());
        }
        return "<empty>";
    }

    public static boolean isValidSlot(Slot slot, GuiContainer gui, boolean requireItems) {
        return gui.field_147002_h != null && gui.field_147002_h.field_75151_b != null && slot != null && gui.field_147002_h.field_75151_b.contains(slot) && (!requireItems || slot.func_75216_d()) && !Configs.SLOT_BLACKLIST.contains(slot.getClass().getName());
    }

    public static boolean isCraftingSlot(GuiContainer gui, Slot slot) {
        return slot != null && CraftingHandler.getCraftingGridSlots(gui, slot) != null;
    }

    public static boolean inventoryExistsAbove(Slot slot, Container container) {
        for (Slot slotTmp : container.field_75151_b) {
            if (slotTmp.field_75221_f >= slot.field_75221_f || InventoryUtils.areSlotsInSameInventory(slot, slotTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean canShiftPlaceItems(GuiContainer gui) {
        if (!GuiScreen.func_146272_n() || Mouse.getEventButton() != 0) {
            return false;
        }
        Slot slot = gui.getSlotUnderMouse();
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stackCursor = mc.field_71439_g.field_71071_by.func_70445_o();
        return slot != null && !InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.isValidSlot(slot, gui, false) && !slot.func_75216_d() && slot.func_75214_a(stackCursor);
    }

    public static boolean tryMoveItems(GuiContainer gui, RecipeStorage recipes, boolean scrollingUp) {
        Slot slot = gui.getSlotUnderMouse();
        Minecraft mc = Minecraft.func_71410_x();
        if (slot == null || !InventoryUtils.isStackEmpty(mc.field_71439_g.field_71071_by.func_70445_o())) {
            return false;
        }
        boolean villagerHandling = Configs.enableScrollingVillager && gui instanceof GuiMerchant && slot instanceof SlotMerchantResult;
        boolean craftingHandling = Configs.enableScrollingCrafting && InventoryUtils.isCraftingSlot(gui, slot);
        boolean isCtrlDown = GuiContainer.func_146271_m();
        boolean isShiftDown = GuiContainer.func_146272_n();
        boolean moveToOtherInventory = scrollingUp;
        if (Configs.useSlotPositionAwareScrollDirection) {
            boolean above = InventoryUtils.inventoryExistsAbove(slot, gui.field_147002_h);
            boolean bl = moveToOtherInventory = above == scrollingUp;
        }
        if (Configs.useSlotPositionAwareScrollDirection && !isShiftDown || Configs.reverseScrollDirectionStacks && isShiftDown) {
            moveToOtherInventory = !moveToOtherInventory;
        }
        if (!InventoryUtils.isValidSlot(slot, gui, !villagerHandling && !craftingHandling)) {
            return false;
        }
        if (craftingHandling) {
            return InventoryUtils.tryMoveItemsCrafting(recipes, slot, gui, moveToOtherInventory, isShiftDown, isCtrlDown);
        }
        if (villagerHandling) {
            return InventoryUtils.tryMoveItemsVillager((GuiMerchant)gui, slot, moveToOtherInventory, isShiftDown);
        }
        if (!Configs.enableScrollingSingle && !isShiftDown && !isCtrlDown || !Configs.enableScrollingStacks && isShiftDown && !isCtrlDown || !Configs.enableScrollingMatchingStacks && !isShiftDown && isCtrlDown || !Configs.enableScrollingEverything && isShiftDown && isCtrlDown) {
            return false;
        }
        if (isShiftDown) {
            if (isCtrlDown) {
                InventoryUtils.tryMoveStacks(slot, gui, false, moveToOtherInventory, false);
            } else {
                InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, true);
            }
            return true;
        }
        if (isCtrlDown) {
            InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, false);
            return true;
        }
        ItemStack stack = slot.func_75211_c();
        if (moveToOtherInventory) {
            return InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
        }
        if (InventoryUtils.getStackSize(stack) < slot.func_178170_b(stack)) {
            return InventoryUtils.tryMoveSingleItemToThisInventory(slot, gui);
        }
        return false;
    }

    public static void dropStacks(GuiContainer gui, ItemStack stackReference, Slot slotReference, boolean sameInventory) {
        if (slotReference != null && !InventoryUtils.isStackEmpty(stackReference)) {
            Container container = gui.field_147002_h;
            stackReference = stackReference.func_77946_l();
            for (Slot slot : container.field_75151_b) {
                if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) != sameInventory || !InventoryUtils.areStacksEqual(slot.func_75211_c(), stackReference)) continue;
                InventoryUtils.dropStack(gui, slot.field_75222_d);
            }
        }
    }

    public static boolean tryMoveItemsVillager(GuiMerchant gui, Slot slot, boolean moveToOtherInventory, boolean fullStacks) {
        if (fullStacks) {
            if (!moveToOtherInventory) {
                InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, true);
            } else if (slot.func_75216_d()) {
                InventoryUtils.tryMoveStacks(slot, (GuiContainer)gui, true, true, true);
            } else {
                InventoryUtils.tryMoveStacks(slot, (GuiContainer)gui, false, true, false);
            }
        } else if (!moveToOtherInventory) {
            InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, false);
        } else if (slot.func_75216_d()) {
            InventoryUtils.moveOneSetOfItemsFromSlotToOtherInventory((GuiContainer)gui, slot);
        }
        return false;
    }

    public static boolean tryMoveSingleItemToOtherInventory(Slot slot, GuiContainer gui) {
        int targetSlot;
        ItemStack stackOrig = slot.func_75211_c();
        Container container = gui.field_147002_h;
        Minecraft mc = Minecraft.func_71410_x();
        if (!InventoryUtils.isStackEmpty(mc.field_71439_g.field_71071_by.func_70445_o()) || !slot.func_82869_a((EntityPlayer)mc.field_71439_g) || InventoryUtils.getStackSize(stackOrig) > 1 && !slot.func_75214_a(stackOrig)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stackOrig) <= stackOrig.func_77976_d()) {
            return InventoryUtils.clickSlotsToMoveSingleItemByShiftClick(gui, slot.field_75222_d);
        }
        ItemStack stack = stackOrig.func_77946_l();
        InventoryUtils.setStackSize(stack, 1);
        ItemStack[] originalStacks = InventoryUtils.getOriginalStacks(container);
        slot.func_75215_d(stack);
        container.func_82846_b((EntityPlayer)mc.field_71439_g, slot.field_75222_d);
        if (!slot.func_75216_d() && (targetSlot = InventoryUtils.getTargetSlot(container, originalStacks)) >= 0) {
            ((Slot)container.field_75151_b.get(targetSlot)).func_75209_a(1);
            InventoryUtils.restoreOriginalStacks(container, originalStacks);
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.field_75222_d, targetSlot);
        }
        slot.func_75215_d(stackOrig);
        return false;
    }

    public static boolean tryMoveAllButOneItemToOtherInventory(Slot slot, GuiContainer gui) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack stackOrig = slot.func_75211_c().func_77946_l();
        if (InventoryUtils.getStackSize(stackOrig) == 1 || InventoryUtils.getStackSize(stackOrig) > stackOrig.func_77976_d() || !slot.func_82869_a((EntityPlayer)player) || !slot.func_75214_a(stackOrig)) {
            return true;
        }
        InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
        ItemStack stackInCursor = player.field_71071_by.func_70445_o();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return false;
        }
        int stackInCursorSizeOrig = InventoryUtils.getStackSize(stackInCursor);
        int tempSlotNum = -1;
        for (Slot slotTmp : gui.field_147002_h.field_75151_b) {
            ItemStack stackInSlot;
            if (slotTmp.field_75222_d == slot.field_75222_d || !InventoryUtils.areSlotsInSameInventory(slotTmp, slot, true) || !slotTmp.func_75214_a(stackInCursor) || !slotTmp.func_82869_a((EntityPlayer)player) || !InventoryUtils.isStackEmpty(stackInSlot = slotTmp.func_75211_c()) && !InventoryUtils.areStacksEqual(stackInSlot, stackInCursor)) continue;
            InventoryUtils.rightClickSlot(gui, slotTmp.field_75222_d);
            stackInCursor = player.field_71071_by.func_70445_o();
            if (!InventoryUtils.isStackEmpty(stackInCursor) && InventoryUtils.getStackSize(stackInCursor) >= stackInCursorSizeOrig) continue;
            tempSlotNum = slotTmp.field_75222_d;
            break;
        }
        if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
        }
        if (tempSlotNum != -1) {
            InventoryUtils.shiftClickSlot(gui, slot.field_75222_d);
            InventoryUtils.rightClickSlot(gui, tempSlotNum);
            InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
            if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
                InventoryUtils.leftClickSlot(gui, tempSlotNum);
            }
            return true;
        }
        boolean treatHotbarAsDifferent = gui.getClass() == GuiInventory.class;
        List<Integer> slots = InventoryUtils.getSlotNumbersOfEmptySlots(gui.field_147002_h, slot, false, treatHotbarAsDifferent, false);
        if (slots.isEmpty()) {
            slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.field_147002_h, slot, false, slot.func_75211_c(), true, treatHotbarAsDifferent, false);
        }
        if (!slots.isEmpty()) {
            InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
            InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
            for (int slotNum : slots) {
                Slot slotTmp = gui.field_147002_h.func_75139_a(slotNum);
                stackInCursor = player.field_71071_by.func_70445_o();
                if (InventoryUtils.isStackEmpty(stackInCursor)) {
                    return true;
                }
                if (!slotTmp.func_75214_a(stackInCursor)) continue;
                InventoryUtils.leftClickSlot(gui, slotNum);
            }
            if (!InventoryUtils.isStackEmpty(stackInCursor)) {
                InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
            }
        }
        return false;
    }

    public static boolean tryMoveSingleItemToThisInventory(Slot slot, GuiContainer gui) {
        Container container = gui.field_147002_h;
        ItemStack stackOrig = slot.func_75211_c();
        Minecraft mc = Minecraft.func_71410_x();
        if (!slot.func_75214_a(stackOrig)) {
            return false;
        }
        for (int slotNum = container.field_75151_b.size() - 1; slotNum >= 0; --slotNum) {
            Slot slotTmp = (Slot)container.field_75151_b.get(slotNum);
            ItemStack stackTmp = slotTmp.func_75211_c();
            if (InventoryUtils.areSlotsInSameInventory(slotTmp, slot) || InventoryUtils.isStackEmpty(stackTmp) || !slotTmp.func_82869_a((EntityPlayer)mc.field_71439_g) || InventoryUtils.getStackSize(stackTmp) != 1 && !slotTmp.func_75214_a(stackTmp) || !InventoryUtils.areStacksEqual(stackTmp, stackOrig)) continue;
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slotTmp.field_75222_d, slot.field_75222_d);
        }
        return false;
    }

    public static void tryMoveStacks(Slot slot, GuiContainer gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        InventoryUtils.tryMoveStacks(slot.func_75211_c(), slot, gui, matchingOnly, toOtherInventory, firstOnly);
    }

    private static void tryMoveStacks(ItemStack stackReference, Slot slot, GuiContainer gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        int maxSlot;
        Container container = gui.field_147002_h;
        for (int i = maxSlot = container.field_75151_b.size() - 1; i >= 0; --i) {
            Slot slotTmp = (Slot)container.field_75151_b.get(i);
            if (slotTmp.field_75222_d == slot.field_75222_d || InventoryUtils.areSlotsInSameInventory(slotTmp, slot) != toOtherInventory || !slotTmp.func_75216_d() || matchingOnly && !InventoryUtils.areStacksEqual(stackReference, slotTmp.func_75211_c())) continue;
            boolean success = InventoryUtils.shiftClickSlotWithCheck(gui, slotTmp.field_75222_d);
            if (!success && Configs.enableScrollingStacksFallback) {
                InventoryUtils.clickSlotsToMoveItemsFromSlot(slotTmp, gui, toOtherInventory);
            }
            if (!firstOnly) continue;
            return;
        }
        if (toOtherInventory && !InventoryUtils.shiftClickSlotWithCheck(gui, slot.field_75222_d)) {
            InventoryUtils.clickSlotsToMoveItemsFromSlot(slot, gui, toOtherInventory);
        }
    }

    private static void tryMoveItemsToMerchantBuySlots(GuiMerchant gui, boolean fillStacks) {
        Minecraft mc = Minecraft.func_71410_x();
        MerchantRecipeList list = gui.func_147035_g().func_70934_b((EntityPlayer)mc.field_71439_g);
        int index = 0;
        try {
            index = fieldSelectedMerchantRecipe.getInt(gui);
        }
        catch (IllegalAccessException e) {
            ItemScroller.logger.warn("Failed to get the value of GuiMerchant.selectedMerchantRecipe");
        }
        if (list == null || list.size() <= index) {
            return;
        }
        MerchantRecipe recipe = (MerchantRecipe)list.get(index);
        if (recipe == null) {
            return;
        }
        ItemStack buy1 = recipe.func_77394_a();
        ItemStack buy2 = recipe.func_77396_b();
        if (!InventoryUtils.isStackEmpty(buy1)) {
            InventoryUtils.fillBuySlot((GuiContainer)gui, 0, buy1, fillStacks);
        }
        if (!InventoryUtils.isStackEmpty(buy2)) {
            InventoryUtils.fillBuySlot((GuiContainer)gui, 1, buy2, fillStacks);
        }
    }

    public static void fillBuySlot(GuiContainer gui, int slotNum, ItemStack buyStack, boolean fillStacks) {
        Slot slot = gui.field_147002_h.func_75139_a(slotNum);
        ItemStack existingStack = slot.func_75211_c();
        Minecraft mc = Minecraft.func_71410_x();
        if (!InventoryUtils.isStackEmpty(existingStack) && !InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.shiftClickSlot(gui, slotNum);
        }
        if (InventoryUtils.isStackEmpty(existingStack = slot.func_75211_c()) || InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.moveItemsFromInventory(gui, slotNum, (IInventory)mc.field_71439_g.field_71071_by, buyStack, fillStacks);
        }
    }

    public static void tryMoveItemsToFirstCraftingGrid(CraftingRecipe recipe, GuiContainer gui, boolean fillStacks) {
        Slot craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, craftingOutputSlot, gui, fillStacks);
        }
    }

    public static void loadRecipeItemsToGridForOutputSlotUnderMouse(CraftingRecipe recipe, GuiContainer gui) {
        Slot slot = gui.getSlotUnderMouse();
        InventoryUtils.loadRecipeItemsToGridForOutputSlot(recipe, gui, slot);
    }

    public static void loadRecipeItemsToGridForOutputSlot(CraftingRecipe recipe, GuiContainer gui, @Nullable Slot outputSlot) {
        if (outputSlot != null && InventoryUtils.isCraftingSlot(gui, outputSlot) && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, outputSlot, gui, false);
        }
    }

    private static boolean tryMoveItemsCrafting(RecipeStorage recipes, Slot slot, GuiContainer gui, boolean moveToOtherInventory, boolean isShiftDown, boolean isCtrlDown) {
        block9: {
            block11: {
                CraftingRecipe recipe;
                block7: {
                    block10: {
                        block8: {
                            recipe = recipes.getSelectedRecipe();
                            if (!isShiftDown) break block7;
                            if (moveToOtherInventory) break block8;
                            if (InventoryUtils.isStackEmpty(recipes.getSelectedRecipe().getResult())) break block9;
                            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
                            break block9;
                        }
                        if (!slot.func_75216_d()) break block10;
                        if (isCtrlDown) {
                            InventoryUtils.craftAsManyItemsAsPossible(recipe, slot, gui);
                        } else {
                            InventoryUtils.shiftClickSlot(gui, slot.field_75222_d);
                        }
                        break block9;
                    }
                    CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
                    if (range == null) break block9;
                    int i = 0;
                    int s = range.getFirst();
                    while (i < range.getSlotCount()) {
                        InventoryUtils.shiftClickSlot(gui, s);
                        ++i;
                        ++s;
                    }
                    break block9;
                }
                if (moveToOtherInventory) break block11;
                if (InventoryUtils.isStackEmpty(recipes.getSelectedRecipe().getResult())) break block9;
                InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, false);
                break block9;
            }
            if (slot.func_75216_d()) {
                InventoryUtils.moveOneSetOfItemsFromSlotToOtherInventory(gui, slot);
            } else {
                CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
                if (range != null) {
                    int i = 0;
                    int s = range.getFirst();
                    while (i < range.getSlotCount()) {
                        InventoryUtils.shiftClickSlot(gui, s);
                        ++i;
                        ++s;
                    }
                }
            }
        }
        return false;
    }

    private static void craftAsManyItemsAsPossible(CraftingRecipe recipe, Slot slot, GuiContainer gui) {
        ItemStack result = recipe.getResult();
        for (int failSafe = 1024; failSafe > 0 && slot.func_75216_d() && InventoryUtils.areStacksEqual(slot.func_75211_c(), result); --failSafe) {
            InventoryUtils.shiftClickSlot(gui, slot.field_75222_d);
            if (slot.func_75216_d() && InventoryUtils.areStacksEqual(slot.func_75211_c(), result)) break;
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
        }
    }

    public static void clearFirstCraftingGridOfItems(CraftingRecipe recipe, GuiContainer gui, boolean clearNonMatchingOnly) {
        Slot craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, craftingOutputSlot);
            InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, clearNonMatchingOnly);
        }
    }

    public static void clearFirstCraftingGridOfAllItems(GuiContainer gui) {
        Slot craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, craftingOutputSlot);
            InventoryUtils.clearCraftingGridOfAllItems(gui, range);
        }
    }

    private static boolean clearCraftingGridOfItems(CraftingRecipe recipe, GuiContainer gui, CraftingHandler.SlotRange range, boolean clearNonMatchingOnly) {
        int invSlots = gui.field_147002_h.field_75151_b.size();
        int rangeSlots = range.getSlotCount();
        int recipeSize = recipe.getRecipeLength();
        int slotCount = Math.min(rangeSlots, recipeSize);
        int i = 0;
        for (int slotNum = range.getFirst(); i < slotCount && slotNum < invSlots; ++i, ++slotNum) {
            Slot slotTmp = gui.field_147002_h.func_75139_a(slotNum);
            if (slotTmp == null || !slotTmp.func_75216_d() || clearNonMatchingOnly && InventoryUtils.areStacksEqual(recipe.getRecipeItems()[i], slotTmp.func_75211_c())) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.func_75216_d()) continue;
            return false;
        }
        return true;
    }

    private static boolean clearCraftingGridOfAllItems(GuiContainer gui, CraftingHandler.SlotRange range) {
        int invSlots = gui.field_147002_h.field_75151_b.size();
        int rangeSlots = range.getSlotCount();
        boolean clearedAll = true;
        int i = 0;
        for (int slotNum = range.getFirst(); i < rangeSlots && slotNum < invSlots; ++i, ++slotNum) {
            Slot slotTmp = gui.field_147002_h.func_75139_a(slotNum);
            if (slotTmp == null || !slotTmp.func_75216_d()) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.func_75216_d()) continue;
            clearedAll = false;
        }
        return clearedAll;
    }

    private static boolean tryMoveItemsToCraftingGridSlots(CraftingRecipe recipe, Slot slot, GuiContainer gui, boolean fillStacks) {
        Container container = gui.field_147002_h;
        int numSlots = container.field_75151_b.size();
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null && range.getLast() < numSlots && recipe.getRecipeLength() <= range.getSlotCount()) {
            if (!InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, true)) {
                return false;
            }
            Slot slotGridFirst = container.func_75139_a(range.getFirst());
            Map<ItemType, List<Integer>> ingredientSlots = ItemType.getSlotsPerItem(recipe.getRecipeItems());
            for (Map.Entry<ItemType, List<Integer>> entry : ingredientSlots.entrySet()) {
                ItemStack ingredientReference = entry.getKey().getStack();
                List<Integer> recipeSlots = entry.getValue();
                ArrayList<Integer> targetSlots = new ArrayList<Integer>();
                for (int s : recipeSlots) {
                    targetSlots.add(s + range.getFirst());
                }
                if (fillStacks) {
                    InventoryUtils.fillCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
                    continue;
                }
                InventoryUtils.moveOneRecipeItemIntoCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
            }
        }
        return false;
    }

    public static void fillCraftingGrid(GuiContainer gui, Slot slotGridFirst, ItemStack ingredientReference, List<Integer> targetSlots) {
        Container container = gui.field_147002_h;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        int slotNum = -1;
        int slotReturn = -1;
        int sizeOrig = 0;
        if (InventoryUtils.isStackEmpty(ingredientReference)) {
            return;
        }
        while ((slotNum = InventoryUtils.getSlotNumberOfLargestMatchingStackFromDifferentInventory(container, slotGridFirst, ingredientReference)) >= 0) {
            if (slotReturn == -1) {
                slotReturn = slotNum;
            }
            InventoryUtils.leftClickSlot(gui, slotNum);
            ItemStack stackCursor = player.field_71071_by.func_70445_o();
            if (!InventoryUtils.areStacksEqual(ingredientReference, stackCursor)) break;
            sizeOrig = InventoryUtils.getStackSize(stackCursor);
            InventoryUtils.dragSplitItemsIntoSlots(gui, targetSlots);
            stackCursor = player.field_71071_by.func_70445_o();
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                if (InventoryUtils.getStackSize(stackCursor) >= sizeOrig) break;
                InventoryUtils.leftClickSlot(gui, slotReturn);
                if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
                    slotReturn = slotNum;
                    InventoryUtils.leftClickSlot(gui, slotReturn);
                }
            }
            if (InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    public static void rightClickCraftOneStack(GuiContainer gui) {
        Slot slot = gui.getSlotUnderMouse();
        Minecraft mc = Minecraft.func_71410_x();
        InventoryPlayer inv = mc.field_71439_g.field_71071_by;
        ItemStack stackCursor = inv.func_70445_o();
        if (slot == null || !slot.func_75216_d() || !InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.areStacksEqual(slot.func_75211_c(), stackCursor)) {
            return;
        }
        int sizeLast = 0;
        while (true) {
            InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
            stackCursor = inv.func_70445_o();
            if (InventoryUtils.isStackEmpty(stackCursor) || InventoryUtils.getStackSize(stackCursor) <= sizeLast || InventoryUtils.getStackSize(stackCursor) >= stackCursor.func_77976_d() || !InventoryUtils.areStacksEqual(slot.func_75211_c(), stackCursor)) break;
            sizeLast = InventoryUtils.getStackSize(stackCursor);
        }
    }

    public static void craftEverythingPossibleWithCurrentRecipe(CraftingRecipe recipe, GuiContainer gui) {
        CraftingHandler.SlotRange range;
        Slot slot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (slot != null && !InventoryUtils.isStackEmpty(recipe.getResult()) && (range = CraftingHandler.getCraftingGridSlots(gui, slot)) != null) {
            if (!InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, false)) {
                return;
            }
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
            if (slot.func_75216_d()) {
                InventoryUtils.craftAsManyItemsAsPossible(recipe, slot, gui);
            }
        }
    }

    public static void moveAllCraftingResultsToOtherInventory(CraftingRecipe recipe, GuiContainer gui) {
        if (!InventoryUtils.isStackEmpty(recipe.getResult())) {
            Slot slot = null;
            ItemStack stackResult = recipe.getResult().func_77946_l();
            for (Slot slotTmp : gui.field_147002_h.field_75151_b) {
                if (!InventoryUtils.areStacksEqual(slotTmp.func_75211_c(), stackResult) || !InventoryUtils.inventoryExistsAbove(slotTmp, gui.field_147002_h)) continue;
                slot = slotTmp;
                break;
            }
            if (slot != null) {
                List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.field_147002_h, slot, true, stackResult, false, false, false);
                for (int slotNum : slots) {
                    InventoryUtils.shiftClickSlot(gui, slotNum);
                }
            }
        }
    }

    public static void throwAllCraftingResultsToGround(CraftingRecipe recipe, GuiContainer gui) {
        Slot slot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (slot != null && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            InventoryUtils.dropStacks(gui, recipe.getResult(), slot, false);
        }
    }

    private static int putSingleItemIntoSlots(GuiContainer gui, List<Integer> targetSlots, int startIndex) {
        int slotNum;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stackInCursor = mc.field_71439_g.field_71071_by.func_70445_o();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return 0;
        }
        int numSlots = gui.field_147002_h.field_75151_b.size();
        int numItems = InventoryUtils.getStackSize(stackInCursor);
        int loops = Math.min(numItems, targetSlots.size() - startIndex);
        int count = 0;
        for (int i = 0; i < loops && (slotNum = targetSlots.get(startIndex + i).intValue()) < numSlots; ++i) {
            InventoryUtils.rightClickSlot(gui, slotNum);
            ++count;
        }
        return count;
    }

    public static void moveOneSetOfItemsFromSlotToOtherInventory(GuiContainer gui, Slot slot) {
        List<Integer> slots;
        InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stackCursor = mc.field_71439_g.field_71071_by.func_70445_o();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.moveItemFromCursorToSlots(gui, slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.field_147002_h, slot, false, stackCursor, true, true, false))) {
            slots = InventoryUtils.getSlotNumbersOfEmptySlots(gui.field_147002_h, slot, false, true, false);
            InventoryUtils.moveItemFromCursorToSlots(gui, slots);
        }
    }

    public static void moveOneRecipeItemIntoCraftingGrid(GuiContainer gui, Slot slotGridFirst, ItemStack ingredientReference, List<Integer> targetSlots) {
        int filled;
        Container container = gui.field_147002_h;
        Minecraft mc = Minecraft.func_71410_x();
        int slotNum = -1;
        int slotCount = targetSlots.size();
        for (int index = 0; index < slotCount && (slotNum = InventoryUtils.getSlotNumberOfSmallestStackFromDifferentInventory(container, slotGridFirst, ingredientReference, slotCount)) >= 0; index += filled) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.areStacksEqual(ingredientReference, mc.field_71439_g.field_71071_by.func_70445_o())) break;
            filled = InventoryUtils.putSingleItemIntoSlots(gui, targetSlots, index);
            if (filled >= 1) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(mc.field_71439_g.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    private static boolean moveItemFromCursorToSlots(GuiContainer gui, List<Integer> slotNumbers) {
        Minecraft mc = Minecraft.func_71410_x();
        InventoryPlayer inv = mc.field_71439_g.field_71071_by;
        for (int slotNum : slotNumbers) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.isStackEmpty(inv.func_70445_o())) continue;
            return true;
        }
        return false;
    }

    private static void moveItemsFromInventory(GuiContainer gui, int slotTo, IInventory invSrc, ItemStack stackTemplate, boolean fillStacks) {
        Container container = gui.field_147002_h;
        for (Slot slot : container.field_75151_b) {
            if (slot == null || slot.field_75224_c != invSrc || !InventoryUtils.areStacksEqual(stackTemplate, slot.func_75211_c())) continue;
            if (fillStacks) {
                if (InventoryUtils.clickSlotsToMoveItems(gui, slot.field_75222_d, slotTo)) continue;
                break;
            }
            InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.field_75222_d, slotTo);
            break;
        }
    }

    private static int getSlotNumberOfLargestMatchingStackFromDifferentInventory(Container container, Slot slotReference, ItemStack stackReference) {
        int slotNum = -1;
        int largest = 0;
        for (Slot slot : container.field_75151_b) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.func_75216_d() || !InventoryUtils.areStacksEqual(stackReference, slot.func_75211_c()) || (stackSize = InventoryUtils.getStackSize(slot.func_75211_c())) <= largest) continue;
            slotNum = slot.field_75222_d;
            largest = stackSize;
        }
        return slotNum;
    }

    private static int getSlotNumberOfSmallestStackFromDifferentInventory(Container container, Slot slotReference, ItemStack stackReference, int idealSize) {
        int slotNum = -1;
        int smallest = Integer.MAX_VALUE;
        for (Slot slot : container.field_75151_b) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.func_75216_d() || !InventoryUtils.areStacksEqual(stackReference, slot.func_75211_c()) || (stackSize = InventoryUtils.getStackSize(slot.func_75211_c())) >= smallest || stackSize < idealSize) continue;
            slotNum = slot.field_75222_d;
            smallest = stackSize;
        }
        if (slotNum == -1) {
            int largest = 0;
            for (Slot slot : container.field_75151_b) {
                int stackSize;
                if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.func_75216_d() || !InventoryUtils.areStacksEqual(stackReference, slot.func_75211_c()) || (stackSize = InventoryUtils.getStackSize(slot.func_75211_c())) <= largest) continue;
                slotNum = slot.field_75222_d;
                largest = stackSize;
            }
        }
        return slotNum;
    }

    private static List<Integer> getSlotNumbersOfMatchingStacks(Container container, Slot slotReference, boolean sameInventory, ItemStack stackReference, boolean preferPartial, boolean treatHotbarAsDifferent, boolean reverse) {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.field_75151_b.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            Slot slot = container.func_75139_a(i);
            if (slot != null && slot.func_75216_d() && InventoryUtils.areSlotsInSameInventory(slot, slotReference, treatHotbarAsDifferent) == sameInventory && InventoryUtils.areStacksEqual(slot.func_75211_c(), stackReference)) {
                if (InventoryUtils.getStackSize(slot.func_75211_c()) < stackReference.func_77976_d() == preferPartial) {
                    slots.add(0, slot.field_75222_d);
                } else {
                    slots.add(slot.field_75222_d);
                }
            }
            i += increment;
        }
        return slots;
    }

    private static List<Integer> getSlotNumbersOfEmptySlots(Container container, Slot slotReference, boolean sameInventory, boolean treatHotbarAsDifferent, boolean reverse) {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.field_75151_b.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            Slot slot = container.func_75139_a(i);
            if (slot != null && !slot.func_75216_d() && InventoryUtils.areSlotsInSameInventory(slot, slotReference, treatHotbarAsDifferent) == sameInventory) {
                slots.add(slot.field_75222_d);
            }
            i += increment;
        }
        return slots;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private static boolean areSlotsInSameInventory(Slot slot1, Slot slot2) {
        return InventoryUtils.areSlotsInSameInventory(slot1, slot2, false);
    }

    private static boolean areSlotsInSameInventory(Slot slot1, Slot slot2, boolean treatHotbarAsDifferent) {
        if (slot1.isSameInventory(slot2)) {
            if (treatHotbarAsDifferent && slot1.field_75224_c instanceof InventoryPlayer) {
                int index1 = slot1.getSlotIndex();
                int index2 = slot2.getSlotIndex();
                return index1 == 40 || index2 == 40 || index1 < 9 == index2 < 9;
            }
            return true;
        }
        return false;
    }

    private static ItemStack[] getOriginalStacks(Container container) {
        ItemStack[] originalStacks = new ItemStack[container.field_75151_b.size()];
        for (int i = 0; i < originalStacks.length; ++i) {
            originalStacks[i] = ((Slot)container.field_75151_b.get(i)).func_75211_c().func_77946_l();
        }
        return originalStacks;
    }

    private static void restoreOriginalStacks(Container container, ItemStack[] originalStacks) {
        for (int i = 0; i < originalStacks.length; ++i) {
            ItemStack stackSlot = container.func_75139_a(i).func_75211_c();
            if (InventoryUtils.areStacksEqual(stackSlot, originalStacks[i]) && (InventoryUtils.isStackEmpty(stackSlot) || InventoryUtils.getStackSize(stackSlot) == InventoryUtils.getStackSize(originalStacks[i]))) continue;
            container.func_75141_a(i, originalStacks[i]);
        }
    }

    private static int getTargetSlot(Container container, ItemStack[] originalStacks) {
        List slots = container.field_75151_b;
        for (int i = 0; i < originalStacks.length; ++i) {
            ItemStack stackOrig = originalStacks[i];
            ItemStack stackNew = ((Slot)slots.get(i)).func_75211_c();
            if ((!InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew)) && (InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew) || InventoryUtils.getStackSize(stackNew) != InventoryUtils.getStackSize(stackOrig) + 1)) continue;
            return i;
        }
        return -1;
    }

    private static void clickSlotsToMoveItemsFromSlot(Slot slotFrom, GuiContainer gui, boolean toOtherInventory) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        InventoryUtils.leftClickSlot(gui, slotFrom.field_75222_d);
        if (InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            return;
        }
        for (Slot slotDst : gui.field_147002_h.field_75151_b) {
            ItemStack stackDst = slotDst.func_75211_c();
            if (InventoryUtils.areSlotsInSameInventory(slotDst, slotFrom) != toOtherInventory && (InventoryUtils.isStackEmpty(stackDst) || InventoryUtils.areStacksEqual(stackDst, player.field_71071_by.func_70445_o()))) {
                InventoryUtils.leftClickSlot(gui, slotDst.field_75222_d);
            }
            if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) continue;
            return;
        }
        if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.field_75222_d);
        }
    }

    private static boolean clickSlotsToMoveSingleItem(GuiContainer gui, int slotFrom, int slotTo) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = ((Slot)gui.field_147002_h.field_75151_b.get(slotFrom)).func_75211_c();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.rightClickSlot(gui, slotFrom);
        } else {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        InventoryUtils.rightClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(mc.field_71439_g.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveSingleItemByShiftClick(GuiContainer gui, int slotFrom) {
        Minecraft mc = Minecraft.func_71410_x();
        Slot slot = (Slot)gui.field_147002_h.field_75151_b.get(slotFrom);
        ItemStack stack = slot.func_75211_c();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
            if (slot.func_75216_d()) {
                InventoryUtils.leftClickSlot(gui, slotFrom);
                return false;
            }
            InventoryUtils.rightClickSlot(gui, slotFrom);
        }
        InventoryUtils.shiftClickSlot(gui, slotFrom);
        if (!InventoryUtils.isStackEmpty(mc.field_71439_g.field_71071_by.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveItems(GuiContainer gui, int slotFrom, int slotTo) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        InventoryUtils.leftClickSlot(gui, slotFrom);
        if (InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            return false;
        }
        boolean ret = true;
        int size = InventoryUtils.getStackSize(player.field_71071_by.func_70445_o());
        InventoryUtils.leftClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(player.field_71071_by.func_70445_o())) {
            ret = InventoryUtils.getStackSize(player.field_71071_by.func_70445_o()) != size;
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return ret;
    }

    private static boolean shiftClickSlotWithCheck(GuiContainer gui, int slotNum) {
        Slot slot = gui.field_147002_h.func_75139_a(slotNum);
        if (slot == null || !slot.func_75216_d()) {
            return false;
        }
        int sizeOrig = InventoryUtils.getStackSize(slot.func_75211_c());
        InventoryUtils.shiftClickSlot(gui, slotNum);
        return !slot.func_75216_d() || InventoryUtils.getStackSize(slot.func_75211_c()) != sizeOrig;
    }

    public static boolean tryMoveItemsVertically(GuiContainer gui, Slot slot, RecipeStorage recipes, boolean moveUp, InputEventHandler.MoveAmount amount) {
        if (slot == null || !InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) {
            return false;
        }
        boolean villagerHandling = Configs.enableScrollingVillager && gui instanceof GuiMerchant && slot instanceof SlotMerchantResult;
        boolean craftingHandling = Configs.enableScrollingCrafting && InventoryUtils.isCraftingSlot(gui, slot);
        boolean isCtrlDown = GuiContainer.func_146271_m();
        if (craftingHandling) {
            return InventoryUtils.tryMoveItemsCrafting(recipes, slot, gui, !moveUp, amount == InputEventHandler.MoveAmount.MOVE_ALL, isCtrlDown);
        }
        if (villagerHandling) {
            return InventoryUtils.tryMoveItemsVillager((GuiMerchant)gui, slot, !moveUp, amount == InputEventHandler.MoveAmount.MOVE_ALL);
        }
        List<Integer> slots = InventoryUtils.getVerticallyFurthestSuitableSlotsForStackInSlot(gui.field_147002_h, slot, moveUp);
        if (slots.isEmpty()) {
            return false;
        }
        if (amount == InputEventHandler.MoveAmount.MOVE_ALL) {
            InventoryUtils.moveStackToSlots(gui, slot, slots, false);
        } else if (amount == InputEventHandler.MoveAmount.MOVE_ONE) {
            InventoryUtils.moveOneItemToFirstValidSlot(gui, slot, slots);
        } else if (amount == InputEventHandler.MoveAmount.LEAVE_ONE) {
            InventoryUtils.moveStackToSlots(gui, slot, slots, true);
        }
        return true;
    }

    private static void moveStackToSlots(GuiContainer gui, Slot slotFrom, List<Integer> slotsTo, boolean leaveOne) {
        InventoryPlayer inv = gui.field_146297_k.field_71439_g.field_71071_by;
        InventoryUtils.leftClickSlot(gui, slotFrom.field_75222_d);
        if (leaveOne) {
            InventoryUtils.rightClickSlot(gui, slotFrom.field_75222_d);
        }
        for (int slotNum : slotsTo) {
            if (InventoryUtils.isStackEmpty(inv.func_70445_o())) break;
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
        if (!InventoryUtils.isStackEmpty(inv.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.field_75222_d);
        }
    }

    private static void moveOneItemToFirstValidSlot(GuiContainer gui, Slot slotFrom, List<Integer> slotsTo) {
        InventoryPlayer inv = gui.field_146297_k.field_71439_g.field_71071_by;
        InventoryUtils.rightClickSlot(gui, slotFrom.field_75222_d);
        if (InventoryUtils.isStackEmpty(inv.func_70445_o())) {
            return;
        }
        int sizeOrig = InventoryUtils.getStackSize(inv.func_70445_o());
        for (int slotNum : slotsTo) {
            InventoryUtils.rightClickSlot(gui, slotNum);
            ItemStack stackCursor = inv.func_70445_o();
            if (!InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.getStackSize(stackCursor) == sizeOrig) continue;
            break;
        }
        if (!InventoryUtils.isStackEmpty(inv.func_70445_o())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.field_75222_d);
        }
    }

    private static List<Integer> getVerticallyFurthestSuitableSlotsForStackInSlot(Container container, Slot slot, boolean above) {
        if (slot == null || !slot.func_75216_d()) {
            return Collections.emptyList();
        }
        ArrayList<SlotVerticalSorter> slotSorters = new ArrayList<SlotVerticalSorter>();
        ItemStack stackSlot = slot.func_75211_c();
        for (Slot slotTmp : container.field_75151_b) {
            ItemStack stackTmp;
            if (slotTmp.field_75222_d == slot.field_75222_d || slotTmp.field_75221_f == slot.field_75221_f || above != slotTmp.field_75221_f < slot.field_75221_f || (!InventoryUtils.isStackEmpty(stackTmp = slotTmp.func_75211_c()) || !slotTmp.func_75214_a(stackSlot)) && (!InventoryUtils.areStacksEqual(stackTmp, stackSlot) || slotTmp.func_178170_b(stackTmp) <= InventoryUtils.getStackSize(stackTmp))) continue;
            slotSorters.add(new SlotVerticalSorter(slotTmp));
        }
        Collections.sort(slotSorters);
        if (!above) {
            Collections.reverse(slotSorters);
        }
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (SlotVerticalSorter entry : slotSorters) {
            slots.add(entry.getSlot().field_75222_d);
        }
        return slots;
    }

    public static void clickSlot(GuiContainer gui, int slotNum, int mouseButton, ClickType type) {
        if (slotNum >= 0 && slotNum < gui.field_147002_h.field_75151_b.size()) {
            Slot slot = gui.field_147002_h.func_75139_a(slotNum);
            InventoryUtils.clickSlot(gui, slot, slotNum, mouseButton, type);
        } else {
            try {
                gui.field_146297_k.field_71442_b.func_187098_a(gui.field_147002_h.field_75152_c, slotNum, mouseButton, type, (EntityPlayer)gui.field_146297_k.field_71439_g);
            }
            catch (Exception e) {
                ItemScroller.logger.warn("Exception while emulating a slot click: gui: '{}', slotNum: {}, mouseButton; {}, ClickType: {}", (Object)gui.getClass().getName(), (Object)slotNum, (Object)mouseButton, (Object)type, (Object)e);
            }
        }
    }

    public static void clickSlot(GuiContainer gui, Slot slot, int slotNum, int mouseButton, ClickType type) {
        try {
            method_GuiContainer_handleMouseClick.invoke((Object)gui, slot, slotNum, mouseButton, type);
        }
        catch (Exception e) {
            ItemScroller.logger.warn("Exception while emulating a slot click: gui: '{}', slotNum: {}, mouseButton; {}, ClickType: {}", (Object)gui.getClass().getName(), (Object)slotNum, (Object)mouseButton, (Object)type, (Object)e);
        }
    }

    public static void leftClickSlot(GuiContainer gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, ClickType.PICKUP);
    }

    public static void rightClickSlot(GuiContainer gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 1, ClickType.PICKUP);
    }

    public static void shiftClickSlot(GuiContainer gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, ClickType.QUICK_MOVE);
    }

    public static void dropItemsFromCursor(GuiContainer gui) {
        InventoryUtils.clickSlot(gui, -999, 0, ClickType.PICKUP);
    }

    public static void dropStack(GuiContainer gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 1, ClickType.THROW);
    }

    private static void dragSplitItemsIntoSlots(GuiContainer gui, List<Integer> targetSlots) {
        int slotNum;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stackInCursor = mc.field_71439_g.field_71071_by.func_70445_o();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return;
        }
        if (targetSlots.size() == 1) {
            InventoryUtils.leftClickSlot(gui, targetSlots.get(0));
            return;
        }
        int numSlots = gui.field_147002_h.field_75151_b.size();
        int loops = targetSlots.size();
        InventoryUtils.clickSlot(gui, -999, 0, ClickType.QUICK_CRAFT);
        for (int i = 0; i < loops && (slotNum = targetSlots.get(i).intValue()) < numSlots; ++i) {
            InventoryUtils.clickSlot(gui, targetSlots.get(i), 1, ClickType.QUICK_CRAFT);
        }
        InventoryUtils.clickSlot(gui, -999, 2, ClickType.QUICK_CRAFT);
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return stack.func_190926_b();
    }

    public static int getStackSize(ItemStack stack) {
        return stack.func_190916_E();
    }

    public static void setStackSize(ItemStack stack, int size) {
        stack.func_190920_e(size);
    }

    private static class SlotVerticalSorter
    implements Comparable<SlotVerticalSorter> {
        private final Slot slot;

        public SlotVerticalSorter(Slot slot) {
            this.slot = slot;
        }

        public Slot getSlot() {
            return this.slot;
        }

        @Override
        public int compareTo(SlotVerticalSorter other) {
            if (this.getSlot().field_75221_f == other.getSlot().field_75221_f) {
                return this.getSlot().field_75222_d < other.getSlot().field_75222_d ? -1 : 1;
            }
            return this.getSlot().field_75221_f < other.getSlot().field_75221_f ? -1 : 1;
        }
    }
}

