/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.event.InputEventHandler;
import fi.dy.masa.itemscroller.recipes.CraftingRecipe;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public class RenderEventHandler {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private static final Vec3d LIGHT0_POS = new Vec3d(0.2, 1.0, -0.7).func_72432_b();
    private static final Vec3d LIGHT1_POS = new Vec3d(-0.2, 1.0, 0.7).func_72432_b();
    private ScaledResolution scaledResolution;

    public static RenderEventHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onDrawBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (InputEventHandler.getInstance().isRecipeViewOpen() && mc.field_71462_r instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)mc.field_71462_r;
            RecipeStorage recipes = InputEventHandler.getInstance().getRecipes();
            int count = recipes.getRecipeCount();
            gui.field_146297_k.field_71466_p.func_78276_b("Item Scroller quick crafting", 4, 4, -1061109568);
            for (int recipeId = 0; recipeId < count; ++recipeId) {
                this.renderStoredRecipeStack(recipeId, count, recipes.getRecipe(recipeId).getResult(), gui, mc, recipeId == recipes.getSelection());
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (InputEventHandler.getInstance().isRecipeViewOpen() && mc.field_71462_r instanceof GuiContainer) {
            int mouseY;
            GuiContainer gui = (GuiContainer)mc.field_71462_r;
            RecipeStorage recipes = InputEventHandler.getInstance().getRecipes();
            int mouseX = this.getMouseX();
            int recipeId = this.getHoveredRecipeId(mouseX, mouseY = this.getMouseY(), recipes, gui, mc);
            if (recipeId >= 0) {
                CraftingRecipe recipe = recipes.getRecipe(recipeId);
                if (Configs.craftingRenderRecipeItems) {
                    this.renderRecipeItems(recipe, recipes.getRecipeCount(), gui, mc);
                }
                this.renderHoverTooltip(mouseX, mouseY, recipe, gui, mc);
            } else if (Configs.craftingRenderRecipeItems) {
                CraftingRecipe recipe = recipes.getSelectedRecipe();
                this.renderRecipeItems(recipe, recipes.getRecipeCount(), gui, mc);
                ItemStack stack = this.getHoveredRecipeIngredient(mouseX, mouseY, recipe, recipes.getRecipeCount(), gui, mc);
                if (!InventoryUtils.isStackEmpty(stack)) {
                    this.renderStackToolTip(mouseX, mouseY, stack, gui, mc);
                }
            }
        }
    }

    public ScaledResolution getScaledResolution() {
        if (this.scaledResolution == null) {
            this.scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        }
        return this.scaledResolution;
    }

    public int getMouseX() {
        ScaledResolution scaledresolution = this.getScaledResolution();
        int w = scaledresolution.func_78326_a();
        return Mouse.getX() * w / Minecraft.func_71410_x().field_71443_c;
    }

    public int getMouseY() {
        ScaledResolution scaledresolution = this.getScaledResolution();
        int h = scaledresolution.func_78328_b();
        return h - Mouse.getY() * h / Minecraft.func_71410_x().field_71440_d - 1;
    }

    private void renderHoverTooltip(int mouseX, int mouseY, CraftingRecipe recipe, GuiContainer gui, Minecraft mc) {
        ItemStack stack = recipe.getResult();
        if (!InventoryUtils.isStackEmpty(stack)) {
            this.renderStackToolTip(mouseX, mouseY, stack, gui, mc);
        }
    }

    public int getHoveredRecipeId(int mouseX, int mouseY, RecipeStorage recipes, GuiContainer gui, Minecraft mc) {
        if (InputEventHandler.getInstance().isRecipeViewOpen()) {
            ScaledResolution scaledResolution = new ScaledResolution(mc);
            int gap = 40;
            int recipesPerColumn = 9;
            int stackBaseHeight = 16;
            int usableHeight = scaledResolution.func_78328_b() - 80;
            int entryHeight = usableHeight / 9;
            float scale = (float)entryHeight / 20.0f;
            int stackScaledSize = (int)(16.0f * scale);
            int recipeCount = recipes.getRecipeCount();
            for (int recipeId = 0; recipeId < recipeCount; ++recipeId) {
                int columnOffsetCount = recipeCount / 9 - recipeId / 9;
                float x = (float)gui.getGuiLeft() - ((float)columnOffsetCount + 0.2f) * (float)stackScaledSize - (float)(columnOffsetCount - 1) * scale * 20.0f;
                int y = (int)(40.0f + 0.25f * (float)stackScaledSize + (float)(recipeId % 9 * entryHeight));
                if (!((float)mouseX >= x) || !((float)mouseX < x + (float)stackScaledSize) || mouseY < y || mouseY >= y + stackScaledSize) continue;
                return recipeId;
            }
        }
        return -1;
    }

    private void renderStoredRecipeStack(int recipeId, int recipeCount, ItemStack stack, GuiContainer gui, Minecraft mc, boolean selected) {
        FontRenderer font = RenderEventHandler.getFontRenderer(mc, stack);
        String indexStr = String.valueOf(recipeId + 1);
        int strWidth = font.func_78256_a(indexStr);
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int verticalGap = 40;
        int recipesPerColumn = 9;
        int stackBaseHeight = 16;
        int usableHeight = scaledResolution.func_78328_b() - 80;
        int entryHeight = usableHeight / 9;
        float scale = (float)entryHeight / 20.0f;
        int stackScaledSize = (int)(16.0f * scale);
        int columnOffsetCount = recipeCount / 9 - recipeId / 9;
        float x = (float)gui.getGuiLeft() - ((float)columnOffsetCount + 0.2f) * (float)stackScaledSize - (float)(columnOffsetCount - 1) * scale * 20.0f;
        float y = 40.0f + 0.25f * (float)stackScaledSize + (float)(recipeId % 9 * entryHeight);
        this.renderStackAt(stack, x, y, selected, scale, 16, mc);
        font.func_78276_b(indexStr, (int)(x - scale * (float)strWidth), (int)(y + (float)((entryHeight - font.field_78288_b) / 2) - 2.0f), 0xC0C0C0);
    }

    private void renderRecipeItems(CraftingRecipe recipe, int recipeCount, GuiContainer gui, Minecraft mc) {
        RecipeLocation location = this.getRecipeLocation(recipe, recipeCount, gui, mc);
        ItemStack[] items = recipe.getRecipeItems();
        int i = 0;
        for (int row = 0; row < location.recipeDimensions; ++row) {
            int col = 0;
            while (col < location.recipeDimensions) {
                float xOff = (float)col * ((float)(location.stackBaseHeight + 1) * location.scale);
                float yOff = (float)row * ((float)(location.stackBaseHeight + 1) * location.scale);
                this.renderStackAt(items[i], location.x + xOff, location.y + yOff, false, location.scale, location.stackBaseHeight, mc);
                ++col;
                ++i;
            }
        }
    }

    private RecipeLocation getRecipeLocation(CraftingRecipe recipe, int recipeCount, GuiContainer gui, Minecraft mc) {
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int verticalGap = 40;
        int recipesPerColumn = 9;
        int stackBaseHeight = 16;
        int usableHeight = scaledResolution.func_78328_b() - 80;
        int entryHeight = usableHeight / 9;
        float scale = (float)entryHeight / 20.0f;
        int stackScaledSize = (int)(16.0f * scale);
        int columnOffsetCount = recipeCount / 9;
        int recipeDimensions = (int)Math.ceil(Math.sqrt(recipe.getRecipeLength()));
        float x = (float)gui.getGuiLeft() - ((float)columnOffsetCount + 0.2f) * (float)stackScaledSize - (float)(columnOffsetCount - 1) * scale * 20.0f - (float)(17 * (recipeDimensions + 1)) * scale;
        float y = (float)(scaledResolution.func_78328_b() / 2) - (float)(17 * recipeDimensions) * scale * 0.5f;
        return new RecipeLocation(x, y, scale, 16, recipeDimensions);
    }

    private ItemStack getHoveredRecipeIngredient(int mouseX, int mouseY, CraftingRecipe recipe, int recipeCount, GuiContainer gui, Minecraft mc) {
        RecipeLocation location = this.getRecipeLocation(recipe, recipeCount, gui, mc);
        float stackWidth = location.scale * (float)location.stackBaseHeight;
        int i = 0;
        for (int row = 0; row < location.recipeDimensions; ++row) {
            int col = 0;
            while (col < location.recipeDimensions) {
                float xOff = (float)col * ((float)(location.stackBaseHeight + 1) * location.scale);
                float yOff = (float)row * ((float)(location.stackBaseHeight + 1) * location.scale);
                float xStart = location.x + xOff;
                float yStart = location.y + yOff;
                if ((float)mouseX >= xStart && (float)mouseX <= xStart + stackWidth && (float)mouseY >= yStart && (float)mouseY <= yStart + stackWidth) {
                    return recipe.getRecipeItems()[i];
                }
                ++col;
                ++i;
            }
        }
        return ItemStack.field_190927_a;
    }

    private void renderStackAt(ItemStack stack, float x, float y, boolean border, float scale, int stackBaseHeight, Minecraft mc) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179140_f();
        int w = stackBaseHeight;
        if (border) {
            Gui.func_73734_a((int)0, (int)0, (int)w, (int)1, (int)-1);
            Gui.func_73734_a((int)0, (int)0, (int)1, (int)w, (int)-1);
            Gui.func_73734_a((int)(w - 1), (int)0, (int)w, (int)w, (int)-1);
            Gui.func_73734_a((int)0, (int)(w - 1), (int)w, (int)w, (int)-1);
            Gui.func_73734_a((int)1, (int)1, (int)(w - 1), (int)(w - 1), (int)0x20FFFFFF);
        } else {
            Gui.func_73734_a((int)0, (int)0, (int)w, (int)w, (int)0x20FFFFFF);
        }
        if (!InventoryUtils.isStackEmpty(stack)) {
            RenderEventHandler.enableGUIStandardItemLighting(scale);
            stack = stack.func_77946_l();
            InventoryUtils.setStackSize(stack, 1);
            mc.func_175599_af().field_77023_b += 100.0f;
            mc.func_175599_af().func_184391_a((EntityLivingBase)mc.field_71439_g, stack, 0, 0);
            mc.func_175599_af().field_77023_b -= 100.0f;
        }
        GlStateManager.func_179084_k();
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    public static void enableGUIStandardItemLighting(float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)165.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderEventHandler.enableStandardItemLighting(scale);
        GlStateManager.func_179121_F();
    }

    public static void enableStandardItemLighting(float scale) {
        GlStateManager.func_179145_e();
        GlStateManager.func_179085_a((int)0);
        GlStateManager.func_179085_a((int)1);
        GlStateManager.func_179142_g();
        GlStateManager.func_179104_a((int)1032, (int)5634);
        GlStateManager.func_187438_a((int)16384, (int)4611, (FloatBuffer)RenderHelper.func_74521_a((float)((float)RenderEventHandler.LIGHT0_POS.field_72450_a), (float)((float)RenderEventHandler.LIGHT0_POS.field_72448_b), (float)((float)RenderEventHandler.LIGHT0_POS.field_72449_c), (float)0.0f));
        float lightStrength = 0.3f * scale;
        GlStateManager.func_187438_a((int)16384, (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)lightStrength, (float)lightStrength, (float)lightStrength, (float)1.0f));
        GlStateManager.func_187438_a((int)16384, (int)4608, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16384, (int)4610, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4611, (FloatBuffer)RenderHelper.func_74521_a((float)((float)RenderEventHandler.LIGHT1_POS.field_72450_a), (float)((float)RenderEventHandler.LIGHT1_POS.field_72448_b), (float)((float)RenderEventHandler.LIGHT1_POS.field_72449_c), (float)0.0f));
        GlStateManager.func_187438_a((int)16385, (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)lightStrength, (float)lightStrength, (float)lightStrength, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4608, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4610, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_179103_j((int)7424);
        float ambientLightStrength = 0.4f;
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)ambientLightStrength, (float)ambientLightStrength, (float)ambientLightStrength, (float)1.0f));
    }

    private static FontRenderer getFontRenderer(Minecraft mc, ItemStack stack) {
        FontRenderer fontRenderer = null;
        if (!InventoryUtils.isStackEmpty(stack)) {
            fontRenderer = stack.func_77973_b().getFontRenderer(stack);
        }
        return fontRenderer != null ? fontRenderer : mc.field_71466_p;
    }

    private void renderStackToolTip(int x, int y, ItemStack stack, GuiContainer gui, Minecraft mc) {
        List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        FontRenderer font = RenderEventHandler.getFontRenderer(mc, stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        GuiUtils.drawHoveringText((List)list, (int)x, (int)y, (int)gui.field_146294_l, (int)gui.field_146295_m, (int)-1, (FontRenderer)font);
        GuiUtils.postItemToolTip();
    }

    private static class RecipeLocation {
        public final float x;
        public final float y;
        public final float scale;
        public final int stackBaseHeight;
        public final int recipeDimensions;

        public RecipeLocation(float x, float y, float scale, int stackBaseHeight, int recipeDimensions) {
            this.x = x;
            this.y = y;
            this.scale = scale;
            this.stackBaseHeight = stackBaseHeight;
            this.recipeDimensions = recipeDimensions;
        }
    }
}

