/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.event.RenderEventHandler;
import fi.dy.masa.itemscroller.proxy.ClientProxy;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MethodHandleUtils;
import java.lang.invoke.MethodHandle;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.SlotItemHandler;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class InputEventHandler {
    private static final InputEventHandler INSTANCE = new InputEventHandler();
    private boolean disabled;
    private int lastPosX;
    private int lastPosY;
    private int slotNumberLast;
    private final Set<Integer> draggedSlots = new HashSet<Integer>();
    private WeakReference<Slot> sourceSlotCandidate = new WeakReference<Object>(null);
    private WeakReference<Slot> sourceSlot = new WeakReference<Object>(null);
    private ItemStack stackInCursorLast = InventoryUtils.EMPTY_STACK;
    private RecipeStorage recipes;
    private static final MethodHandle methodHandle_getSlotAtPosition = MethodHandleUtils.getMethodHandleVirtual(GuiContainer.class, new String[]{"func_146975_c", "getSlotAtPosition"}, Integer.TYPE, Integer.TYPE);

    private InputEventHandler() {
        this.initializeRecipeStorage();
    }

    public static InputEventHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onMouseInputEventPre(GuiScreenEvent.MouseInputEvent.Pre event) {
        GuiScreen guiScreen = event.getGui();
        Minecraft mc = guiScreen.field_146297_k;
        if (!this.disabled && guiScreen instanceof GuiContainer && mc != null && mc.field_71439_g != null && !Configs.GUI_BLACKLIST.contains(guiScreen.getClass().getName())) {
            GuiContainer gui = (GuiContainer)guiScreen;
            int dWheel = Mouse.getEventDWheel();
            boolean cancel = false;
            if (gui instanceof GuiContainerCreative) {
                if ((dWheel == 0 && Configs.enableDragMovingShiftLeft || Configs.enableDragMovingShiftRight || Configs.enableDragMovingControlLeft) && this.dragMoveItems(gui, mc)) {
                    event.setCanceled(true);
                }
                return;
            }
            if (dWheel != 0) {
                if (this.isRecipeViewOpen()) {
                    this.recipes.scrollSelection(dWheel < 0);
                } else {
                    cancel = InventoryUtils.tryMoveItems(gui, this.recipes, dWheel > 0);
                }
            } else {
                Slot slot = gui.getSlotUnderMouse();
                boolean isLeftClick = InputEventHandler.mouseEventIsLeftClick(mc);
                boolean isRightClick = InputEventHandler.mouseEventIsRightClick(mc);
                boolean isPickBlock = InputEventHandler.mouseEventIsPickBlock(mc);
                boolean isButtonDown = Mouse.getEventButtonState();
                if (isButtonDown && (isLeftClick || isRightClick || isPickBlock)) {
                    int mouseX = RenderEventHandler.getInstance().getMouseX();
                    int mouseY = RenderEventHandler.getInstance().getMouseY();
                    int hoveredRecipeId = RenderEventHandler.getInstance().getHoveredRecipeId(mouseX, mouseY, this.recipes, gui, mc);
                    if (hoveredRecipeId >= 0) {
                        if (isLeftClick || isRightClick) {
                            boolean changed;
                            boolean bl = changed = this.recipes.getSelection() != hoveredRecipeId;
                            if (isLeftClick) {
                                this.recipes.changeSelectedRecipe(hoveredRecipeId);
                                if (changed) {
                                    InventoryUtils.clearFirstCraftingGridOfItems(this.recipes.getSelectedRecipe(), gui, false);
                                }
                            }
                            InventoryUtils.tryMoveItemsToFirstCraftingGrid(this.recipes.getRecipe(hoveredRecipeId), gui, GuiScreen.func_146272_n());
                        } else if (isPickBlock) {
                            InventoryUtils.clearFirstCraftingGridOfAllItems(gui);
                        }
                        event.setCanceled(true);
                        return;
                    }
                    if (isPickBlock && this.isRecipeViewOpen() && InventoryUtils.isCraftingSlot(gui, slot)) {
                        this.recipes.storeCraftingRecipeToCurrentSelection(slot, gui, true);
                        cancel = true;
                    }
                }
                this.checkForItemPickup(mc);
                this.storeSourceSlotCandidate(slot, gui, mc);
                if (Configs.enableRightClickCraftingOneStack && isRightClick && isButtonDown && InventoryUtils.isCraftingSlot(gui, slot)) {
                    InventoryUtils.rightClickCraftOneStack(gui);
                } else if (Configs.enableShiftPlaceItems && InventoryUtils.canShiftPlaceItems(gui)) {
                    cancel |= this.shiftPlaceItems(slot, gui);
                } else if (Configs.enableShiftDropItems && this.canShiftDropItems(gui, mc)) {
                    cancel |= this.shiftDropItems(gui);
                } else if (Configs.enableAltShiftClickEverything && isLeftClick && isButtonDown && GuiScreen.func_175283_s() && GuiScreen.func_146272_n() && slot != null && !InventoryUtils.isStackEmpty(slot.func_75211_c())) {
                    InventoryUtils.tryMoveStacks(slot, gui, false, true, false);
                    cancel = true;
                } else if (Configs.enableAltClickMatching && isLeftClick && Mouse.getEventButtonState() && GuiScreen.func_175283_s() && slot != null && !InventoryUtils.isStackEmpty(slot.func_75211_c())) {
                    InventoryUtils.tryMoveStacks(slot, gui, true, true, false);
                    cancel = true;
                } else if (Configs.enableDragMovingShiftLeft || Configs.enableDragMovingShiftRight || Configs.enableDragMovingControlLeft) {
                    cancel |= this.dragMoveItems(gui, mc);
                } else if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0 && this.shouldMoveVertically()) {
                    MoveType type = this.getDragMoveType(mc);
                    MoveAmount amount = this.getDragMoveAmount(type, mc);
                    InventoryUtils.tryMoveItemsVertically(gui, slot, this.recipes, Keyboard.isKeyDown((int)17), amount);
                    this.slotNumberLast = -1;
                    cancel = true;
                }
            }
            if (cancel) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onKeyInputEventPre(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen guiScreen = mc.field_71462_r;
        if (mc == null || mc.field_71439_g == null || !(guiScreen instanceof GuiContainer)) {
            return;
        }
        int eventKey = Keyboard.getEventKey();
        GuiContainer gui = (GuiContainer)guiScreen;
        Slot slot = gui.getSlotUnderMouse();
        if (Keyboard.getEventKeyState() && GuiScreen.func_175283_s() && GuiScreen.func_146272_n() && GuiScreen.func_146271_m()) {
            if (eventKey == 46) {
                InventoryUtils.craftEverythingPossibleWithCurrentRecipe(this.recipes.getSelectedRecipe(), gui);
            } else if (eventKey == 20) {
                InventoryUtils.throwAllCraftingResultsToGround(this.recipes.getSelectedRecipe(), gui);
            } else if (eventKey == 50) {
                InventoryUtils.moveAllCraftingResultsToOtherInventory(this.recipes.getSelectedRecipe(), gui);
            } else if (eventKey == 23) {
                if (slot != null) {
                    InputEventHandler.debugPrintSlotInfo(gui, slot);
                } else {
                    ItemScroller.logger.info("GUI class: {}", (Object)gui.getClass().getName());
                }
            }
        }
        if (Configs.enableControlShiftDropkeyDropItems && Keyboard.getEventKeyState() && !Configs.GUI_BLACKLIST.contains(gui.getClass().getName()) && GuiScreen.func_146271_m() && GuiScreen.func_146272_n() && eventKey == mc.field_71474_y.field_74316_C.func_151463_i()) {
            if (slot != null && slot.func_75216_d()) {
                InventoryUtils.dropStacks(gui, slot.func_75211_c(), slot, true);
            }
        } else if (Keyboard.getEventKeyState() && ClientProxy.KEY_DISABLE.isActiveAndMatches(Keyboard.getEventKey())) {
            boolean bl = this.disabled = !this.disabled;
            if (this.disabled) {
                mc.field_71439_g.func_184185_a(SoundEvents.field_187679_dF, 0.8f, 0.8f);
            } else {
                mc.field_71439_g.func_184185_a(SoundEvents.field_189107_dL, 0.5f, 1.0f);
            }
        } else if (Keyboard.getEventKeyState() && this.isRecipeViewOpen() && eventKey >= 2 && eventKey <= 10) {
            int index = MathHelper.func_76125_a((int)(eventKey - 2), (int)0, (int)8);
            this.recipes.changeSelectedRecipe(index);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.recipes.readFromDisk();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (Configs.craftingRecipesStoreToFile) {
            this.recipes.writeToDisk();
        }
    }

    public boolean isRecipeViewOpen() {
        int keyCode = ClientProxy.KEY_RECIPE.func_151463_i();
        return keyCode > 0 && keyCode < 256 && Keyboard.isKeyDown((int)keyCode) && ClientProxy.KEY_RECIPE.getKeyModifier().isActive(ClientProxy.KEY_RECIPE.getKeyConflictContext());
    }

    public void initializeRecipeStorage() {
        this.recipes = new RecipeStorage(18, Configs.craftingScrollingSaveFileIsGlobal);
    }

    public RecipeStorage getRecipes() {
        return this.recipes;
    }

    private void storeSourceSlotCandidate(Slot slot, GuiContainer gui, Minecraft mc) {
        if (slot != null && Mouse.getEventButtonState() && (InputEventHandler.mouseEventIsLeftClick(mc) || InputEventHandler.mouseEventIsRightClick(mc))) {
            ItemStack stackCursor = mc.field_71439_g.field_71071_by.func_70445_o();
            ItemStack stack = InventoryUtils.EMPTY_STACK;
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                stack = new ItemStack(stackCursor.func_77973_b(), InventoryUtils.getStackSize(stackCursor), stackCursor.func_77960_j());
            }
            this.stackInCursorLast = stack;
            this.sourceSlotCandidate = new WeakReference<Slot>(slot);
        }
    }

    private void checkForItemPickup(Minecraft mc) {
        ItemStack stackCursor = mc.field_71439_g.field_71071_by.func_70445_o();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !stackCursor.func_77969_a(this.stackInCursorLast)) {
            this.sourceSlot = new WeakReference(this.sourceSlotCandidate.get());
        }
    }

    private static void debugPrintSlotInfo(GuiContainer gui, Slot slot) {
        if (slot == null) {
            ItemScroller.logger.info("slot was null");
            return;
        }
        boolean hasSlot = gui.field_147002_h.field_75151_b.contains(slot);
        IInventory inv = slot instanceof SlotItemHandler ? ((SlotItemHandler)slot).getItemHandler() : slot.field_75224_c;
        String stackStr = InventoryUtils.getStackString(slot.func_75211_c());
        ItemScroller.logger.info(String.format("slot: slotNumber: %d, getSlotIndex(): %d, getHasStack(): %s, slot class: %s, inv class: %s, Container's slot list has slot: %s, stack: %s", slot.field_75222_d, slot.getSlotIndex(), slot.func_75216_d(), slot.getClass().getName(), inv != null ? inv.getClass().getName() : "<null>", hasSlot ? " true" : "false", stackStr));
    }

    private boolean shiftPlaceItems(Slot slot, GuiContainer gui) {
        InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
        this.draggedSlots.add(slot.field_75222_d);
        InventoryUtils.tryMoveStacks(slot, gui, true, false, false);
        return true;
    }

    private boolean shiftDropItems(GuiContainer gui) {
        ItemStack stackReference = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!InventoryUtils.isStackEmpty(stackReference)) {
            stackReference = stackReference.func_77946_l();
            InventoryUtils.dropItemsFromCursor(gui);
            InventoryUtils.dropStacks(gui, stackReference, (Slot)this.sourceSlot.get(), true);
            return true;
        }
        return false;
    }

    private boolean canShiftDropItems(GuiContainer gui, Minecraft mc) {
        if (GuiScreen.func_146272_n() && InputEventHandler.mouseEventIsLeftClick(mc) && !InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) {
            int left = gui.getGuiLeft();
            int top = gui.getGuiTop();
            int xSize = gui.getXSize();
            int ySize = gui.getYSize();
            int mouseAbsX = Mouse.getEventX() * gui.field_146294_l / gui.field_146297_k.field_71443_c;
            int mouseAbsY = gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / gui.field_146297_k.field_71440_d - 1;
            boolean isOutsideGui = mouseAbsX < left || mouseAbsY < top || mouseAbsX >= left + xSize || mouseAbsY >= top + ySize;
            return isOutsideGui && this.getSlotAtPosition(gui, mouseAbsX - left, mouseAbsY - top) == null;
        }
        return false;
    }

    private boolean dragMoveItems(GuiContainer gui, Minecraft mc) {
        int mouseX = Mouse.getEventX() * gui.field_146294_l / mc.field_71443_c;
        int mouseY = gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / mc.field_71440_d - 1;
        if (!InventoryUtils.isStackEmpty(mc.field_71439_g.field_71071_by.func_70445_o())) {
            this.lastPosX = mouseX;
            this.lastPosY = mouseY;
            return false;
        }
        MoveType type = this.getDragMoveType(mc);
        MoveAmount amount = this.getDragMoveAmount(type, mc);
        boolean cancel = false;
        if (Mouse.getEventButtonState()) {
            this.slotNumberLast = -1;
            cancel = this.dragMoveFromSlotAtPosition(gui, mouseX, mouseY, type, amount);
        }
        if (!cancel) {
            int absY;
            int distX = mouseX - this.lastPosX;
            int distY = mouseY - this.lastPosY;
            int absX = Math.abs(distX);
            if (absX > (absY = Math.abs(distY))) {
                int inc = distX > 0 ? 1 : -1;
                int x = this.lastPosX;
                while (true) {
                    int y = absX != 0 ? this.lastPosY + (x - this.lastPosX) * distY / absX : mouseY;
                    this.dragMoveFromSlotAtPosition(gui, x, y, type, amount);
                    if (x != mouseX) {
                        x += inc;
                        continue;
                    }
                    break;
                }
            } else {
                int inc = distY > 0 ? 1 : -1;
                int y = this.lastPosY;
                while (true) {
                    int x = absY != 0 ? this.lastPosX + (y - this.lastPosY) * distX / absY : mouseX;
                    this.dragMoveFromSlotAtPosition(gui, x, y, type, amount);
                    if (y == mouseY) break;
                    y += inc;
                }
            }
        }
        this.lastPosX = mouseX;
        this.lastPosY = mouseY;
        Slot slot = this.getSlotAtPosition(gui, mouseX, mouseY);
        if (slot != null) {
            if (gui instanceof GuiContainerCreative) {
                int slotNumber;
                boolean isPlayerInv = ((GuiContainerCreative)gui).func_147056_g() == CreativeTabs.field_78036_m.func_78021_a();
                this.slotNumberLast = slotNumber = isPlayerInv ? slot.getSlotIndex() : slot.field_75222_d;
            } else {
                this.slotNumberLast = slot.field_75222_d;
            }
        } else {
            this.slotNumberLast = -1;
        }
        boolean leftButtonDown = Mouse.isButtonDown((int)0);
        boolean rightButtonDown = Mouse.isButtonDown((int)1);
        if (!leftButtonDown && !rightButtonDown) {
            this.draggedSlots.clear();
        }
        return cancel;
    }

    private MoveType getDragMoveType(Minecraft mc) {
        boolean eitherMouseButtonDown;
        boolean leftButtonDown = Mouse.isButtonDown((int)0);
        boolean rightButtonDown = Mouse.isButtonDown((int)1);
        boolean isShiftDown = GuiScreen.func_146272_n();
        boolean isControlDown = GuiScreen.func_146271_m();
        boolean bl = eitherMouseButtonDown = leftButtonDown || rightButtonDown;
        if (leftButtonDown ^ rightButtonDown) {
            if (this.shouldMoveVertically()) {
                if (Keyboard.isKeyDown((int)17)) {
                    return MoveType.MOVE_UP;
                }
                if (Keyboard.isKeyDown((int)31)) {
                    return MoveType.MOVE_DOWN;
                }
            } else if (isShiftDown ^ isControlDown) {
                boolean dropKeyDown;
                int dropKey = mc.field_71474_y.field_74316_C.func_151463_i();
                boolean bl2 = dropKey > 0 ? Keyboard.isKeyDown((int)dropKey) : (dropKeyDown = dropKey + 100 < Mouse.getButtonCount() && Mouse.isButtonDown((int)(dropKey + 100)));
                if (dropKeyDown && (isShiftDown && Configs.enableDragDroppingStacks || isControlDown && Configs.enableDragDroppingSingle)) {
                    return MoveType.DROP;
                }
                if (isShiftDown && leftButtonDown && Configs.enableDragMovingShiftLeft || isShiftDown && rightButtonDown && Configs.enableDragMovingShiftRight || isControlDown && eitherMouseButtonDown && Configs.enableDragMovingControlLeft) {
                    return MoveType.MOVE_TO_OTHER;
                }
            }
        }
        return MoveType.INVALID;
    }

    private MoveAmount getDragMoveAmount(MoveType type, Minecraft mc) {
        boolean leftButtonDown = Mouse.isButtonDown((int)0);
        boolean rightButtonDown = Mouse.isButtonDown((int)1);
        boolean isShiftDown = GuiScreen.func_146272_n();
        boolean isControlDown = GuiScreen.func_146271_m();
        if (leftButtonDown ^ rightButtonDown) {
            if (isShiftDown ^ isControlDown) {
                if (isControlDown && !isShiftDown) {
                    return MoveAmount.MOVE_ONE;
                }
                if (rightButtonDown && isShiftDown) {
                    return MoveAmount.LEAVE_ONE;
                }
                if (leftButtonDown && isShiftDown) {
                    return MoveAmount.MOVE_ALL;
                }
            } else if (leftButtonDown && !isShiftDown && !isControlDown && (type == MoveType.MOVE_UP || type == MoveType.MOVE_DOWN) && Mouse.getEventButtonState()) {
                return MoveAmount.MOVE_ALL;
            }
        }
        return MoveAmount.INVALID;
    }

    private boolean dragMoveFromSlotAtPosition(GuiContainer gui, int x, int y, MoveType type, MoveAmount amount) {
        boolean cancel;
        if (gui instanceof GuiContainerCreative) {
            return this.dragMoveFromSlotAtPositionCreative(gui, x, y, type, amount);
        }
        Slot slot = this.getSlotAtPosition(gui, x, y);
        Minecraft mc = Minecraft.func_71410_x();
        boolean flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.func_82869_a((EntityPlayer)mc.field_71439_g);
        boolean bl = cancel = flag && (amount == MoveAmount.LEAVE_ONE || amount == MoveAmount.MOVE_ONE);
        if (flag && slot.field_75222_d != this.slotNumberLast && (amount != MoveAmount.MOVE_ONE || !this.draggedSlots.contains(slot.field_75222_d))) {
            if (type == MoveType.MOVE_TO_OTHER) {
                if (amount == MoveAmount.MOVE_ONE) {
                    InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
                } else if (amount == MoveAmount.LEAVE_ONE) {
                    InventoryUtils.tryMoveAllButOneItemToOtherInventory(slot, gui);
                } else {
                    InventoryUtils.shiftClickSlot(gui, slot.field_75222_d);
                    cancel = true;
                }
            } else if (type == MoveType.MOVE_UP || type == MoveType.MOVE_DOWN) {
                InventoryUtils.tryMoveItemsVertically(gui, slot, this.recipes, Keyboard.isKeyDown((int)17), amount);
                cancel = true;
            } else if (type == MoveType.DROP) {
                if (amount == MoveAmount.MOVE_ONE) {
                    InventoryUtils.clickSlot(gui, slot.field_75222_d, 0, ClickType.THROW);
                } else if (amount == MoveAmount.LEAVE_ONE) {
                    InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
                    InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
                    InventoryUtils.dropItemsFromCursor(gui);
                } else {
                    InventoryUtils.clickSlot(gui, slot.field_75222_d, 1, ClickType.THROW);
                    cancel = true;
                }
            }
            this.draggedSlots.add(slot.field_75222_d);
        }
        return cancel;
    }

    private boolean dragMoveFromSlotAtPositionCreative(GuiContainer gui, int x, int y, MoveType type, MoveAmount amount) {
        int slotNumber;
        boolean isPlayerInv;
        GuiContainerCreative guiCreative = (GuiContainerCreative)gui;
        Slot slot = this.getSlotAtPosition(gui, x, y);
        boolean bl = isPlayerInv = guiCreative.func_147056_g() == CreativeTabs.field_78036_m.func_78021_a();
        if (slot == null || slot.getClass() != Slot.class && !isPlayerInv) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.func_82869_a((EntityPlayer)mc.field_71439_g);
        boolean cancel = flag && (amount == MoveAmount.LEAVE_ONE || amount == MoveAmount.MOVE_ONE);
        int n = slotNumber = isPlayerInv ? slot.getSlotIndex() : slot.field_75222_d;
        if (flag && slotNumber != this.slotNumberLast && !this.draggedSlots.contains(slotNumber)) {
            if (type == MoveType.MOVE_TO_OTHER) {
                if (amount == MoveAmount.MOVE_ONE) {
                    this.leftClickSlot((GuiContainer)guiCreative, slot, slotNumber);
                    this.rightClickSlot((GuiContainer)guiCreative, slot, slotNumber);
                    this.shiftClickSlot((GuiContainer)guiCreative, slot, slotNumber);
                    this.leftClickSlot((GuiContainer)guiCreative, slot, slotNumber);
                    cancel = true;
                } else if (amount == MoveAmount.LEAVE_ONE) {
                    if (!isPlayerInv) {
                        this.leftClickSlot((GuiContainer)guiCreative, slot, slotNumber);
                        this.rightClickSlot((GuiContainer)guiCreative, slot, slotNumber);
                        Slot slotFirst = (Slot)gui.field_147002_h.field_75151_b.get(0);
                        this.leftClickSlot((GuiContainer)guiCreative, slotFirst, slotFirst.field_75222_d);
                    }
                    cancel = true;
                } else {
                    this.shiftClickSlot(gui, slot, slotNumber);
                    cancel = true;
                }
            } else if (type == MoveType.DROP) {
                if (amount == MoveAmount.MOVE_ONE) {
                    InventoryUtils.clickSlot(gui, slot.field_75222_d, 0, ClickType.THROW);
                } else if (amount == MoveAmount.LEAVE_ONE) {
                    InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
                    InventoryUtils.rightClickSlot(gui, slot.field_75222_d);
                    InventoryUtils.dropItemsFromCursor(gui);
                } else {
                    InventoryUtils.clickSlot(gui, slot.field_75222_d, 1, ClickType.THROW);
                    cancel = true;
                }
            }
            this.draggedSlots.add(slotNumber);
        }
        return cancel;
    }

    private boolean shouldMoveVertically() {
        return Configs.enableWSClicking && (Keyboard.isKeyDown((int)17) || Keyboard.isKeyDown((int)31));
    }

    public static boolean mouseEventIsLeftClick(Minecraft mc) {
        return Mouse.getEventButton() == mc.field_71474_y.field_74312_F.func_151463_i() + 100;
    }

    public static boolean mouseEventIsRightClick(Minecraft mc) {
        return Mouse.getEventButton() == mc.field_71474_y.field_74313_G.func_151463_i() + 100;
    }

    public static boolean mouseEventIsPickBlock(Minecraft mc) {
        return Mouse.getEventButton() == mc.field_71474_y.field_74322_I.func_151463_i() + 100;
    }

    private void leftClickSlot(GuiContainer gui, Slot slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 0, ClickType.PICKUP);
    }

    private void rightClickSlot(GuiContainer gui, Slot slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 1, ClickType.PICKUP);
    }

    private void shiftClickSlot(GuiContainer gui, Slot slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 0, ClickType.QUICK_MOVE);
    }

    private Slot getSlotAtPosition(GuiContainer gui, int x, int y) {
        try {
            return methodHandle_getSlotAtPosition.invokeExact(gui, x, y);
        }
        catch (Throwable e) {
            ItemScroller.logger.error("Error while trying invoke GuiContainer#getSlotAtPosition() from {}", (Object)gui.getClass().getSimpleName(), (Object)e);
            return null;
        }
    }

    public static enum MoveType {
        INVALID,
        MOVE_TO_OTHER,
        MOVE_TO_THIS,
        MOVE_UP,
        MOVE_DOWN,
        DROP;

    }

    public static enum MoveAmount {
        INVALID,
        MOVE_ONE,
        MOVE_ALL,
        LEAVE_ONE;

    }
}

