/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfcnei.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;

public class Metrics {
    private static final int REVISION = 8;
    private static final String BASE_URL = "http://report.mcstats.org";
    private static final String REPORT_URL = "/plugin/%s";
    private static final int PING_INTERVAL = 15;
    private final String modname;
    private final String modversion;
    private final Set<Graph> graphs = Collections.synchronizedSet(new HashSet());
    private final Configuration configuration;
    private final File configurationFile;
    private final String guid;
    private final boolean debug;
    private Thread thrd = null;
    private boolean firstPost = true;
    private int tickCount;

    public Metrics(String modname, String modversion) throws IOException {
        if (modname == null || modversion == null) {
            throw new IllegalArgumentException("modname and modversion cannot be null");
        }
        this.modname = modname;
        this.modversion = modversion;
        this.configurationFile = this.getConfigFile();
        this.configuration = new Configuration(this.configurationFile);
        this.configuration.get("general", "opt-out", false, "Set to true to disable all reporting");
        this.guid = this.configuration.get("general", "guid", UUID.randomUUID().toString(), "Server unique ID").getString();
        this.debug = this.configuration.get("general", "debug", false, "Set to true for verbose debug").getBoolean(false);
        this.configuration.save();
    }

    public Graph createGraph(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Graph name cannot be null");
        }
        Graph graph = new Graph(name);
        this.graphs.add(graph);
        return graph;
    }

    public void addGraph(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph cannot be null");
        }
        this.graphs.add(graph);
    }

    public boolean start() {
        if (this.isOptOut()) {
            return false;
        }
        FMLCommonHandler.instance().bus().register((Object)this);
        return true;
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent tick) {
        if (tick.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.isOptOut()) {
            for (Graph graph : this.graphs) {
                graph.onOptOut();
            }
            FMLCommonHandler.instance().bus().unregister((Object)this);
            return;
        }
        ++this.tickCount;
        if (this.tickCount % (this.firstPost ? 100 : 18000) != 0) {
            return;
        }
        this.tickCount = 0;
        if (this.thrd == null) {
            this.thrd = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Metrics.this.postPlugin(!Metrics.this.firstPost);
                        Metrics.this.firstPost = false;
                    }
                    catch (IOException e) {
                        if (Metrics.this.debug) {
                            FMLLog.info((String)"[Metrics] Exception - %s", (Object[])new Object[]{e.getMessage()});
                        }
                    }
                    finally {
                        Metrics.this.thrd = null;
                    }
                }
            });
            this.thrd.start();
        }
    }

    public void stop() {
        FMLCommonHandler.instance().bus().unregister((Object)this);
    }

    private boolean isOptOut() {
        this.configuration.load();
        return this.configuration.get("general", "opt-out", false).getBoolean(false);
    }

    public void enable() throws IOException {
        if (this.isOptOut()) {
            this.configuration.getCategory("general").get("opt-out").set("false");
            this.configuration.save();
        }
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void disable() throws IOException {
        if (!this.isOptOut()) {
            this.configuration.getCategory("general").get("opt-out").set("true");
            this.configuration.save();
        }
        FMLCommonHandler.instance().bus().unregister((Object)this);
    }

    private File getConfigFile() {
        return new File(Loader.instance().getConfigDir(), "PluginMetrics.cfg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPlugin(boolean isPing) throws IOException {
        String pluginName = this.modname;
        boolean onlineMode = MinecraftServer.func_71276_C().func_71266_T();
        String pluginVersion = this.modversion;
        String serverVersion = MinecraftServer.func_71276_C().func_71262_S() ? "MinecraftForge (MC: " + MinecraftServer.func_71276_C().func_71249_w() + ")" : "MinecraftForgeSSP (MC: " + MinecraftServer.func_71276_C().func_71249_w() + ")";
        int playersOnline = MinecraftServer.func_71276_C().func_71233_x();
        StringBuilder json = new StringBuilder(1024);
        json.append('{');
        Metrics.appendJSONPair(json, "guid", this.guid);
        Metrics.appendJSONPair(json, "plugin_version", pluginVersion);
        Metrics.appendJSONPair(json, "server_version", serverVersion);
        Metrics.appendJSONPair(json, "players_online", Integer.toString(playersOnline));
        String osname = System.getProperty("os.name");
        String osarch = System.getProperty("os.arch");
        String osversion = System.getProperty("os.version");
        String java_version = System.getProperty("java.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        if (osarch.equals("amd64")) {
            osarch = "x86_64";
        }
        Metrics.appendJSONPair(json, "osname", osname);
        Metrics.appendJSONPair(json, "osarch", osarch);
        Metrics.appendJSONPair(json, "osversion", osversion);
        Metrics.appendJSONPair(json, "cores", Integer.toString(coreCount));
        Metrics.appendJSONPair(json, "auth_mode", onlineMode ? "1" : "0");
        Metrics.appendJSONPair(json, "java_version", java_version);
        if (isPing) {
            Metrics.appendJSONPair(json, "ping", "1");
        }
        if (this.graphs.size() > 0) {
            Set<Graph> set = this.graphs;
            synchronized (set) {
                json.append(',');
                json.append('\"');
                json.append("graphs");
                json.append('\"');
                json.append(':');
                json.append('{');
                boolean firstGraph = true;
                for (Graph graph : this.graphs) {
                    StringBuilder graphJson = new StringBuilder();
                    graphJson.append('{');
                    for (Plotter plotter : graph.getPlotters()) {
                        Metrics.appendJSONPair(graphJson, plotter.getColumnName(), Integer.toString(plotter.getValue()));
                    }
                    graphJson.append('}');
                    if (!firstGraph) {
                        json.append(',');
                    }
                    json.append(Metrics.escapeJSON(graph.getName()));
                    json.append(':');
                    json.append((CharSequence)graphJson);
                    firstGraph = false;
                }
                json.append('}');
            }
        }
        json.append('}');
        URL url = new URL(BASE_URL + String.format(REPORT_URL, Metrics.urlEncode(pluginName)));
        URLConnection connection = this.isMineshafterPresent() ? url.openConnection(Proxy.NO_PROXY) : url.openConnection();
        byte[] uncompressed = json.toString().getBytes();
        byte[] compressed = Metrics.gzip(json.toString());
        connection.addRequestProperty("User-Agent", "MCStats/8");
        connection.addRequestProperty("Content-Type", "application/json");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", Integer.toString(compressed.length));
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.setDoOutput(true);
        if (this.debug) {
            System.out.println("[Metrics] Prepared request for " + pluginName + " uncompressed=" + uncompressed.length + " compressed=" + compressed.length);
        }
        OutputStream os = connection.getOutputStream();
        os.write(compressed);
        os.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        os.close();
        reader.close();
        if (response == null || response.startsWith("ERR") || response.startsWith("7")) {
            if (response == null) {
                response = "null";
            } else if (response.startsWith("7")) {
                response = response.substring(response.startsWith("7,") ? 2 : 1);
            }
            throw new IOException(response);
        }
        if (response.equals("1") || response.contains("This is your first update this hour")) {
            Set<Graph> set = this.graphs;
            synchronized (set) {
                for (Graph graph : this.graphs) {
                    for (Plotter plotter : graph.getPlotters()) {
                        plotter.reset();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] gzip(String input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = null;
        try {
            gzos = new GZIPOutputStream(baos);
            gzos.write(input.getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (gzos != null) {
                try {
                    gzos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return baos.toByteArray();
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void appendJSONPair(StringBuilder json, String key, String value) throws UnsupportedEncodingException {
        boolean isValueNumeric = false;
        try {
            if (value.equals("0") || !value.endsWith("0")) {
                Double.parseDouble(value);
                isValueNumeric = true;
            }
        }
        catch (NumberFormatException e) {
            isValueNumeric = false;
        }
        if (json.charAt(json.length() - 1) != '{') {
            json.append(',');
        }
        json.append(Metrics.escapeJSON(key));
        json.append(':');
        if (isValueNumeric) {
            json.append(value);
        } else {
            json.append(Metrics.escapeJSON(value));
        }
    }

    private static String escapeJSON(String text) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        block7: for (int index = 0; index < text.length(); ++index) {
            char chr = text.charAt(index);
            switch (chr) {
                case '\"': 
                case '\\': {
                    builder.append('\\');
                    builder.append(chr);
                    continue block7;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block7;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block7;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block7;
                }
                default: {
                    if (chr < ' ') {
                        String t = "000" + Integer.toHexString(chr);
                        builder.append("\\u" + t.substring(t.length() - 4));
                        continue block7;
                    }
                    builder.append(chr);
                }
            }
        }
        builder.append('\"');
        return builder.toString();
    }

    private static String urlEncode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }

    public static abstract class Plotter {
        private final String name;

        public Plotter() {
            this("Default");
        }

        public Plotter(String name) {
            this.name = name;
        }

        public abstract int getValue();

        public String getColumnName() {
            return this.name;
        }

        public void reset() {
        }

        public int hashCode() {
            return this.getColumnName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.name.equals(this.name) && plotter.getValue() == this.getValue();
        }
    }

    public static class Graph {
        private final String name;
        private final Set<Plotter> plotters = new LinkedHashSet<Plotter>();

        private Graph(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addPlotter(Plotter plotter) {
            this.plotters.add(plotter);
        }

        public void removePlotter(Plotter plotter) {
            this.plotters.remove(plotter);
        }

        public Set<Plotter> getPlotters() {
            return Collections.unmodifiableSet(this.plotters);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)object;
            return graph.name.equals(this.name);
        }

        void onOptOut() {
        }
    }
}

