/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfcnei.recipeHandlers;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.bioxx.tfc.api.Crafting.LoomManager;
import com.bioxx.tfc.api.Crafting.LoomRecipe;
import java.awt.Rectangle;
import java.util.List;
import net.dries007.tfcnei.util.Constants;
import net.dries007.tfcnei.util.Helper;
import net.minecraft.item.ItemStack;

public class LoomRecipeHandler
extends TemplateRecipeHandler {
    private static List<LoomRecipe> recipeList;

    public String getGuiTexture() {
        return Constants.LOOM_TEXTURE.toString();
    }

    public String getRecipeName() {
        return "Loom";
    }

    public String getOverlayIdentifier() {
        return "loom";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(88, 26, 25, 18), "loom", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("loom") && ((Object)((Object)this)).getClass() == LoomRecipeHandler.class) {
            for (LoomRecipe recipe : recipeList) {
                this.arecipes.add(new CachedLoomRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public TemplateRecipeHandler newInstance() {
        if (recipeList == null) {
            recipeList = LoomManager.getInstance().getRecipes();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (LoomRecipe recipe : recipeList) {
            ItemStack out = recipe.getOutItemStack();
            if (!Helper.areItemStacksEqual(result, out)) continue;
            this.arecipes.add(new CachedLoomRecipe(recipe.getInItem(), out));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (LoomRecipe recipe : recipeList) {
            if (!Helper.areItemStacksEqual(ingredient, recipe.getInItem())) continue;
            this.arecipes.add(new CachedLoomRecipe(recipe));
        }
    }

    public class CachedLoomRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        final PositionedStack ingred;
        final PositionedStack result;

        public CachedLoomRecipe(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)LoomRecipeHandler.this);
            this.ingred = new PositionedStack((Object)ingred, 59, 24);
            this.result = new PositionedStack((Object)result, 119, 24);
        }

        public CachedLoomRecipe(LoomRecipe recipe) {
            this(recipe.getInItem(), recipe.getOutItemStack());
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getIngredient() {
            return this.ingred;
        }
    }
}

