/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfcnei.recipeHandlers;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.bioxx.tfc.Items.ItemFlatGeneric;
import com.bioxx.tfc.Items.ItemLooseRock;
import com.bioxx.tfc.api.Crafting.CraftingManagerTFC;
import com.bioxx.tfc.api.Crafting.ShapedRecipesTFC;
import com.bioxx.tfc.api.TFCItems;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfcnei.util.Helper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class KnappingRecipeHandler
extends TemplateRecipeHandler {
    private static List<ShapedRecipesTFC> recipeList;

    public String getGuiTexture() {
        return "terrafirmacraft:textures/gui/gui_knapping.png";
    }

    public String getRecipeName() {
        return "Knapping";
    }

    public String getOverlayIdentifier() {
        return "knapping";
    }

    public TemplateRecipeHandler newInstance() {
        if (recipeList == null) {
            recipeList = new ArrayList<ShapedRecipesTFC>();
            List allRecipes = CraftingManagerTFC.getInstance().getRecipeList();
            block0: for (IRecipe recipe : allRecipes) {
                ItemStack[] inputs;
                if (recipe.func_77570_a() <= 9 || !(recipe instanceof ShapedRecipesTFC)) continue;
                for (ItemStack inStack : inputs = ((ShapedRecipesTFC)recipe).getRecipeItems()) {
                    if (inStack == null) continue;
                    if (!(inStack.func_77973_b() instanceof ItemFlatGeneric)) continue block0;
                    recipeList.add((ShapedRecipesTFC)recipe);
                    continue block0;
                }
            }
        }
        return super.newInstance();
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(0, 0, 80, 80), "knapping", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("knapping") && ((Object)((Object)this)).getClass() == KnappingRecipeHandler.class) {
            for (ShapedRecipesTFC recipe : recipeList) {
                this.arecipes.add(new CachedKnappingRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (ShapedRecipesTFC recipe : recipeList) {
            if (!Helper.areItemStacksEqual(result, recipe.func_77571_b())) continue;
            this.arecipes.add(new CachedKnappingRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!(ingredient.func_77973_b() instanceof ItemLooseRock)) {
            return;
        }
        Item flatType = ((ItemLooseRock)ingredient.func_77973_b()).getSpecialCraftingType();
        block0: for (ShapedRecipesTFC recipe : recipeList) {
            for (ItemStack inStack : recipe.getRecipeItems()) {
                if (inStack == null || flatType != inStack.func_77973_b()) continue;
                if (flatType == TFCItems.flatClay) {
                    if (ingredient.func_77960_j() == 0 && inStack.func_77960_j() == 1) {
                        this.arecipes.add(new CachedKnappingRecipe(recipe));
                        continue block0;
                    }
                    if (ingredient.func_77960_j() != 1 || inStack.func_77960_j() != 3) continue block0;
                    this.arecipes.add(new CachedKnappingRecipe(recipe));
                    continue block0;
                }
                if (inStack.func_77960_j() != Short.MAX_VALUE && ingredient.func_77960_j() != inStack.func_77960_j()) continue block0;
                this.arecipes.add(new CachedKnappingRecipe(recipe));
                continue block0;
            }
        }
    }

    public class CachedKnappingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        final List<PositionedStack> inputs;
        final PositionedStack result;
        PositionedStack actualInput;

        public CachedKnappingRecipe(ShapedRecipesTFC recipe) {
            ItemStack[] inputItems;
            super((TemplateRecipeHandler)KnappingRecipeHandler.this);
            int W = recipe.getRecipeWidth();
            int H = recipe.getRecipeHeight();
            ItemStack off = null;
            for (ItemStack inStack : inputItems = recipe.getRecipeItems()) {
                if (inStack == null) continue;
                if (inStack.func_77973_b() == TFCItems.flatClay) {
                    if (inStack.func_77960_j() == 1) {
                        off = new ItemStack(inStack.func_77973_b(), 1, 0);
                        this.setActualInput(new ItemStack(TFCItems.clayBall, 5, 0));
                        break;
                    }
                    if (inStack.func_77960_j() != 3) break;
                    off = new ItemStack(inStack.func_77973_b(), 1, 2);
                    this.setActualInput(new ItemStack(TFCItems.clayBall, 5, 1));
                    break;
                }
                if (inStack.func_77973_b() == TFCItems.flatLeather) {
                    this.setActualInput(new ItemStack(TFCItems.leather));
                    break;
                }
                if (inStack.func_77973_b() != TFCItems.flatRock) break;
                this.setActualInput(new ItemStack(TFCItems.looseRock, 1, inStack.func_77960_j()));
                break;
            }
            this.inputs = new ArrayList<PositionedStack>();
            for (int h = 0; h < H; ++h) {
                for (int w = 0; w < W; ++w) {
                    if (inputItems[h * W + w] != null) {
                        this.inputs.add(new PositionedStack((Object)inputItems[h * W + w], 16 * w, 16 * h));
                        continue;
                    }
                    if (off == null) continue;
                    this.inputs.add(new PositionedStack((Object)off, 16 * w, 16 * h));
                }
            }
            this.result = new PositionedStack((Object)recipe.func_77571_b(), 123, 33);
        }

        public List<PositionedStack> getIngredients() {
            return this.inputs;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return this.actualInput;
        }

        public void setActualInput(ItemStack itemStack) {
            this.actualInput = new PositionedStack((Object)itemStack, 123, 10);
        }
    }
}

