/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfcnei.recipeHandlers;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.bioxx.tfc.api.Crafting.KilnCraftingManager;
import com.bioxx.tfc.api.Crafting.KilnRecipe;
import java.awt.Rectangle;
import java.util.List;
import net.dries007.tfcnei.util.Constants;
import net.dries007.tfcnei.util.Helper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class KilnRecipeHandler
extends TemplateRecipeHandler {
    private static List<KilnRecipe> recipeList;

    public String getGuiTexture() {
        return Constants.KILN_TEXTURE.toString();
    }

    public String getRecipeName() {
        return "Pit Kiln";
    }

    public String getOverlayIdentifier() {
        return "pitkiln";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(43, 26, 18, 18), "pitkiln", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(88, 26, 25, 18), "pitkiln", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("pitkiln") && ((Object)((Object)this)).getClass() == KilnRecipeHandler.class) {
            for (KilnRecipe recipe : recipeList) {
                this.arecipes.add(new CachedKilnRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public TemplateRecipeHandler newInstance() {
        if (recipeList == null) {
            recipeList = KilnCraftingManager.getInstance().getRecipeList();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (KilnRecipe recipe : recipeList) {
            if (!Helper.areItemStacksEqual(result, recipe.getCraftingResult())) continue;
            this.arecipes.add(new CachedKilnRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (KilnRecipe recipe : recipeList) {
            if (!Helper.areItemStacksEqual(ingredient, recipe.getInput1())) continue;
            this.arecipes.add(new CachedKilnRecipe(recipe.getInput1(), recipe.getCraftingResult()));
        }
    }

    public class CachedKilnRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        final PositionedStack ingred;
        final PositionedStack result;

        public CachedKilnRecipe(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)KilnRecipeHandler.this);
            this.ingred = new PositionedStack((Object)ingred, 43, 44);
            this.result = new PositionedStack((Object)result, 119, 24);
        }

        public CachedKilnRecipe(KilnRecipe recipe) {
            this(recipe.getInput1(), recipe.getCraftingResult());
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getIngredient() {
            return this.ingred;
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)new ItemStack((Block)Blocks.field_150480_ab), 43, 9);
        }
    }
}

