/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfcnei.recipeHandlers;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.bioxx.tfc.Containers.Slots.SlotCookableFoodOnly;
import com.bioxx.tfc.Containers.Slots.SlotFirepitIn;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Food.ItemFoodTFC;
import com.bioxx.tfc.Items.ItemMeltedMetal;
import com.bioxx.tfc.Items.ItemOre;
import com.bioxx.tfc.api.HeatIndex;
import com.bioxx.tfc.api.HeatRegistry;
import com.bioxx.tfc.api.Interfaces.ISmeltable;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCItems;
import com.bioxx.tfc.api.TFC_ItemHeat;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.dries007.tfcnei.util.Constants;
import net.dries007.tfcnei.util.Helper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class HeatRecipeHandler
extends TemplateRecipeHandler {
    private static List<HeatIndex> recipeList;
    private static Item firepit;
    private static Item grill;
    private static Item forge;
    private static Item crucible;
    private static Slot firepitSlot;
    private static Slot grillSlot;

    public String getGuiTexture() {
        return Constants.HEATING_TEXTURE.toString();
    }

    public String getRecipeName() {
        return "Heating";
    }

    public String getOverlayIdentifier() {
        return "heating";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(25, 27, 18, 10), "heating", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("heating") && ((Object)((Object)this)).getClass() == HeatRecipeHandler.class) {
            for (HeatIndex recipe : recipeList) {
                this.arecipes.add(new CachedHeatRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public TemplateRecipeHandler newInstance() {
        if (recipeList == null) {
            recipeList = HeatRegistry.getInstance().getHeatList();
            firepit = Item.func_150898_a((Block)TFCBlocks.firepit);
            grill = Item.func_150898_a((Block)TFCBlocks.grill);
            forge = Item.func_150898_a((Block)TFCBlocks.forge);
            crucible = Item.func_150898_a((Block)TFCBlocks.crucible);
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (HeatIndex recipe : recipeList) {
            if (!Helper.areItemStacksEqual(result, recipe.getOutput(new Random()))) continue;
            this.arecipes.add(new CachedHeatRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        for (HeatIndex recipe : recipeList) {
            if (item == firepit && this.isValidForFirepit(recipe) || item == grill && this.isValidForGrill(recipe) || item == forge && this.isValidForForge(recipe) || item == crucible && this.isValidForCrucible(recipe)) {
                this.arecipes.add(new CachedHeatRecipe(recipe));
                continue;
            }
            if (!recipe.matches(ingredient)) continue;
            this.arecipes.add(new CachedHeatRecipe(recipe, ingredient));
        }
    }

    public void drawExtras(int recipe) {
        super.drawExtras(recipe);
        TemplateRecipeHandler.CachedRecipe cr = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (cr instanceof CachedHeatRecipe) {
            ((CachedHeatRecipe)cr).drawExtras();
        }
    }

    private boolean isValidForFirepit(HeatIndex recipe) {
        return firepitSlot.func_75214_a(recipe.input) && recipe.meltTemp < 1360.0f;
    }

    private boolean isValidForGrill(HeatIndex recipe) {
        return grillSlot.func_75214_a(recipe.input) && recipe.meltTemp < 1360.0f;
    }

    private boolean isValidForForge(HeatIndex recipe) {
        return !(recipe.input.func_77973_b() instanceof ItemOre) && !(recipe.input.func_77973_b() instanceof ItemFoodTFC);
    }

    private boolean isValidForCrucible(HeatIndex recipe) {
        Item item = recipe.input.func_77973_b();
        return (item instanceof ISmeltable && ((ISmeltable)item).isSmeltable(recipe.input) || item instanceof ItemMeltedMetal) && item != TFCItems.rawBloom && (item != TFCItems.bloom || recipe.input.func_77960_j() <= 100) && !TFC_Core.isOreIron((ItemStack)recipe.input);
    }

    static {
        firepitSlot = new SlotFirepitIn(null, null, 0, 0, 0);
        grillSlot = new SlotCookableFoodOnly(null, 0, 0, 0);
    }

    public class CachedHeatRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        final PositionedStack ingred;
        final PositionedStack result;
        final String temp;
        final List<PositionedStack> heatingItems;

        public CachedHeatRecipe(HeatIndex recipe) {
            this(recipe, recipe.input);
        }

        public CachedHeatRecipe(HeatIndex recipe, ItemStack input) {
            super((TemplateRecipeHandler)HeatRecipeHandler.this);
            this.heatingItems = new ArrayList<PositionedStack>(5);
            this.ingred = new PositionedStack((Object)recipe.input, 25, 9);
            ItemStack result = this.getActualResult(recipe.getOutput(input, new Random()), input);
            this.result = result == null ? null : new PositionedStack((Object)result, 25, 37);
            this.temp = TFC_ItemHeat.getHeatColor((float)recipe.meltTemp, (float)2.1474836E9f);
            if (HeatRecipeHandler.this.isValidForFirepit(recipe)) {
                this.heatingItems.add(new PositionedStack((Object)new ItemStack(firepit), 50, 20));
            }
            if (HeatRecipeHandler.this.isValidForGrill(recipe)) {
                this.heatingItems.add(new PositionedStack((Object)new ItemStack(grill), 70, 20));
            }
            if (HeatRecipeHandler.this.isValidForForge(recipe)) {
                this.heatingItems.add(new PositionedStack((Object)new ItemStack(forge), 90, 20));
            }
            if (HeatRecipeHandler.this.isValidForCrucible(recipe)) {
                this.heatingItems.add(new PositionedStack((Object)new ItemStack(crucible), 110, 20));
            }
        }

        private ItemStack getActualResult(ItemStack result, ItemStack ingred) {
            if (result != null) {
                return result;
            }
            if (ingred.func_77973_b() instanceof ISmeltable) {
                ISmeltable smelt = (ISmeltable)ingred.func_77973_b();
                ItemStack smeltedItem = new ItemStack(smelt.getMetalType((ItemStack)ingred).meltedItem);
                short units = smelt.getMetalReturnAmount(ingred);
                smeltedItem.field_77994_a = units / 100;
                return smeltedItem;
            }
            return ingred;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getIngredient() {
            return this.ingred;
        }

        public List<PositionedStack> getOtherStacks() {
            for (PositionedStack stack : this.heatingItems) {
                stack.setPermutationToRender(HeatRecipeHandler.this.cycleticks / 24 % stack.items.length);
            }
            return this.heatingItems;
        }

        public void drawExtras() {
            FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
            renderer.func_78276_b("Can be heated in: ", 54, 9, 0);
            renderer.func_78276_b("Temp: ", 54, 40, 0);
            renderer.func_78276_b(this.temp, 84, 40, 0);
        }
    }
}

