/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfcnei.recipeHandlers;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.bioxx.tfc.api.Crafting.BarrelBriningRecipe;
import com.bioxx.tfc.api.Crafting.BarrelLiquidToLiquidRecipe;
import com.bioxx.tfc.api.Crafting.BarrelManager;
import com.bioxx.tfc.api.Crafting.BarrelMultiItemRecipe;
import com.bioxx.tfc.api.Crafting.BarrelRecipe;
import com.bioxx.tfc.api.Crafting.BarrelVinegarRecipe;
import com.bioxx.tfc.api.Enums.EnumFoodGroup;
import com.bioxx.tfc.api.Interfaces.IFood;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfcnei.util.Constants;
import net.dries007.tfcnei.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BarrelRecipeHandler
extends TemplateRecipeHandler {
    private static List<BarrelRecipe> recipeList;
    private static ItemStack[] foodToBrine;
    private static ItemStack[] fruitForVinegar;

    public String getGuiTexture() {
        return Constants.BARREL_TEXTURE.toString();
    }

    public String getRecipeName() {
        return "Barrel";
    }

    public String getOverlayIdentifier() {
        return "barrel";
    }

    public TemplateRecipeHandler newInstance() {
        if (recipeList == null) {
            recipeList = BarrelManager.getInstance().getRecipes();
            ArrayList items = new ArrayList();
            ArrayList fruits = new ArrayList();
            for (Item item : Item.field_150901_e) {
                if (!(item instanceof IFood)) continue;
                item.func_150895_a(item, CreativeTabs.field_78027_g, items);
                if (((IFood)item).getFoodGroup() != EnumFoodGroup.Fruit) continue;
                item.func_150895_a(item, CreativeTabs.field_78027_g, fruits);
            }
            foodToBrine = items.toArray(new ItemStack[items.size()]);
            fruitForVinegar = fruits.toArray(new ItemStack[fruits.size()]);
        }
        return super.newInstance();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(71, 23, 24, 18), "barrel", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("barrel") && ((Object)((Object)this)).getClass() == BarrelRecipeHandler.class) {
            for (BarrelRecipe recipe : recipeList) {
                this.arecipes.add(new CachedBarrelRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (BarrelRecipe recipe : recipeList) {
            ItemStack outItem = recipe.getRecipeOutIS();
            FluidStack outFluid = recipe.getRecipeOutFluid();
            if ((outItem == null || !Helper.areItemStacksEqual(result, outItem)) && (outFluid == null || !outFluid.isFluidEqual(result))) continue;
            this.arecipes.add(new CachedBarrelRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient);
        for (BarrelRecipe recipe : recipeList) {
            ItemStack inItem = recipe.getInItem();
            FluidStack inFluid = recipe.getInFluid();
            if ((inItem == null || !Helper.areItemStacksEqual(inItem, ingredient)) && (inFluid == null || !inFluid.isFluidEqual(fluidStack))) continue;
            this.arecipes.add(new CachedBarrelRecipe(recipe));
        }
    }

    public void drawExtras(int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof CachedBarrelRecipe) {
            Helper.drawCenteredString(Minecraft.func_71410_x().field_71466_p, ((CachedBarrelRecipe)crecipe).techLvlString(), 83, 8, 8519827);
            Helper.drawCenteredString(Minecraft.func_71410_x().field_71466_p, ((CachedBarrelRecipe)crecipe).sealTimeString(), 83, 48, 0x555555);
            if (((CachedBarrelRecipe)crecipe).getInFluid() != null) {
                Helper.drawFluidInRect(((CachedBarrelRecipe)crecipe).getInFluid().getFluid(), BarrelRecipeHandler.recipeInFluidRect());
            }
            if (((CachedBarrelRecipe)crecipe).getOutFluid() != null) {
                Helper.drawFluidInRect(((CachedBarrelRecipe)crecipe).getOutFluid().getFluid(), BarrelRecipeHandler.recipeOutFluidRect());
            }
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        TemplateRecipeHandler.CachedRecipe irecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (irecipe instanceof CachedBarrelRecipe) {
            Point mousepos = GuiDraw.getMousePosition();
            Point offset = gui.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - gui.field_147003_i - offset.x, mousepos.y - gui.field_147009_r - offset.y);
            if (BarrelRecipeHandler.recipeOutFluidRect().contains(relMouse) && ((CachedBarrelRecipe)irecipe).getOutFluid() != null) {
                currenttip.add(Helper.tooltipForFluid(((CachedBarrelRecipe)irecipe).getOutFluid()));
            }
            if (BarrelRecipeHandler.recipeInFluidRect().contains(relMouse) && ((CachedBarrelRecipe)irecipe).getInFluid() != null) {
                currenttip.add(Helper.tooltipForFluid(((CachedBarrelRecipe)irecipe).getInFluid()));
            }
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.transferFluid(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.transferFluid(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferFluid(gui, recipe, false) : button == 1 && this.transferFluid(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    private boolean transferFluid(GuiRecipe gui, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof CachedBarrelRecipe) {
            Point mousepos = GuiDraw.getMousePosition();
            Point offset = gui.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - gui.field_147003_i - offset.x, mousepos.y - gui.field_147009_r - offset.y);
            ItemStack fluidStack = null;
            if (BarrelRecipeHandler.recipeOutFluidRect().contains(relMouse) && ((CachedBarrelRecipe)crecipe).getOutFluid() != null) {
                fluidStack = Helper.getItemStacksForFluid(((CachedBarrelRecipe)crecipe).getOutFluid())[0];
            }
            if (BarrelRecipeHandler.recipeInFluidRect().contains(relMouse) && ((CachedBarrelRecipe)crecipe).getInFluid() != null) {
                fluidStack = Helper.getItemStacksForFluid(((CachedBarrelRecipe)crecipe).getInFluid())[0];
            }
            if (fluidStack != null && (usage ? GuiUsageRecipe.openRecipeGui((String)"item", (Object[])new Object[]{fluidStack}) : GuiCraftingRecipe.openRecipeGui((String)"item", (Object[])new Object[]{fluidStack}))) {
                return true;
            }
        }
        return false;
    }

    private static Rectangle recipeInFluidRect() {
        return new Rectangle(12, 7, 8, 50);
    }

    private static Rectangle recipeOutFluidRect() {
        return new Rectangle(146, 7, 8, 50);
    }

    public class CachedBarrelRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        final int minTechLevel;
        final int sealTime;
        PositionedStack inItem;
        PositionedStack outItem;
        final FluidStack inFluid;
        FluidStack outFluid;

        public CachedBarrelRecipe(BarrelRecipe recipe) {
            super((TemplateRecipeHandler)BarrelRecipeHandler.this);
            this.minTechLevel = recipe.getMinTechLevel();
            this.sealTime = recipe.isSealedRecipe() ? recipe.getSealTime() : 0;
            this.inFluid = recipe.getInFluid();
            this.outFluid = recipe.getRecipeOutFluid();
            this.setInItem(recipe.getInItem());
            this.setOutItem(recipe.getRecipeOutIS());
            if (recipe instanceof BarrelLiquidToLiquidRecipe) {
                this.setInItem(Helper.getItemStacksForFluid(((BarrelLiquidToLiquidRecipe)recipe).getInputfluid()));
            }
            if (recipe instanceof BarrelMultiItemRecipe) {
                this.outFluid = null;
            }
            if (recipe instanceof BarrelVinegarRecipe) {
                this.setInItem(fruitForVinegar);
            }
            if (recipe instanceof BarrelBriningRecipe) {
                this.outFluid = null;
                this.setInItem(foodToBrine);
                this.setOutItem(foodToBrine);
            }
        }

        public PositionedStack getIngredient() {
            if (this.inItem != null) {
                this.randomRenderPermutation(this.inItem, BarrelRecipeHandler.this.cycleticks / 24);
            }
            return this.inItem;
        }

        public PositionedStack getResult() {
            if (this.outItem != null) {
                this.randomRenderPermutation(this.outItem, BarrelRecipeHandler.this.cycleticks / 24);
            }
            return this.outItem;
        }

        public void setInItem(Object inItem) {
            this.inItem = inItem == null ? null : new PositionedStack(inItem, 39, 24);
        }

        public void setOutItem(Object outItem) {
            this.outItem = outItem == null ? null : new PositionedStack(outItem, 111, 24);
        }

        public FluidStack getInFluid() {
            return this.inFluid;
        }

        public FluidStack getOutFluid() {
            return this.outFluid;
        }

        public String sealTimeString() {
            if (this.sealTime == 0) {
                return "Instant";
            }
            return this.sealTime + " hours";
        }

        public String techLvlString() {
            switch (this.minTechLevel) {
                case 0: {
                    return "Vessel or Barrel";
                }
                case 1: {
                    return "Barrel only";
                }
            }
            return "Unknown.";
        }
    }
}

