/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfcnei.recipeHandlers;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.bioxx.tfc.Core.Recipes;
import com.bioxx.tfc.GUI.GuiAnvil;
import com.bioxx.tfc.Items.Tools.ItemHammer;
import com.bioxx.tfc.api.Crafting.AnvilManager;
import com.bioxx.tfc.api.Crafting.AnvilRecipe;
import com.bioxx.tfc.api.Crafting.AnvilReq;
import com.bioxx.tfc.api.TFCItems;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfcnei.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class AnvilRecipeHandler
extends TemplateRecipeHandler {
    private static List<AnvilRecipe> recipeList;
    private static List<AnvilRecipe> weldRecipeList;
    private static ItemStack[] hammers;

    public String getGuiTexture() {
        return GuiAnvil.texture.toString();
    }

    public String getRecipeName() {
        return "Anvil";
    }

    public String getOverlayIdentifier() {
        return "tfcanvil";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(-8, 58, 36, 20), "tfcanvil", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(51, 13, 64, 36), "tfcanvil", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(48, 69, 70, 34), "tfcanvil", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(127, 11, 54, 72), "tfcanvil", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("tfcanvil") && ((Object)((Object)this)).getClass() == AnvilRecipeHandler.class) {
            for (AnvilRecipe recipe : recipeList) {
                this.arecipes.add(new CachedAnvilRecipe(TYPE.NORMAL, recipe));
            }
            for (AnvilRecipe recipe : weldRecipeList) {
                this.arecipes.add(new CachedAnvilRecipe(TYPE.WELD, recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (AnvilRecipe recipe : recipeList) {
            if (!Helper.areItemStacksEqual(result, recipe.getCraftingResult(result))) continue;
            this.arecipes.add(new CachedAnvilRecipe(TYPE.NORMAL, recipe));
        }
        for (AnvilRecipe recipe : weldRecipeList) {
            if (!Helper.areItemStacksEqual(result, recipe.getCraftingResult(result))) continue;
            this.arecipes.add(new CachedAnvilRecipe(TYPE.WELD, recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() instanceof ItemHammer) {
            for (AnvilRecipe recipe : recipeList) {
                this.arecipes.add(new CachedAnvilRecipe(TYPE.HAMMER_NORMAL, recipe));
            }
            for (AnvilRecipe recipe : weldRecipeList) {
                this.arecipes.add(new CachedAnvilRecipe(TYPE.HAMMER_WELD, recipe));
            }
        } else if (ingredient.func_77973_b() == TFCItems.powder && ingredient.func_77960_j() == 0) {
            for (AnvilRecipe recipe : weldRecipeList) {
                this.arecipes.add(new CachedAnvilRecipe(TYPE.WELD, recipe));
            }
        } else {
            for (AnvilRecipe recipe : recipeList) {
                if (!Helper.areItemStacksEqual(ingredient, recipe.getInput1()) && !Helper.areItemStacksEqual(ingredient, recipe.getInput2())) continue;
                this.arecipes.add(new CachedAnvilRecipe(TYPE.NORMAL, recipe.getAnvilreq(), recipe.getCraftingResult(), recipe.getInput1(), recipe.getInput2()));
            }
            for (AnvilRecipe recipe : weldRecipeList) {
                if (!Helper.areItemStacksEqual(ingredient, recipe.getInput1()) && !Helper.areItemStacksEqual(ingredient, recipe.getInput2())) continue;
                this.arecipes.add(new CachedAnvilRecipe(TYPE.WELD, recipe.getAnvilreq(), recipe.getCraftingResult(), recipe.getInput1(), recipe.getInput2()));
            }
        }
    }

    public TemplateRecipeHandler newInstance() {
        if (recipeList == null || weldRecipeList == null || hammers == null) {
            recipeList = AnvilManager.getInstance().getRecipeList();
            weldRecipeList = AnvilManager.getInstance().getWeldRecipeList();
            hammers = new ItemStack[Recipes.hammers.length];
            for (int i = 0; i < hammers.length; ++i) {
                AnvilRecipeHandler.hammers[i] = new ItemStack(Recipes.hammers[i]);
            }
        }
        return super.newInstance();
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-21, (int)5, (int)0, (int)0, (int)208, (int)198);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void drawExtras(int recipe) {
        super.drawExtras(recipe);
        TemplateRecipeHandler.CachedRecipe cr = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (cr instanceof CachedAnvilRecipe) {
            Helper.drawCenteredString(Minecraft.func_71410_x().field_71466_p, ((CachedAnvilRecipe)cr).anvilReq, 80, -3, 8519827);
        }
    }

    public class CachedAnvilRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack i1;
        PositionedStack i2;
        final PositionedStack out;
        final TYPE type;
        public final String anvilReq;

        public CachedAnvilRecipe(TYPE type, AnvilRecipe recipe) {
            this(type, recipe.getAnvilreq(), recipe.getCraftingResult(), recipe.getInput1(), recipe.getInput2());
        }

        public CachedAnvilRecipe(TYPE type, int anvilreq, ItemStack out, ItemStack i1, ItemStack i2) {
            super((TemplateRecipeHandler)AnvilRecipeHandler.this);
            this.type = type;
            StringBuilder sb = new StringBuilder();
            for (AnvilReq a : AnvilReq.RULES) {
                if (a.Tier != anvilreq) continue;
                sb.append(a.Name).append(" anvil or better");
                break;
            }
            this.anvilReq = sb.toString();
            if (i1 != null) {
                this.i1 = new PositionedStack((Object)i1, type.isWeld() ? -7 : 66, type.isWeld() ? 17 : 51);
            }
            if (i2 != null) {
                this.i2 = new PositionedStack((Object)i2, type.isWeld() ? 11 : 84, type.isWeld() ? 17 : 51);
            }
            this.out = new PositionedStack((Object)out, type.isWeld() ? 2 : 103, type.isWeld() ? 39 : 51);
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.i1 != null) {
                stacks.add(this.i1);
            }
            if (this.i2 != null) {
                stacks.add(this.i2);
            }
            return stacks;
        }

        public PositionedStack getResult() {
            return this.out;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(new PositionedStack((Object)hammers, -14, 100, false));
            if (this.type.isWeld()) {
                stacks.add(new PositionedStack((Object)new ItemStack(TFCItems.powder), 164, 100));
            }
            return stacks;
        }
    }

    public static enum TYPE {
        NORMAL,
        WELD,
        HAMMER_NORMAL,
        HAMMER_WELD;


        public boolean isWeld() {
            return this == WELD || this == HAMMER_NORMAL;
        }
    }
}

