/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfcnei.recipeHandlers;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.bioxx.tfc.Core.Metal.Alloy;
import com.bioxx.tfc.Core.Metal.AlloyManager;
import com.bioxx.tfc.Core.Metal.AlloyMetal;
import com.bioxx.tfc.Core.Metal.AlloyMetalCompare;
import com.bioxx.tfc.Items.ItemOre;
import com.bioxx.tfc.api.Metal;
import com.bioxx.tfc.api.TFCItems;
import com.google.common.collect.HashMultimap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.dries007.tfcnei.util.Constants;
import net.dries007.tfcnei.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class AlloyRecipeHandler
extends TemplateRecipeHandler {
    private static List<Alloy> alloyList;
    private static final HashMultimap<Metal, ItemStack> metalItemMap;
    private static final int SPACING = 30;

    public String getGuiTexture() {
        return Constants.ALLOY_TEXTURE.toString();
    }

    public String getRecipeName() {
        return "Alloy";
    }

    public String getOverlayIdentifier() {
        return "alloy";
    }

    public TemplateRecipeHandler newInstance() {
        if (alloyList == null) {
            Metal metal;
            alloyList = AlloyManager.INSTANCE.alloys;
            ItemStack itemStack = new ItemStack(TFCItems.oreChunk);
            while ((metal = ((ItemOre)TFCItems.oreChunk).getMetalType(itemStack)) != null) {
                metalItemMap.put((Object)metal, (Object)itemStack.func_77946_l());
                itemStack.func_77964_b(itemStack.func_77960_j() + 1);
            }
        }
        return super.newInstance();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(0, 30, 160, 30), "alloy", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("alloy") && ((Object)((Object)this)).getClass() == AlloyRecipeHandler.class) {
            for (Alloy recipe : alloyList) {
                this.arecipes.add(new CachedAlloyRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Alloy recipe : alloyList) {
            for (AlloyMetal alloyMetal : recipe.alloyIngred) {
                if (alloyMetal.metalType.meltedItem == ingredient.func_77973_b() || alloyMetal.metalType.ingot == ingredient.func_77973_b()) {
                    this.arecipes.add(new CachedAlloyRecipe(recipe));
                    continue;
                }
                if (!(ingredient.func_77973_b() instanceof ItemOre) || ((ItemOre)ingredient.func_77973_b()).getMetalType(ingredient) != alloyMetal.metalType) continue;
                this.arecipes.add(new CachedAlloyRecipe(recipe));
            }
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Alloy recipe : alloyList) {
            if (recipe.outputType.ingot != result.func_77973_b() && recipe.outputType.meltedItem != result.func_77973_b()) continue;
            this.arecipes.add(new CachedAlloyRecipe(recipe));
        }
    }

    public void drawExtras(int recipe) {
        super.drawExtras(recipe);
        TemplateRecipeHandler.CachedRecipe cr = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (cr instanceof CachedAlloyRecipe) {
            ((CachedAlloyRecipe)cr).drawExtras();
        }
    }

    static {
        metalItemMap = HashMultimap.create();
    }

    public class CachedAlloyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final PositionedStack outItem;
        private final ArrayList<PositionedStack> ingredients;
        private final ArrayList<String> min;
        private final ArrayList<String> max;
        private String tech;

        public CachedAlloyRecipe(Alloy recipe) {
            super((TemplateRecipeHandler)AlloyRecipeHandler.this);
            this.ingredients = new ArrayList();
            this.min = new ArrayList();
            this.max = new ArrayList();
            this.tech = "?";
            this.outItem = new PositionedStack((Object)new ItemStack(recipe.outputType.meltedItem), 10, 10);
            int x = 15;
            for (AlloyMetal alloyMetal : recipe.alloyIngred) {
                LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                list.add(new ItemStack(alloyMetal.metalType.meltedItem));
                list.add(new ItemStack(alloyMetal.metalType.ingot));
                list.addAll(metalItemMap.get((Object)alloyMetal.metalType));
                this.ingredients.add(new PositionedStack(list, x += 30, 10));
                if (alloyMetal instanceof AlloyMetalCompare) {
                    this.min.add(String.format("%2.0f%%", Float.valueOf(((AlloyMetalCompare)alloyMetal).getMetalMin())));
                    this.max.add(String.format("%2.0f%%", Float.valueOf(((AlloyMetalCompare)alloyMetal).getMetalMax())));
                    continue;
                }
                this.min.add("100%");
                this.max.add("");
            }
            this.tech = recipe.getFurnaceTier().toString();
            switch (recipe.getFurnaceTier().tier) {
                case 1: {
                    this.tech = "Pit Kiln";
                    break;
                }
                case 2: {
                    this.tech = "Beehive Kiln";
                    break;
                }
                case 3: {
                    this.tech = "Bloomery";
                    break;
                }
                case 4: {
                    this.tech = "Blast Furnace";
                    break;
                }
                case 5: {
                    this.tech = "Crucible";
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            for (PositionedStack positionedStack : this.ingredients) {
                positionedStack.setPermutationToRender(AlloyRecipeHandler.this.cycleticks / 24 % positionedStack.items.length);
            }
            return this.ingredients;
        }

        public PositionedStack getResult() {
            return this.outItem;
        }

        public void drawExtras() {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            Helper.drawCenteredString(fr, "Min: ", 20, 30, 0);
            Helper.drawCenteredString(fr, "Max: ", 20, 40, 0);
            Helper.drawCenteredString(fr, this.tech, 80, 0, 8519827);
            int x = 16;
            for (String min1 : this.min) {
                fr.func_78276_b(min1, x += 30, 30, 0);
            }
            x = 16;
            for (String max1 : this.max) {
                fr.func_78276_b(max1, x += 30, 40, 0);
            }
        }
    }
}

