/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.twitchcrumbs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.blay09.mods.twitchcrumbs.CachedAPI;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="twitchcrumbs", name="Twitchcrumbs", dependencies="required-after:headcrumbs", acceptedMinecraftVersions="[1.12.2]")
public class Twitchcrumbs {
    public static final Logger logger = LogManager.getLogger();
    @Mod.Instance
    public static Twitchcrumbs instance;
    private final List<String> whitelists = new ArrayList<String>();
    private boolean autoReload;
    private int cacheTime;
    private int reloadInterval;
    private boolean firstTick = true;
    private Thread thread;
    private String[] originalNames;
    private int tickTimer;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        String[] sources = config.getStringList("sources", "general", new String[0], "One whitelist source link per line. Example: http://whitelist.twitchapps.com/list.php?id=12345");
        Collections.addAll(this.whitelists, sources);
        this.cacheTime = config.getInt("cacheTime", "general", 86400, 0, Integer.MAX_VALUE, "How long should the cache be used until updates are pulled? (if autoReload is false) (in seconds)");
        this.autoReload = config.getBoolean("autoReload", "general", false, "Should the Twitchcrumbs automatically be reloaded in a specific interval? This will mean reading the remote file again and will reset Headcrumb's already-spawned list. The Creative Tab and NEI won't be updated until the game restarts, though.");
        this.reloadInterval = config.getInt("reloadInterval", "general", 60, 10, 720, "If autoReload is enabled, at what interval in minutes should the reload happen? (approximately, based on TPS)") * 60 * 20;
        config.save();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBase(){

            public String func_71517_b() {
                return "twitchcrumbs";
            }

            public String func_71518_a(ICommandSender sender) {
                return "/twitchcrumbs reload";
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (args.length != 1) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                if (args[0].equals("reload")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Reloading Twitchcrumbs..."));
                    Twitchcrumbs.this.reloadTwitchCrumbs(registered -> sender.func_145747_a((ITextComponent)new TextComponentString("Reloaded Twitchcrumbs - registered " + registered + " users.")));
                    return;
                }
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }

            public int func_82362_a() {
                return 2;
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                return args.length == 1 ? Collections.singletonList("reload") : super.func_184883_a(server, sender, args, targetPos);
            }
        });
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (this.firstTick) {
            this.firstTick = false;
            this.reloadTwitchCrumbs(null);
        }
        if (this.autoReload) {
            ++this.tickTimer;
            if (this.tickTimer > this.reloadInterval) {
                this.tickTimer = 0;
                this.reloadTwitchCrumbs(null);
            }
        }
    }

    public void reloadTwitchCrumbs(Consumer<Integer> reloadDone) {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(() -> {
            ArrayList<String> list = new ArrayList<String>();
            for (String source : this.whitelists) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(CachedAPI.loadCachedAPI(source, source.replace(":", "_").replace("/", "_").replace("?", "_"), (long)(1000 * this.cacheTime))));
                    Throwable throwable = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            list.add(line);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (IOException e) {
                    logger.error("Failed to load whitelist from source {}: {}", (Object)source, (Object)e);
                }
            }
            Runnable update = () -> {
                int count = list.size();
                this.updateData(list);
                if (reloadDone != null) {
                    reloadDone.accept(count);
                }
                this.thread = null;
            };
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                FMLClientHandler.instance().getClient().func_152344_a(update);
            } else {
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(update);
            }
        });
        this.thread.start();
    }

    private void updateData(List<String> list) {
        logger.info("Registering {} Twitchcrumbs users...", (Object)list.size());
        try {
            Class<?> headcrumbs = Class.forName("ganymedes01.headcrumbs.Headcrumbs");
            Field othersField = headcrumbs.getField("others");
            String[] others = (String[])othersField.get(null);
            if (this.originalNames == null) {
                this.originalNames = new String[others.length];
                System.arraycopy(others, 0, this.originalNames, 0, others.length);
            } else {
                others = this.originalNames;
            }
            Collections.addAll(list, others);
            othersField.set(null, list.toArray(new String[0]));
            Class<?> entityHuman = Class.forName("ganymedes01.headcrumbs.entity.EntityHuman");
            Field namesField = entityHuman.getDeclaredField("names");
            namesField.setAccessible(true);
            List names = (List)namesField.get(null);
            names.clear();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            logger.error("Oops! Twitchcrumbs is not compatible with this version of Headcrumbs!", (Throwable)e);
        }
    }
}

