/*
 * Decompiled with CFR 0.152.
 */
package aqueducts;

import aqueducts.Aqueducts;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;

public class TileEntityAqueductWater
extends TileEntity {
    private int distanceFromSource;
    private static final HashSet<ResourceLocation> WATER_SOURCES = new HashSet();
    private static final HashSet<Biome> BIOMES = new HashSet();

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && Aqueducts.AQUEDUCT_IS_TANK) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && Aqueducts.AQUEDUCT_IS_TANK) {
            return (T)new FluidBlockWrapper((IFluidBlock)Aqueducts.AQUEDUCT_WATER, this.field_145850_b, this.field_174879_c);
        }
        return (T)super.getCapability(capability, facing);
    }

    public static void addWaterSource(ResourceLocation block) {
        WATER_SOURCES.add(block);
    }

    public int getDistanceFromSource() {
        return this.distanceFromSource;
    }

    public void setDistanceFromSource(int distanceFromSource) {
        this.distanceFromSource = distanceFromSource;
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Distance", this.distanceFromSource);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.distanceFromSource = compound.func_74762_e("Distance");
    }

    public static int getMinDistance(World world, BlockPos checkpos) {
        int minDistance = 1000000;
        HashSet<BlockPos> corners = new HashSet<BlockPos>();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos neighborpos = checkpos.func_177972_a(facing);
            IBlockState state = world.func_180495_p(neighborpos);
            boolean isWater = false;
            int dist = TileEntityAqueductWater.getBlockDistanceFromSource(world, neighborpos, state, false);
            if (dist > -1) {
                minDistance = Math.min(minDistance, dist);
                isWater = true;
            }
            if (!isWater) continue;
            corners.add(neighborpos.func_177967_a(facing.func_176746_e(), 1));
            corners.add(neighborpos.func_177967_a(facing.func_176746_e(), -1));
        }
        for (BlockPos neighborpos : corners) {
            IBlockState state;
            int dist = TileEntityAqueductWater.getBlockDistanceFromSource(world, neighborpos, state = world.func_180495_p(neighborpos), false);
            if (dist <= -1) continue;
            minDistance = Math.min(minDistance, dist);
        }
        return minDistance;
    }

    public static int getBlockDistanceFromSource(World world, BlockPos pos, IBlockState state, boolean recursed) {
        boolean isValidBiome = true;
        if (!BIOMES.isEmpty()) {
            boolean bl = isValidBiome = BIOMES.contains(world.func_180494_b(pos)) == Aqueducts.AQUEDUCT_BIOMES_IS_WHITELIST;
        }
        if (isValidBiome && TileEntityAqueductWater.isRealWaterSource(state)) {
            return Aqueducts.AQUEDUCT_SOURCES_MINIMUM <= 0 || TileEntityAqueductWater.isEnoughWater(world, pos) ? 0 : -1;
        }
        if (state.func_177230_c() == Aqueducts.AQUEDUCT && !recursed) {
            return TileEntityAqueductWater.getBlockDistanceFromSource(world, pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()), true);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityAqueductWater) {
            return ((TileEntityAqueductWater)te).getDistanceFromSource();
        }
        return -1;
    }

    public static boolean isRealWaterSource(IBlockState state) {
        return state.func_185904_a() == Material.field_151586_h && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 || WATER_SOURCES.contains(state.func_177230_c().getRegistryName());
    }

    public static boolean isEnoughWater(World world, BlockPos pos) {
        HashSet visited = Sets.newHashSet();
        ArrayList toVisit = Lists.newArrayList((Object[])new BlockPos[]{pos});
        int foundWater = 0;
        for (int i = 0; i < Aqueducts.AQUEDUCT_SOURCES_SEARCH; ++i) {
            BlockPos visit = (BlockPos)toVisit.remove(0);
            if (visited.contains(visit)) continue;
            visited.add(visit);
            if (!TileEntityAqueductWater.isRealWaterSource(world.func_180495_p(visit))) continue;
            if (++foundWater >= Aqueducts.AQUEDUCT_SOURCES_MINIMUM) {
                return true;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                toVisit.add(visit.func_177972_a(facing));
            }
        }
        return false;
    }

    public static void reloadBiomeList() {
        BIOMES.clear();
        for (String str : Aqueducts.AQUEDUCT_BIOME_STRINGS) {
            ResourceLocation location = new ResourceLocation(str);
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)location);
            if (biome == null || BIOMES.contains(biome)) continue;
            BIOMES.add(biome);
        }
    }
}

