/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixins.lighting.common;

import me.jellysquid.mods.phosphor.api.IChunkLightingData;
import me.jellysquid.mods.phosphor.api.ILightingEngineProvider;
import me.jellysquid.mods.phosphor.mod.world.lighting.LightingHooks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilChunkLoader.class})
public abstract class MixinAnvilChunkLoader {
    @Inject(method={"saveChunk"}, at={@At(value="HEAD")})
    private void onConstructed(World world, Chunk chunkIn, CallbackInfo callbackInfo) {
        ((ILightingEngineProvider)world).getLightingEngine().processLightUpdates();
    }

    @Inject(method={"readChunkFromNBT"}, at={@At(value="RETURN")})
    private void onReadChunkFromNBT(World world, NBTTagCompound compound, CallbackInfoReturnable<Chunk> cir) {
        Chunk chunk = cir.getReturnValue();
        LightingHooks.readNeighborLightChecksFromNBT(chunk, compound);
        ((IChunkLightingData)chunk).setLightInitialized(compound.func_74767_n("LightPopulated"));
    }

    @Inject(method={"writeChunkToNBT"}, at={@At(value="RETURN")})
    private void onWriteChunkToNBT(Chunk chunk, World world, NBTTagCompound compound, CallbackInfo ci) {
        LightingHooks.writeNeighborLightChecksToNBT(chunk, compound);
        compound.func_74757_a("LightPopulated", ((IChunkLightingData)chunk).isLightInitialized());
    }
}

