/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.match;

import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemMatchEntry {
    private String domain;
    private String path;
    private int meta;
    private int[] metas;

    public ItemMatchEntry(String domain, String path, int meta, int[] metas) {
        this.domain = domain;
        this.path = path;
        this.meta = meta;
        this.metas = metas;
    }

    public boolean matches(ItemStack itemStack, DebugFileWrapper logFile, boolean debug, String logPrefix) {
        ResourceLocation registryName;
        if (debug) {
            logFile.debug(String.format("%s[--] Attempting to match candidate [%s] with: [%s]", logPrefix, itemStack, this.toString()));
        }
        if ((registryName = itemStack.func_77973_b().getRegistryName()) == null) {
            if (debug) {
                logFile.debug(logPrefix + "[!!] No registry name for match candidate: " + itemStack);
            }
            return false;
        }
        if (!registryName.func_110624_b().equals(this.domain)) {
            if (debug) {
                logFile.debug(String.format("%s[!!] Domain mismatch: (match) %s != %s (candidate)", logPrefix, this.domain, registryName.func_110624_b()));
            }
            return false;
        }
        if (debug) {
            logFile.debug(String.format("%s[OK] Domain match: (match) %s == %s (candidate)", logPrefix, this.domain, registryName.func_110624_b()));
        }
        if (!registryName.func_110623_a().equals(this.path)) {
            if (debug) {
                logFile.debug(String.format("%s[!!] Path mismatch: (match) %s != %s (candidate)", logPrefix, this.path, registryName.func_110623_a()));
            }
            return false;
        }
        if (debug) {
            logFile.debug(String.format("%s[OK] Path match: (match) %s == %s (candidate)", logPrefix, this.path, registryName.func_110623_a()));
        }
        int itemMeta = itemStack.func_77960_j();
        if (this.meta == Short.MAX_VALUE || this.meta == itemMeta) {
            if (debug) {
                logFile.debug(String.format("%s[OK] Meta match: (match) %d == %d (candidate)", logPrefix, this.meta, itemMeta));
            }
            return true;
        }
        if (debug) {
            logFile.debug(String.format("%s[!!] Meta mismatch: (match) %d != %d (candidate)", logPrefix, this.meta, itemMeta));
        }
        for (int meta : this.metas) {
            if (meta == Short.MAX_VALUE || meta == itemMeta) {
                if (debug) {
                    logFile.debug(String.format("%s[OK] Meta match: (match) %d == %d (candidate)", logPrefix, meta, itemMeta));
                }
                return true;
            }
            if (!debug) continue;
            logFile.debug(String.format("%s[!!] Meta mismatch: (match) %d != %d (candidate)", logPrefix, meta, itemMeta));
        }
        return false;
    }

    public String toString() {
        return "ItemMatcher{domain='" + this.domain + '\'' + ", path='" + this.path + '\'' + ", meta=" + this.meta + ", metas=" + Arrays.toString(this.metas) + '}';
    }
}

