/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.data;

import goblinbob.mobends.core.client.event.DataUpdateHandler;
import goblinbob.mobends.core.client.model.ModelPartTransform;
import goblinbob.mobends.core.data.LivingEntityData;
import goblinbob.mobends.core.util.GUtil;
import goblinbob.mobends.standard.animation.controller.SpiderController;
import jline.internal.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class SpiderData
extends LivingEntityData<EntitySpider> {
    public ModelPartTransform spiderHead;
    public ModelPartTransform spiderNeck;
    public ModelPartTransform spiderBody;
    public Limb[] limbs;
    protected final SpiderController controller = new SpiderController();
    protected float prevCrawlProgress = 0.0f;
    protected float crawlProgress = 0.0f;
    protected EnumFacing wallFacing = null;

    public SpiderData(EntitySpider entity) {
        super(entity);
    }

    public SpiderController getController() {
        return this.controller;
    }

    public float getCrawlProgress() {
        return this.crawlProgress;
    }

    public float getInterpolatedCrawlProgress() {
        return GUtil.lerp(this.prevCrawlProgress, this.crawlProgress, DataUpdateHandler.partialTicks);
    }

    @Override
    public void onTicksRestart() {
    }

    @Override
    public void update(float partialTicks) {
        super.update(partialTicks);
    }

    @Override
    public void initModelPose() {
        super.initModelPose();
        this.spiderBody = new ModelPartTransform();
        this.spiderNeck = new ModelPartTransform();
        this.spiderHead = new ModelPartTransform();
        this.limbs = new Limb[8];
        for (int i = 0; i < this.limbs.length; ++i) {
            this.limbs[i] = new Limb(this, i);
            this.nameToPartMap.put("leg" + (i + 1), this.limbs[i].upperPart);
            this.nameToPartMap.put("foreLeg" + (i + 1), this.limbs[i].lowerPart);
        }
        this.nameToPartMap.put("body", this.spiderBody);
        this.nameToPartMap.put("neck", this.spiderNeck);
        this.nameToPartMap.put("head", this.spiderHead);
        this.spiderHead.position.set(0.0f, 15.0f, -3.0f);
        this.spiderNeck.position.set(0.0f, 15.0f, 0.0f);
        this.spiderBody.position.set(0.0f, 15.0f, 9.0f);
    }

    @Override
    public void updateParts(float ticksPerFrame) {
        super.updateParts(ticksPerFrame);
        this.spiderBody.update(ticksPerFrame);
        this.spiderNeck.update(ticksPerFrame);
        this.spiderHead.update(ticksPerFrame);
        for (Limb limb : this.limbs) {
            limb.upperPart.update(ticksPerFrame);
            limb.lowerPart.update(ticksPerFrame);
        }
    }

    @Override
    public void updateClient() {
        super.updateClient();
        for (Limb limb : this.limbs) {
            limb.updateClient();
        }
        this.prevCrawlProgress = this.crawlProgress;
        this.crawlProgress += MathHelper.func_76133_a((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        this.wallFacing = this.calcWallFacing();
    }

    @Nullable
    public EnumFacing calcWallFacing() {
        if (!((EntitySpider)this.entity).func_70617_f_()) {
            return null;
        }
        BlockPos position = new BlockPos(Math.floor(((EntitySpider)this.entity).field_70165_t), Math.floor(((EntitySpider)this.entity).field_70163_u), Math.floor(((EntitySpider)this.entity).field_70161_v));
        IBlockState blockN = ((EntitySpider)this.entity).field_70170_p.func_180495_p(position.func_177971_a(EnumFacing.NORTH.func_176730_m()));
        IBlockState blockS = ((EntitySpider)this.entity).field_70170_p.func_180495_p(position.func_177971_a(EnumFacing.SOUTH.func_176730_m()));
        IBlockState blockW = ((EntitySpider)this.entity).field_70170_p.func_180495_p(position.func_177971_a(EnumFacing.WEST.func_176730_m()));
        IBlockState blockE = ((EntitySpider)this.entity).field_70170_p.func_180495_p(position.func_177971_a(EnumFacing.EAST.func_176730_m()));
        if (blockN.func_177230_c() != Blocks.field_150350_a) {
            return EnumFacing.NORTH;
        }
        if (blockS.func_177230_c() != Blocks.field_150350_a) {
            return EnumFacing.SOUTH;
        }
        if (blockW.func_177230_c() != Blocks.field_150350_a) {
            return EnumFacing.WEST;
        }
        if (blockE.func_177230_c() != Blocks.field_150350_a) {
            return EnumFacing.EAST;
        }
        return null;
    }

    public EnumFacing getWallFacing() {
        return this.wallFacing;
    }

    public float getCrawlingRotation() {
        if (this.wallFacing == null) {
            return 0.0f;
        }
        return this.wallFacing.func_185119_l();
    }

    public static class IKResult {
        public final double worldX;
        public final double worldZ;
        public final double localX;
        public final double localZ;
        public final double deltaX;
        public final double deltaZ;
        public final double xzDistance;
        public final double xzAngle;

        IKResult(double worldX, double worldZ, double localX, double localZ, double deltaX, double deltaZ, double xzDistance, double xzAngle) {
            this.worldX = worldX;
            this.worldZ = worldZ;
            this.localX = localX;
            this.localZ = localZ;
            this.deltaX = deltaX;
            this.deltaZ = deltaZ;
            this.xzDistance = xzDistance;
            this.xzAngle = xzAngle;
        }
    }

    public static class Limb {
        private final SpiderData data;
        public final ModelPartTransform upperPart;
        public final ModelPartTransform lowerPart;
        private final int index;
        private final boolean odd;
        private final double neutralYaw;
        private double worldX;
        private double worldZ;
        private double prevWorldX;
        private double prevWorldZ;
        private double adjustTargetX = 0.0;
        private double adjustTargetZ = 0.0;
        private float adjustingProgress = 1.0f;
        private float adjustingSpeed = 0.2f;

        public Limb(SpiderData data, int index) {
            this.data = data;
            this.upperPart = new ModelPartTransform();
            this.lowerPart = new ModelPartTransform();
            this.index = index;
            this.odd = index % 2 == 1;
            double neutralYaw = (double)this.index / (double)(data.limbs.length - 1) * 2.0 - 1.0;
            this.neutralYaw = this.odd ? neutralYaw * 1.3 : Math.PI - neutralYaw * 1.3;
            int z = 2 - index / 2;
            this.upperPart.position.set(this.odd ? 4.0f : -4.0f, 15.0f, z);
            this.lowerPart.position.set(this.odd ? 11.0f : -11.0f, -1.0f, 0.0f);
            this.resetPosition();
        }

        public void resetPosition() {
            float distance = 1.0f;
            float bodyYaw = ((EntitySpider)((SpiderData)this.data).entity).field_70761_aq / 180.0f * (float)Math.PI;
            this.worldX = Math.cos(this.neutralYaw + (double)bodyYaw) * 1.0 + this.data.getPositionX();
            this.worldZ = Math.sin(this.neutralYaw + (double)bodyYaw) * 1.0 + this.data.getPositionZ();
            this.prevWorldX = this.worldX;
            this.prevWorldZ = this.worldZ;
        }

        void updateClient() {
            this.prevWorldX = this.worldX;
            this.prevWorldZ = this.worldZ;
            if (this.adjustingProgress < 1.0f) {
                this.adjustingProgress += this.adjustingSpeed;
                if (this.adjustingProgress >= 1.0f) {
                    this.worldX = this.adjustTargetX;
                    this.worldZ = this.adjustTargetZ;
                    this.adjustingProgress = 1.0f;
                } else {
                    this.worldX += (this.adjustTargetX - this.worldX) * 0.2;
                    this.worldZ += (this.adjustTargetZ - this.worldZ) * 0.2;
                }
            }
        }

        public void setAngleAndDistance(float angle, float distance) {
            this.setLocalPosition(MathHelper.func_76134_b((float)angle) * distance + this.upperPart.position.x * 0.0625f, MathHelper.func_76126_a((float)angle) * distance - this.upperPart.position.z * 0.0625f);
        }

        public void adjustToNeutralPosition() {
            if (this.adjustingProgress != 1.0f) {
                return;
            }
            this.adjustingSpeed = 0.2f;
            this.adjustingProgress = 0.0f;
            float distance = 1.2f;
            float bodyYaw = ((EntitySpider)((SpiderData)this.data).entity).field_70761_aq / 180.0f * (float)Math.PI;
            this.adjustTargetX = Math.cos(this.neutralYaw + (double)bodyYaw) * (double)1.2f + this.data.getPositionX();
            this.adjustTargetZ = Math.sin(this.neutralYaw + (double)bodyYaw) * (double)1.2f + this.data.getPositionZ();
        }

        public void adjustToWorldPosition(double x, double z, float adjustingSpeed) {
            if (this.adjustingProgress != 1.0f) {
                return;
            }
            this.adjustingSpeed = adjustingSpeed;
            this.adjustingProgress = 0.0f;
            this.adjustTargetX = x;
            this.adjustTargetZ = z;
        }

        public void adjustToLocalPosition(double x, double z, float adjustingSpeed) {
            if (this.adjustingProgress != 1.0f) {
                return;
            }
            this.adjustingSpeed = adjustingSpeed;
            this.adjustingProgress = 0.0f;
            float bodyYaw = ((EntitySpider)((SpiderData)this.data).entity).field_70761_aq / 180.0f * (float)Math.PI;
            this.adjustTargetX = x * Math.cos(bodyYaw) - z * Math.sin(bodyYaw) + this.data.getPositionX();
            this.adjustTargetZ = x * Math.sin(bodyYaw) + z * Math.cos(bodyYaw) + this.data.getPositionZ();
        }

        public void setLocalPosition(double x, double z) {
            this.adjustingProgress = 1.0f;
            float bodyYaw = ((EntitySpider)((SpiderData)this.data).entity).field_70761_aq / 180.0f * (float)Math.PI;
            this.worldX = this.adjustTargetX = x * Math.cos(bodyYaw) - z * Math.sin(bodyYaw) + this.data.getPositionX();
            this.worldZ = this.adjustTargetZ = x * Math.sin(bodyYaw) + z * Math.cos(bodyYaw) + this.data.getPositionZ();
        }

        public IKResult solveIK(double bodyX, double bodyZ, float pt) {
            double renderYawOffset = (double)((((EntitySpider)((SpiderData)this.data).entity).field_70760_ar + (((EntitySpider)((SpiderData)this.data).entity).field_70761_aq - ((EntitySpider)((SpiderData)this.data).entity).field_70760_ar) * pt) / 180.0f) * Math.PI;
            double spiderX = ((EntitySpider)((SpiderData)this.data).entity).field_70169_q + (((EntitySpider)((SpiderData)this.data).entity).field_70165_t - ((EntitySpider)((SpiderData)this.data).entity).field_70169_q) * (double)pt;
            double spiderZ = ((EntitySpider)((SpiderData)this.data).entity).field_70166_s + (((EntitySpider)((SpiderData)this.data).entity).field_70161_v - ((EntitySpider)((SpiderData)this.data).entity).field_70166_s) * (double)pt;
            double worldLimbX = this.prevWorldX + (this.worldX - this.prevWorldX) * (double)pt;
            double worldLimbZ = this.prevWorldZ + (this.worldZ - this.prevWorldZ) * (double)pt;
            double x = (worldLimbX - spiderX) / 0.0625;
            double z = -(worldLimbZ - spiderZ) / 0.0625;
            double localX = x * Math.cos(renderYawOffset) - z * Math.sin(renderYawOffset) - bodyX;
            double localZ = x * Math.sin(renderYawOffset) + z * Math.cos(renderYawOffset) - bodyZ;
            double deltaX = (double)this.upperPart.position.x - localX;
            double deltaZ = (double)this.upperPart.position.z - localZ;
            double xzDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double xzAngle = Math.atan2(deltaX, deltaZ);
            return new IKResult(worldLimbX, worldLimbZ, localX, localZ, deltaX, deltaZ, xzDistance, xzAngle);
        }

        public void applyIK(IKResult result, double groundLevel, double liftHeight, float pt) {
            double xzAngle = this.odd ? 1.5707963267948966 + result.xzAngle : -1.5707963267948966 + result.xzAngle;
            this.upperPart.rotation.orientY((float)(xzAngle / Math.PI * 180.0));
            this.lowerPart.rotation.orientZero();
            SpiderController.putLimbOnGround(this.upperPart.rotation, this.lowerPart.rotation, this.odd, result.xzDistance, groundLevel - 7.0 + Math.sin((double)this.adjustingProgress * Math.PI) * liftHeight);
        }

        public double getNeutralYaw() {
            return this.neutralYaw;
        }

        public double getPrevWorldX() {
            return this.prevWorldX;
        }

        public double getPrevWorldZ() {
            return this.prevWorldZ;
        }

        public double getWorldX() {
            return this.worldX;
        }

        public double getWorldZ() {
            return this.worldZ;
        }

        public float getAdjustingProgress() {
            return this.adjustingProgress;
        }

        public boolean isOdd() {
            return this.odd;
        }
    }
}

