/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.model;

import goblinbob.mobends.core.client.model.IModelPart;
import goblinbob.mobends.core.math.SmoothOrientation;
import goblinbob.mobends.core.math.TransformUtils;
import goblinbob.mobends.core.math.matrix.IMat4x4d;
import goblinbob.mobends.core.math.physics.ICollider;
import goblinbob.mobends.core.math.vector.IVec3f;
import goblinbob.mobends.core.math.vector.Vec3f;
import goblinbob.mobends.core.util.GlHelper;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelPartContainer
extends ModelRenderer
implements IModelPart {
    public Vec3f position;
    public Vec3f offset;
    public Vec3f innerOffset;
    public Vec3f scale;
    public SmoothOrientation rotation;
    public float offsetScale = 1.0f;
    public Vec3f globalOffset = new Vec3f();
    private ModelRenderer model;
    protected IModelPart parent;
    protected ICollider collider;

    public ModelPartContainer(ModelBase modelBase, ModelRenderer model) {
        super(modelBase, 0, 0);
        this.model = model;
        this.position = new Vec3f();
        this.offset = new Vec3f();
        this.innerOffset = new Vec3f();
        this.scale = new Vec3f(1.0f, 1.0f, 1.0f);
        this.rotation = new SmoothOrientation();
    }

    public ModelRenderer getModel() {
        return this.model;
    }

    @Override
    public IModelPart getParent() {
        return this.parent;
    }

    public ModelPartContainer setParent(IModelPart parent) {
        this.parent = parent;
        return this;
    }

    public ModelPartContainer setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
        return this;
    }

    public ModelPartContainer setInnerOffset(float x, float y, float z) {
        this.innerOffset.set(x, y, z);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78785_a(float scale) {
        this.renderPart(scale);
    }

    @Override
    public void renderPart(float scale) {
        if (!this.isShowing()) {
            return;
        }
        GlStateManager.func_179094_E();
        this.applyCharacterTransform(scale);
        this.model.field_78808_h = 0.0f;
        this.model.field_78796_g = 0.0f;
        this.model.field_78795_f = 0.0f;
        if (this.innerOffset.x != 0.0f || this.innerOffset.y != 0.0f || this.innerOffset.z != 0.0f) {
            GlStateManager.func_179109_b((float)(this.innerOffset.x * scale), (float)(this.innerOffset.y * scale), (float)(this.innerOffset.z * scale));
        }
        this.model.func_78785_a(scale);
        if (this.field_78805_m != null) {
            for (int k = 0; k < this.field_78805_m.size(); ++k) {
                ((ModelRenderer)this.field_78805_m.get(k)).func_78785_a(scale);
            }
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderJustPart(float scale) {
        if (!this.isShowing()) {
            return;
        }
        GlStateManager.func_179094_E();
        this.applyLocalTransform(scale);
        if (this.innerOffset.x != 0.0f || this.innerOffset.y != 0.0f || this.innerOffset.z != 0.0f) {
            GlStateManager.func_179109_b((float)(this.innerOffset.x * scale), (float)(this.innerOffset.y * scale), (float)(this.innerOffset.z * scale));
        }
        this.model.func_78785_a(scale);
        if (this.field_78805_m != null) {
            for (int k = 0; k < this.field_78805_m.size(); ++k) {
                ((ModelRenderer)this.field_78805_m.get(k)).func_78785_a(scale);
            }
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78794_c(float scale) {
        this.applyCharacterTransform(scale);
        this.applyPostTransform(scale);
    }

    @Override
    public void applyCharacterTransform(float scale) {
        if (this.parent != null) {
            this.parent.applyCharacterTransform(scale);
        }
        this.applyLocalTransform(scale);
    }

    @Override
    public void applyLocalTransform(float scale) {
        if (this.position.x != 0.0f || this.position.y != 0.0f || this.position.z != 0.0f) {
            GlStateManager.func_179109_b((float)(this.position.x * scale * this.offsetScale), (float)(this.position.y * scale * this.offsetScale), (float)(this.position.z * scale * this.offsetScale));
        }
        if (this.offset.x != 0.0f || this.offset.y != 0.0f || this.offset.z != 0.0f) {
            GlStateManager.func_179109_b((float)(this.offset.x * scale * this.offsetScale), (float)(this.offset.y * scale * this.offsetScale), (float)(this.offset.z * scale * this.offsetScale));
        }
        GlHelper.rotate(this.rotation.getSmooth());
        if (this.scale.x != 0.0f || this.scale.y != 0.0f || this.scale.z != 0.0f) {
            GlStateManager.func_179152_a((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
        }
    }

    @Override
    public void applyPostTransform(float scale) {
    }

    @Override
    public void update(float ticksPerFrame) {
        this.rotation.update(ticksPerFrame);
    }

    @Override
    public Vec3f getPosition() {
        return this.position;
    }

    @Override
    public Vec3f getScale() {
        return this.scale;
    }

    @Override
    public Vec3f getOffset() {
        return this.offset;
    }

    @Override
    public SmoothOrientation getRotation() {
        return this.rotation;
    }

    @Override
    public float getOffsetScale() {
        return this.offsetScale;
    }

    @Override
    public IVec3f getGlobalOffset() {
        return this.globalOffset;
    }

    @Override
    public void syncUp(IModelPart part) {
        if (part == null) {
            return;
        }
        this.position.set(part.getPosition());
        this.rotation.set(part.getRotation());
        this.offset.set(part.getOffset());
        this.scale.set(part.getScale());
        this.offsetScale = part.getOffsetScale();
    }

    @Override
    public boolean isShowing() {
        return this.field_78806_j && !this.field_78807_k;
    }

    @Override
    public void setVisible(boolean showModel) {
        this.field_78806_j = showModel;
    }

    @Override
    public void applyPreTransform(float scale) {
        if (this.globalOffset.x != 0.0f || this.globalOffset.y != 0.0f || this.globalOffset.z != 0.0f) {
            GlStateManager.func_179109_b((float)(this.globalOffset.x * scale), (float)(this.globalOffset.y * scale), (float)(this.globalOffset.z * scale));
        }
    }

    @Override
    public void applyPreTransform(float scale, IMat4x4d dest) {
        if (this.globalOffset.x != 0.0f || this.globalOffset.y != 0.0f || this.globalOffset.z != 0.0f) {
            TransformUtils.translate(dest, this.globalOffset.x * scale, this.globalOffset.y * scale, this.globalOffset.z * scale);
        }
    }

    @Override
    public void applyLocalTransform(float scale, IMat4x4d matrix) {
        if (this.position.x != 0.0f || this.position.y != 0.0f || this.position.z != 0.0f) {
            TransformUtils.translate(matrix, this.position.x * scale * this.offsetScale, this.position.y * scale * this.offsetScale, this.position.z * scale * this.offsetScale, matrix);
        }
        if (this.offset.x != 0.0f || this.offset.y != 0.0f || this.offset.z != 0.0f) {
            TransformUtils.translate(matrix, this.offset.x * scale * this.offsetScale, this.offset.y * scale * this.offsetScale, this.offset.z * scale * this.offsetScale);
        }
        TransformUtils.rotate(matrix, this.rotation.getSmooth());
        if (this.scale.x != 0.0f || this.scale.y != 0.0f || this.scale.z != 0.0f) {
            TransformUtils.scale(matrix, this.scale.x, this.scale.y, this.scale.z);
        }
    }
}

