/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.client.gui.packswindow;

import goblinbob.mobends.core.client.gui.GuiBendsMenu;
import goblinbob.mobends.core.client.gui.packswindow.GuiLocalPacks;
import goblinbob.mobends.core.client.gui.packswindow.GuiPackTab;
import goblinbob.mobends.core.client.gui.packswindow.GuiTabNavigation;
import goblinbob.mobends.core.pack.InvalidPackFormatException;
import goblinbob.mobends.core.pack.PackManager;
import goblinbob.mobends.core.util.Draw;
import goblinbob.mobends.core.util.ErrorReporter;
import goblinbob.mobends.core.util.GuiHelper;
import goblinbob.mobends.core.util.Timer;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiPacksWindow
extends GuiScreen {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mobends", "textures/gui/pack_window.png");
    public static final int EDITOR_WIDTH = 280;
    public static final int EDITOR_HEIGHT = 177;
    private static final int BUTTON_BACK = 0;
    private int x;
    private int y;
    private final GuiTabNavigation tabNavigation;
    private final GuiPackTab localPacksTab;
    private final GuiPackTab publicPacksTab;
    private GuiLocalPacks localPacks;
    private float publicJumbotronTransition = 1.0f;
    private Timer timer;

    public GuiPacksWindow() {
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.localPacks = new GuiLocalPacks();
        this.tabNavigation = new GuiTabNavigation();
        this.localPacksTab = this.tabNavigation.addTab("mobends.gui.localpacks", 0);
        this.publicPacksTab = this.tabNavigation.addTab("mobends.gui.publicpacks", 1);
        this.tabNavigation.selectTab(0);
        this.timer = new Timer();
        try {
            PackManager.INSTANCE.initLocalPacks();
        }
        catch (InvalidPackFormatException e) {
            e.printStackTrace();
            ErrorReporter.showErrorToPlayer(e);
        }
    }

    public void func_146281_b() {
        this.localPacks.dispose();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.x = (this.field_146294_l - 280) / 2;
        this.y = (this.field_146295_m - 177) / 2;
        this.tabNavigation.initGui(this.x + 5, this.y);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, 10, this.field_146295_m - 30, 60, 20, "Back"));
        this.localPacks.initGui(this.x, this.y);
    }

    public void func_73876_c() {
        super.func_73876_c();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.localPacks.update(mouseX, mouseY);
    }

    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.tabNavigation.mouseClicked(mouseX, mouseY, button);
        this.localPacks.mouseClicked(mouseX, mouseY, button);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.localPacks.mouseReleased(mouseX, mouseY, state);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.localPacks.handleMouseInput();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        float delta = this.timer.tick();
        if (this.publicJumbotronTransition > 0.0f) {
            this.publicJumbotronTransition -= delta * 0.001f;
        }
        if (this.publicJumbotronTransition < 0.0f) {
            this.publicJumbotronTransition = 0.0f;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        Draw.borderBox(this.x + 4, this.y + 4, 280, 177, 4, 36, 126);
        Draw.texturedModalRect(this.x, this.y - 13, 101, 0, 4, 16);
        Draw.texturedModalRect(this.x + 4, this.y - 13, 264, 16, 105, 0, 1, 16);
        Draw.texturedModalRect(this.x + 280 - 17, this.y - 13, 106, 0, 19, 16);
        this.tabNavigation.draw(mouseX, mouseY);
        if (this.tabNavigation.getSelectedTab() == this.localPacksTab) {
            this.localPacks.draw(partialTicks);
        } else if (this.tabNavigation.getSelectedTab() == this.publicPacksTab) {
            this.field_146289_q.func_175063_a("Coming soon...", (float)(this.x + 140 - this.field_146289_q.func_78256_a("Coming soon...") / 2), (float)(this.y + 88 - 10), 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73869_a(char typedChar, int keyCode) {
        switch (keyCode) {
            case 1: {
                GuiHelper.closeGui();
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: {
                this.goBack();
            }
        }
    }

    private void goBack() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiBendsMenu());
    }
}

