/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.shader;

import extendedrenderer.particle.ShaderManager;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.BufferUtils;

public class Mesh {
    protected int vaoId;
    protected List<Integer> vboIdList = new ArrayList<Integer>();
    private int vertexCount;
    public static final int MAX_WEIGHTS = 4;
    public static int extraRenders = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mesh(float[] positions, float[] textCoords, int[] indices) {
        float radius = 10.0f;
        Random rand = new Random();
        this.vertexCount = indices.length;
        FloatBuffer verticesBuffer = null;
        IntBuffer indicesBuffer = null;
        FloatBuffer textCoordsBuffer = null;
        try {
            this.vaoId = ShaderManager.glGenVertexArrays();
            ShaderManager.glBindVertexArray(this.vaoId);
            int posVboId = OpenGlHelper.func_176073_e();
            this.vboIdList.add(posVboId);
            verticesBuffer = BufferUtils.createFloatBuffer((int)positions.length);
            verticesBuffer.put(positions).flip();
            OpenGlHelper.func_176072_g((int)34962, (int)posVboId);
            ShaderManager.glBufferData(34962, verticesBuffer, 35044);
            ShaderManager.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
            int texVboId = OpenGlHelper.func_176073_e();
            this.vboIdList.add(texVboId);
            textCoordsBuffer = BufferUtils.createFloatBuffer((int)textCoords.length);
            textCoordsBuffer.put(textCoords).flip();
            OpenGlHelper.func_176072_g((int)34962, (int)texVboId);
            ShaderManager.glBufferData(34962, textCoordsBuffer, 35044);
            ShaderManager.glVertexAttribPointer(1, 2, 5126, false, 0, 0L);
            int idxVboId = OpenGlHelper.func_176073_e();
            this.vboIdList.add(idxVboId);
            indicesBuffer = BufferUtils.createIntBuffer((int)indices.length);
            indicesBuffer.put(indices).flip();
            OpenGlHelper.func_176072_g((int)34963, (int)idxVboId);
            ShaderManager.glBufferData(34963, indicesBuffer, 35044);
            OpenGlHelper.func_176072_g((int)34962, (int)0);
            ShaderManager.glBindVertexArray(0);
        }
        finally {
            if (verticesBuffer != null) {
                // empty if block
            }
        }
    }

    protected void initRender() {
        ShaderManager.glBindVertexArray(this.getVaoId());
        ShaderManager.glEnableVertexAttribArray(0);
        ShaderManager.glEnableVertexAttribArray(1);
    }

    protected void endRender() {
        ShaderManager.glDisableVertexAttribArray(0);
        ShaderManager.glDisableVertexAttribArray(1);
        ShaderManager.glBindVertexArray(0);
    }

    public void render() {
        this.initRender();
        this.endRender();
    }

    public int getVaoId() {
        return this.vaoId;
    }

    public void setVaoId(int vaoId) {
        this.vaoId = vaoId;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public void setVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
    }

    public void cleanup() {
        ShaderManager.glDisableVertexAttribArray(0);
        OpenGlHelper.func_176072_g((int)34962, (int)0);
        for (int vboId : this.vboIdList) {
            OpenGlHelper.func_176074_g((int)vboId);
        }
        ShaderManager.glBindVertexArray(0);
        ShaderManager.glDeleteVertexArrays(this.vaoId);
    }

    protected static float[] createEmptyFloatArray(int length, float defaultValue) {
        float[] result = new float[length];
        Arrays.fill(result, defaultValue);
        return result;
    }

    protected static int[] createEmptyIntArray(int length, int defaultValue) {
        int[] result = new int[length];
        Arrays.fill(result, defaultValue);
        return result;
    }
}

