/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty;

import CoroUtil.difficulty.DynamicDifficulty;
import CoroUtil.util.BlockCoord;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

public class DifficultyInfoPlayer {
    public BlockPos difficultyPos = BlockPos.field_177992_a;
    public int skipCount = 0;
    public int skipCountMax = 0;
    public int itemsNeeded = 0;
    public float difficultyEquipment;
    public float difficultyPlayerServerTime;
    public float difficultyAverageChunkTime;
    public float difficultyDPS;
    public float difficultyHealth;
    public float difficultyDistFromSpawn;
    public float difficultyBuffedLocation;
    public float difficultyDebuffedLocation;
    public float difficultyBuffInvasionSkip;

    public DifficultyInfoPlayer() {
    }

    public DifficultyInfoPlayer(BlockPos difficultyPos) {
        this.difficultyPos = difficultyPos;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.skipCount);
        buf.writeInt(this.skipCountMax);
        buf.writeInt(this.itemsNeeded);
        buf.writeFloat(this.difficultyDPS);
    }

    public void fromBytes(ByteBuf buf) {
        this.skipCount = buf.readInt();
        this.skipCountMax = buf.readInt();
        this.itemsNeeded = buf.readInt();
        this.difficultyDPS = buf.readFloat();
    }

    public void updateData(EntityPlayer player, int countNeededBase, double multiplier) {
        int skipCount = player.getEntityData().func_74762_e(DynamicDifficulty.dataPlayerInvasionSkipCountForMultiplier);
        this.itemsNeeded = skipCount == 0 ? countNeededBase : (int)((double)countNeededBase * multiplier * (double)skipCount);
        this.difficultyDPS = DynamicDifficulty.getDifficultyScaleForPosDPS(player.field_70170_p, new BlockCoord(player.func_180425_c()));
    }
}

