/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.ai.tasks;

import CoroUtil.ai.IInvasionControlledTask;
import CoroUtil.ai.ITaskInitializer;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilPath;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.Vec3d;

public class TaskExplodeTowardsTarget
extends EntityAIBase
implements ITaskInitializer,
IInvasionControlledTask {
    private EntityCreature entity = null;
    private EntityLivingBase targetLastTracked = null;
    private int noMoveTicks = 0;
    private Vec3d posLastTracked = null;
    public boolean debug = true;
    public static String dataUseInvasionRules = "HW_Inv_UseInvasionRules";
    public long lastTimePathChecked = 0L;
    public int pathableCheckCountMax = 60;
    public int failedPathCount = 0;
    public int failedPathMax = 5;

    public TaskExplodeTowardsTarget() {
        this.func_75248_a(3);
    }

    @Override
    public void setEntity(EntityCreature creature) {
        this.entity = creature;
    }

    public boolean func_75250_a() {
        double movementThreshold = 0.05;
        int noMoveThreshold = 60;
        if (this.posLastTracked == null) {
            this.posLastTracked = this.entity.func_174791_d();
        } else if (this.posLastTracked.func_72438_d(this.entity.func_174791_d()) < 2.0) {
            ++this.noMoveTicks;
        } else {
            this.posLastTracked = this.entity.func_174791_d();
            this.noMoveTicks = 0;
            this.failedPathCount = 0;
        }
        if (!this.entity.field_70122_E && !this.entity.func_70090_H()) {
            return false;
        }
        if (this.entity.func_70638_az() != null || this.targetLastTracked != null) {
            if (this.entity.func_70638_az() == null) {
                this.entity.func_70624_b(this.targetLastTracked);
                if (this.entity.func_70638_az() == null) {
                    this.noMoveTicks = 0;
                    this.failedPathCount = 0;
                    return false;
                }
            } else {
                this.targetLastTracked = this.entity.func_70638_az();
            }
            if (this.isClosestPathable() && this.noMoveTicks > noMoveThreshold && this.entity.func_70638_az() != null) {
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        this.explode();
        this.func_75251_c();
    }

    public void func_75251_c() {
    }

    @Override
    public boolean shouldBeRemoved() {
        boolean forInvasion = this.entity.getEntityData().func_74767_n(dataUseInvasionRules);
        if (forInvasion && ConfigCoroUtilAdvanced.removeInvasionAIWhenInvasionDone && this.entity.field_70170_p.func_72935_r()) {
            CULog.dbg("removing digging from " + this.entity.func_70005_c_());
            return true;
        }
        return false;
    }

    public void dbg(String str) {
        if (this.debug) {
            CULog.dbg(str);
        }
    }

    private void explode() {
        if (!this.entity.field_70170_p.field_72995_K) {
            boolean flag = this.entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.entity.field_70170_p.func_72876_a((Entity)this.entity, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 3.0f, flag);
            this.entity.func_70106_y();
        }
    }

    public boolean isClosestPathable() {
        if (this.entity.field_70170_p.func_82737_E() > this.lastTimePathChecked + (long)this.pathableCheckCountMax) {
            if (this.entity.func_70638_az() == null) {
                this.failedPathCount = 0;
                return false;
            }
            if (this.entity.field_70122_E || this.entity.func_70090_H()) {
                boolean explodeAboveInstantly = true;
                if (explodeAboveInstantly) {
                    double factor;
                    double vecX = this.entity.func_70638_az().field_70165_t - this.entity.field_70165_t;
                    double vecY = this.entity.func_70638_az().func_174813_aQ().field_72338_b - this.entity.func_174813_aQ().field_72338_b;
                    double vecZ = this.entity.func_70638_az().field_70161_v - this.entity.field_70161_v;
                    double distHoriz = Math.sqrt(vecX * vecX + vecZ * vecZ);
                    if (distHoriz < 0.0) {
                        distHoriz = 1.0;
                    }
                    if ((factor = vecY / distHoriz) < -5.0 && distHoriz < 5.0) {
                        if (this.noMoveTicks > 15) {
                            this.explode();
                            this.func_75251_c();
                        }
                        return true;
                    }
                }
                if (!this.entity.func_70661_as().func_75500_f() || this.entity.func_70661_as().func_75505_d() != null && this.entity.func_70661_as().func_75505_d().func_75874_d() > 1) {
                    this.failedPathCount = 0;
                    return false;
                }
                this.lastTimePathChecked = this.entity.field_70170_p.func_82737_E();
                Path lastPath = this.entity.func_70661_as().func_75505_d();
                CoroUtilPath.tryMoveToEntityLivingLongDist((EntityLiving)this.entity, (Entity)this.entity.func_70638_az(), 1.0);
                Path newPath = this.entity.func_70661_as().func_75505_d();
                this.entity.func_70661_as().func_75484_a(lastPath, 1.0);
                if (newPath == null || newPath.func_75874_d() <= 1) {
                    ++this.failedPathCount;
                    if (this.failedPathCount >= 2) {
                        this.failedPathCount = 0;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

