/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.endmetals.integration.plugins;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.TinkersConstruct;
import com.mcmoddev.lib.integration.plugins.tinkers.events.TinkersExtraMeltingsEvent;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

@MMDPlugin(addonId="endmetals", pluginId="tconstruct", versions="tconstruct@[1.12.2-2.7.4.0,);")
public final class EMeTinkersConstruct
implements IIntegration {
    public static final String PLUGIN_MODID = "tconstruct";
    private boolean registered = false;

    public void init() {
        TinkersConstruct.INSTANCE.init();
        if (!Config.Options.isModEnabled((String)PLUGIN_MODID)) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerMeltings(TinkersExtraMeltingsEvent ev) {
        if (this.registered) {
            return;
        }
        Materials.getAllMaterials().stream().filter(this::isMaterialEmpty).filter(this::hasOre).filter(this::hasFluid).forEach(material -> {
            RecipeMatch input = RecipeMatch.of((String)("oreEnd" + material.getCapitalizedName()), (int)576);
            MeltingRecipe recipe = new MeltingRecipe(input, FluidRegistry.getFluid((String)material.getName()));
            TinkerRegistry.registerMelting((MeltingRecipe)recipe);
        });
        this.registered = true;
    }

    private boolean hasFluid(MMDMaterial material) {
        return FluidRegistry.getFluid((String)material.getName()) != null;
    }

    private boolean hasOre(MMDMaterial material) {
        return material.hasBlock(Names.ENDORE);
    }

    private boolean isMaterialEmpty(MMDMaterial material) {
        return !material.isEmpty();
    }
}

