/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.endmetals.integration.plugins;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.Mekanism;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@MMDPlugin(addonId="endmetals", pluginId="mekanism")
public final class EMeMekanism
extends Mekanism
implements IIntegration {
    public void init() {
        if (!Config.Options.isModEnabled((String)"mekanism")) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void regCallback(RegistryEvent.Register<IRecipe> event) {
        MMDMaterial material2;
        List<String> mekProvides = Arrays.asList("iron", "gold", "osmium", "copper", "tin", "silver", "lead");
        mekProvides.stream().map(Materials::getMaterialByName).filter(mat -> !mat.isEmpty()).filter(mat -> EMeMekanism.gasExists((String)mat.getName())).forEach(mat -> {
            ItemStack clump = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", Names.CLUMP.toString())), 6, mekProvides.indexOf(mat.getName()));
            ItemStack dust = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", "dust")), 4, mekProvides.indexOf(mat.getName()));
            ItemStack shard = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mekanism", Names.SHARD.toString())), 8, mekProvides.indexOf(mat.getName()));
            ItemStack ore = mat.getBlockItemStack(Names.ENDORE);
            EMeMekanism.addEnrichmentChamberRecipe((ItemStack)ore, (ItemStack)dust);
            EMeMekanism.addPurificationChamberRecipe((ItemStack)ore, (ItemStack)clump);
            EMeMekanism.addChemicalInjectionChamberRecipe((ItemStack)ore, (ItemStack)shard);
            EMeMekanism.addChemicalDissolutionChamberRecipe((ItemStack)ore, (String)mat.getName(), (int)2000);
        });
        Materials.getAllMaterials().stream().filter(material -> material.hasBlock(Names.ENDORE)).filter(material -> EMeMekanism.gasExists((String)material.getName())).filter(material -> !mekProvides.contains(material.getName())).forEach(this::addMultRecipe);
        if (Materials.hasMaterial((String)"lapis")) {
            material2 = Materials.getMaterialByName((String)"lapis");
            EMeMekanism.addEnrichmentChamberRecipe((ItemStack)material2.getBlockItemStack(Names.ENDORE), (ItemStack)new ItemStack(Items.field_151100_aR, 24, 4));
        }
        if (Materials.hasMaterial((String)"redstone")) {
            material2 = Materials.getMaterialByName((String)"redstone");
            EMeMekanism.addEnrichmentChamberRecipe((ItemStack)material2.getBlockItemStack(Names.ENDORE), (ItemStack)new ItemStack(Items.field_151137_ax, 24));
        }
        if (Materials.hasMaterial((String)"coal")) {
            material2 = Materials.getMaterialByName((String)"coal");
            EMeMekanism.addEnrichmentChamberRecipe((ItemStack)material2.getBlockItemStack(Names.ENDORE), (ItemStack)new ItemStack(Items.field_151044_h, 4, 0));
        }
        if (Materials.hasMaterial((String)"diamond")) {
            material2 = Materials.getMaterialByName((String)"diamond");
            EMeMekanism.addEnrichmentChamberRecipe((ItemStack)material2.getBlockItemStack(Names.ENDORE), (ItemStack)new ItemStack(Items.field_151045_i, 4));
        }
        if (Materials.hasMaterial((String)"emerald")) {
            material2 = Materials.getMaterialByName((String)"emerald");
            EMeMekanism.addEnrichmentChamberRecipe((ItemStack)material2.getBlockItemStack(Names.ENDORE), (ItemStack)new ItemStack(Items.field_151166_bC, 4));
        }
    }

    private void addMultRecipe(@Nonnull MMDMaterial material) {
        ItemStack ore = material.getBlockItemStack(Names.ENDORE);
        if (material.hasItem(Names.POWDER)) {
            EMeMekanism.addEnrichmentChamberRecipe((ItemStack)ore, (ItemStack)material.getItemStack(Names.POWDER, 4));
        }
        if (material.hasItem(Names.CLUMP)) {
            EMeMekanism.addPurificationChamberRecipe((ItemStack)ore, (ItemStack)material.getItemStack(Names.CLUMP, 6));
        }
        if (material.hasItem(Names.SHARD)) {
            EMeMekanism.addChemicalInjectionChamberRecipe((ItemStack)ore, (ItemStack)material.getItemStack(Names.SHARD, 8));
        }
        EMeMekanism.addChemicalDissolutionChamberRecipe((ItemStack)ore, (String)material.getName(), (int)2000);
    }
}

