/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.endmetals.init;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.util.Config;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class Recipes {
    private static final Names NAME = Names.ENDORE;

    private Recipes() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
        Recipes.recipeWrapper("coal");
        Recipes.recipeWrapper("diamond");
        Recipes.recipeWrapper("emerald");
        Recipes.recipeWrapper("gold");
        Recipes.recipeWrapper("iron");
        Recipes.recipeWrapper("lapis");
        Recipes.recipeWrapper("redstone");
        if (Loader.isModLoaded((String)"basemetals")) {
            Recipes.recipeWrapper("antimony");
            Recipes.recipeWrapper("bismuth");
            Recipes.recipeWrapper("copper");
            Recipes.recipeWrapper("lead");
            Recipes.recipeWrapper("mercury");
            Recipes.recipeWrapper("nickel");
            Recipes.recipeWrapper("platinum");
            Recipes.recipeWrapper("silver");
            Recipes.recipeWrapper("tin");
            Recipes.recipeWrapper("zinc");
        }
        if (Loader.isModLoaded((String)"modernmetals")) {
            Recipes.recipeWrapper("aluminum");
            Recipes.recipeWrapper("cadmium");
            Recipes.recipeWrapper("chromium");
            Recipes.recipeWrapper("iridium");
            Recipes.recipeWrapper("magnesium");
            Recipes.recipeWrapper("manganese");
            Recipes.recipeWrapper("osmium");
            Recipes.recipeWrapper("plutonium");
            Recipes.recipeWrapper("rutile");
            Recipes.recipeWrapper("tantalum");
            Recipes.recipeWrapper("titanium");
            Recipes.recipeWrapper("tungsten");
            Recipes.recipeWrapper("uranium");
            Recipes.recipeWrapper("zirconium");
        }
    }

    private static void recipeWrapper(String materialName) {
        MMDMaterial material;
        if (Materials.hasMaterial((String)materialName) && !(material = Materials.getMaterialByName((String)materialName)).isEmpty() && material.hasBlock(NAME)) {
            Recipes.doFurnaceSmelting(material);
            Recipes.doMakeDusts(material);
        }
    }

    private static void doMakeDusts(MMDMaterial material) {
        if (Config.Options.isThingEnabled((String)"makeDusts") && material.hasItem(Names.POWDER)) {
            CrusherRecipeRegistry.addNewCrusherRecipe((Block)material.getBlock(NAME), (ItemStack)material.getItemStack(Names.POWDER, 4));
        } else if (material.hasBlock(Names.ORE)) {
            CrusherRecipeRegistry.addNewCrusherRecipe((Block)material.getBlock(NAME), (ItemStack)material.getBlockItemStack(Names.ORE, 2));
        }
    }

    private static void doFurnaceSmelting(MMDMaterial material) {
        if (Config.Options.isThingEnabled((String)"enableFurnaceSmelting")) {
            if (Config.Options.isThingEnabled((String)"smeltToIngots") && material.hasItem(Names.INGOT)) {
                GameRegistry.addSmelting((Block)material.getBlock(NAME), (ItemStack)material.getItemStack(Names.INGOT, 2), (float)1.0f);
            } else if (material.hasBlock(Names.ORE)) {
                GameRegistry.addSmelting((Block)material.getBlock(NAME), (ItemStack)material.getBlockItemStack(Names.ORE, 2), (float)1.0f);
            }
        }
    }
}

