/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.endmetals.init;

import com.mcmoddev.endmetals.init.ItemGroups;
import com.mcmoddev.lib.block.BlockMMDEndOre;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Blocks;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Oredicts;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public final class EndBlocks
extends Blocks {
    public static void init() {
        List<String> knownMaterials = Arrays.asList("coal", "diamond", "emerald", "gold", "iron", "lapis", "redstone", "antimony", "bismuth", "copper", "lead", "mercury", "nickel", "platinum", "silver", "tin", "zinc", "aluminum", "cadmium", "chromium", "iridium", "magnesium", "manganese", "osmium", "plutonium", "rutile", "tantalum", "titanium", "tungsten", "uranium", "zirconium");
        Materials.getAllMaterials().stream().map(material -> material.getName()).filter(knownMaterials::contains).filter(Materials::hasMaterial).forEach(EndBlocks::createOreWrapper);
    }

    private static void createOreWrapper(String materialName) {
        List<String> vanillaMats = Arrays.asList("coal", "diamond", "emerald", "gold", "iron", "lapis", "redstone");
        if (vanillaMats.contains(materialName)) {
            EndBlocks.createVanillaOreWrapper(materialName);
        } else {
            EndBlocks.create((Names)Names.ENDORE, (String)materialName);
        }
    }

    private static void createVanillaOreWrapper(String materialName) {
        MMDMaterial material = Materials.getMaterialByName((String)materialName);
        material.addNewBlock(Names.ENDORE, EndBlocks.addBlock((Block)new BlockMMDEndOre(material), (String)Names.ENDORE.toString(), (MMDMaterial)material, (CreativeTabs)ItemGroups.getTab((String)"blocks")));
        Block block = material.getBlock(Names.ENDORE);
        String oredict = EndBlocks.getOredictFromName((Names)Names.ENDORE);
        if (oredict != null && block != null) {
            Oredicts.registerOre((String)(oredict + material.getCapitalizedName()), (Block)block);
        }
    }
}

