/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation.client;

import com.tfar.craftingstation.CraftingStationContainer;
import java.io.IOException;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class CraftingStationScreen
extends GuiContainer {
    private double currentScroll;
    boolean isScrolling = false;
    private boolean wasClicking;
    private final int realRows;
    private int topRow;
    private static final ResourceLocation backgroundTexture = new ResourceLocation("textures/gui/container/crafting_table.png");
    private static final ResourceLocation SCROLLBAR = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation SCROLLBAR_BACKGROUND_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    public static final ResourceLocation SECONDARY_GUI_TEXTURE = new ResourceLocation("craftingstation", "textures/gui/secondary.png");

    public CraftingStationScreen(CraftingStationContainer inv) {
        super((Container)inv);
        this.realRows = inv.getRows();
        this.topRow = 0;
        this.currentScroll = 0.0;
        CraftingStationContainer craftingStationContainer = (CraftingStationContainer)this.field_147002_h;
        if (craftingStationContainer.chestPosition != null && craftingStationContainer.world.func_175625_s(craftingStationContainer.chestPosition) instanceof TileEntityChest) {
            ((TileEntityChest)craftingStationContainer.world.func_175625_s((BlockPos)craftingStationContainer.chestPosition)).doubleChestHandler = null;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        boolean isLeftClicking = Mouse.isButtonDown((int)0);
        int j = this.field_147009_r;
        int j1 = j + 24;
        int j2 = j1 + 145;
        int k = this.field_147003_i;
        int k1 = k - 16;
        int k2 = k1 + 14;
        if (!this.wasClicking && isLeftClicking) {
            this.isScrolling = this.hasScrollbar();
        }
        if (!isLeftClicking) {
            this.isScrolling = false;
        }
        this.wasClicking = isLeftClicking;
        if (this.isScrolling && mouseX <= k2 && mouseX >= k1) {
            this.currentScroll = (float)(mouseY - j1) / ((float)(j2 - j1) - 0.0f);
            this.currentScroll = MathHelper.func_151237_a((double)this.currentScroll, (double)0.0, (double)1.0);
            this.scrollTo(this.currentScroll);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"title.crafting_station", (Object[])new Object[0]), 28, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (((CraftingStationContainer)this.field_147002_h).hasSideContainer) {
            this.field_146289_q.func_78276_b(((CraftingStationContainer)this.field_147002_h).containerName.func_150254_d(), -125, 6, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int i = this.field_147003_i;
        int i1 = i - 16;
        int i2 = i1 + 14;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        if (((CraftingStationContainer)this.field_147002_h).hasSideContainer) {
            this.field_146297_k.func_110434_K().func_110577_a(SECONDARY_GUI_TEXTURE);
            this.func_73729_b(i - 130, j, 0, 0, this.field_146999_f, this.field_147000_g + 18);
            this.field_146297_k.func_110434_K().func_110577_a(SCROLLBAR_BACKGROUND_AND_TAB);
            int totalSlots = ((CraftingStationContainer)this.field_147002_h).getSubContainerSize();
            int slotsToDraw = 54;
            if (totalSlots < slotsToDraw) {
                slotsToDraw = totalSlots;
            } else if (this.hasScrollbar() && this.topRow == this.realRows - 9 && totalSlots % 6 != 0) {
                slotsToDraw = 48 + totalSlots % 6;
            }
            int offset = this.hasScrollbar() ? -126 : -118;
            for (int i3 = 0; i3 < slotsToDraw; ++i3) {
                int j1 = i3 % 6;
                int k1 = i3 / 6;
                this.func_73729_b(i + j1 * 18 + offset, 18 * k1 + j + 17, 8, 17, 18, 18);
            }
            if (this.hasScrollbar()) {
                this.func_73729_b(i - 17, j + 17, 174, 17, 14, 100);
                this.func_73729_b(i - 17, j + 68, 174, 18, 14, 111);
                this.field_146297_k.func_110434_K().func_110577_a(SCROLLBAR);
                int k = (int)((double)(j + 18) + 145.0 * this.currentScroll);
                if (this.wasClicking && mouseX <= i2 && mouseX >= i1) {
                    this.func_73729_b(i - 16, k, 244, 0, 12, 15);
                } else {
                    this.func_73729_b(i - 16, k, 232, 0, 12, 15);
                }
            }
        }
    }

    private boolean hasScrollbar() {
        return this.realRows > 9;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scrollDelta = -Mouse.getEventDWheel();
        if (scrollDelta != 0 && this.hasScrollbar()) {
            if (scrollDelta > 0) {
                scrollDelta = 1;
            }
            if (scrollDelta < 0) {
                scrollDelta = -1;
            }
            this.setTopRow(this.topRow + scrollDelta, false);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
    }

    private void scrollTo(double scroll) {
        this.setTopRow((int)Math.round((double)(this.realRows - 9) * scroll), true);
    }

    private void setTopRow(int value, boolean smooth) {
        this.topRow = value;
        if (this.topRow < 0) {
            this.topRow = 0;
        } else if (this.topRow > this.realRows - 9) {
            this.topRow = this.realRows - 9;
        }
        ((CraftingStationContainer)this.field_147002_h).updateSlotPositions(this.topRow);
        if (!smooth) {
            this.currentScroll = (double)this.topRow / (double)(this.realRows - 9);
        }
    }
}

