/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.craftingstation;

import com.tfar.craftingstation.Configs;
import com.tfar.craftingstation.CraftingInventoryPersistant;
import com.tfar.craftingstation.CraftingStationTile;
import com.tfar.craftingstation.network.LastRecipePacket;
import com.tfar.craftingstation.network.PacketHandler;
import com.tfar.craftingstation.slot.SlotFastCraft;
import com.tfar.craftingstation.slot.WrapperSlot;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class CraftingStationContainer
extends Container {
    public final CraftingInventoryPersistant craftMatrix;
    public final InventoryCraftResult craftResult = new InventoryCraftResult();
    private static final int SLOT_RESULT = 0;
    public final World world;
    private final EntityPlayer player;
    private final CraftingStationTile tileEntity;
    public BlockPos chestPosition;
    public IRecipe lastRecipe;
    protected IRecipe lastLastRecipe;
    public boolean hasSideContainer;
    public ITextComponent containerName;
    public int subContainerSize = 0;

    public CraftingStationContainer(InventoryPlayer inv, World world, BlockPos pos, EntityPlayer player) {
        this.world = world;
        this.player = player;
        this.tileEntity = (CraftingStationTile)world.func_175625_s(pos);
        this.craftMatrix = new CraftingInventoryPersistant(this, this.tileEntity.input);
        this.hasSideContainer = false;
        this.addOwnSlots();
        TileEntity inventoryTE = null;
        EnumFacing accessDir = null;
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos neighbor = pos.func_177972_a(dir);
            TileEntity te = world.func_175625_s(neighbor);
            if (te == null || te instanceof CraftingStationTile || this.isBlacklisted(te) || te instanceof IInventory && !((IInventory)te).func_70300_a(player)) continue;
            IItemHandler itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (itemHandler instanceof IItemHandlerModifiable) {
                if (te instanceof TileEntityChest) {
                    this.chestPosition = neighbor;
                }
                inventoryTE = te;
                continue;
            }
            itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
            if (!(itemHandler instanceof IItemHandlerModifiable)) continue;
            inventoryTE = te;
            accessDir = dir.func_176734_d();
            break;
        }
        if (inventoryTE != null) {
            this.hasSideContainer = true;
            this.addSideContainerSlots(inventoryTE, accessDir, -125, 18);
            this.containerName = inventoryTE instanceof IInteractionObject ? ((IInteractionObject)inventoryTE).func_145748_c_() : inv.func_145748_c_();
        }
        this.addPlayerSlots(inv);
        this.func_192389_a(world, player, this.craftMatrix, this.craftResult);
    }

    protected boolean isBlacklisted(TileEntity te) {
        if (!te.func_145831_w().field_72995_K) {
            System.out.println(TileEntity.func_190559_a(te.getClass()));
        }
        return Configs.tileentityblacklistresourcelocations.contains(TileEntity.func_190559_a(te.getClass()));
    }

    private void addSideContainerSlots(TileEntity te, EnumFacing dir, int xPos, int yPos) {
        IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
        this.subContainerSize = handler.getSlots();
        if (!this.needsScroll()) {
            xPos += 8;
        }
        for (int y = 0; y < (int)Math.ceil((double)this.subContainerSize / 6.0); ++y) {
            for (int x = 0; x < 6; ++x) {
                int index = 6 * y + x;
                if (index >= this.subContainerSize) continue;
                int offset = y >= 9 ? -10000 : 0;
                WrapperSlot wrapper = new WrapperSlot((Slot)new SlotItemHandler(handler, index, 18 * x + xPos, 18 * y + yPos + offset));
                this.func_75146_a(wrapper);
            }
        }
    }

    public void func_190896_a(List<ItemStack> p_190896_1_) {
        this.craftMatrix.setDoNotCallUpdates(true);
        super.func_190896_a(p_190896_1_);
        this.craftMatrix.setDoNotCallUpdates(false);
        this.craftMatrix.onCraftMatrixChanged();
    }

    private void addOwnSlots() {
        this.func_75146_a((Slot)new SlotFastCraft(this, this.player, this.craftMatrix, (IInventory)this.craftResult, 0, 124, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, x + 3 * y, 30 + 18 * x, 17 + 18 * y));
            }
        }
    }

    private void addPlayerSlots(InventoryPlayer inventoryPlayer) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, 9 + x + 9 * y, 8 + 18 * x, 84 + 18 * y));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, x, 8 + 18 * x, 142));
        }
    }

    public void updateSlotPositions(int offset) {
        for (int i = 10; i < this.subContainerSize + 10; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            int index = (i - 10) / 6 - offset;
            slot.field_75221_f = index >= 9 || index < 0 ? -2000 : 18 + 18 * index;
        }
    }

    public int getSubContainerSize() {
        return this.subContainerSize;
    }

    public void func_75130_a(IInventory inventory) {
        this.func_192389_a(this.world, this.player, this.craftMatrix, this.craftResult);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = slot.func_75211_c().func_77946_l();
        ItemStack stack = slot.func_75211_c().func_77946_l();
        boolean nothingDone = true;
        if (index == 0) {
            if (this.hasSideContainer) {
                nothingDone = this.refillTileInventory(stack);
            }
            nothingDone &= this.moveToPlayerInventory(stack);
            if (this.hasSideContainer) {
                nothingDone &= this.mergeItemStackMove(stack, 10, 10 + this.subContainerSize, false);
            }
        } else if (index < 10) {
            if (this.hasSideContainer) {
                nothingDone = this.refillTileInventory(stack);
            }
            nothingDone &= this.moveToPlayerInventory(stack);
            if (this.hasSideContainer) {
                nothingDone &= this.mergeItemStackMove(stack, 10, 10 + this.subContainerSize, false);
            }
        } else if (index < 10 + this.subContainerSize && this.hasSideContainer) {
            nothingDone = this.moveToCraftingStation(stack);
            nothingDone &= this.moveToPlayerInventory(stack);
        } else if (index >= 10 + this.subContainerSize) {
            nothingDone = this.moveToCraftingStation(stack);
            if (this.hasSideContainer) {
                nothingDone &= this.moveToTileInventory(stack);
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (nothingDone) {
            return ItemStack.field_190927_a;
        }
        return this.notifySlotAfterTransfer(playerIn, stack, ret, slot);
    }

    @Nonnull
    protected ItemStack notifySlotAfterTransfer(EntityPlayer player, @Nonnull ItemStack stack, @Nonnull ItemStack original, Slot slot) {
        slot.func_75220_a(stack, original);
        if (stack.func_190916_E() == original.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_75215_d(stack);
        slot.func_190901_a(player, stack);
        if (slot.func_75216_d() && slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return original;
    }

    protected boolean moveToTileInventory(@Nonnull ItemStack itemstack) {
        return !this.func_75135_a(itemstack, 10, 10 + this.subContainerSize, false);
    }

    protected boolean moveToPlayerInventory(@Nonnull ItemStack itemstack) {
        return !this.func_75135_a(itemstack, 10 + this.subContainerSize, this.field_75151_b.size(), true);
    }

    protected boolean refillTileInventory(@Nonnull ItemStack itemStack) {
        return this.mergeItemStackRefill(itemStack, 10, 10 + this.subContainerSize, false);
    }

    protected boolean moveToCraftingStation(@Nonnull ItemStack itemstack) {
        return !this.func_75135_a(itemstack, 1, 10, false);
    }

    protected boolean func_75135_a(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (!stack.func_190926_b()) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected boolean mergeItemStackRefill(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190926_b()) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(k);
                ItemStack stack1 = slot.func_75211_c();
                if (!stack1.func_190926_b() && stack1.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == stack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stack1) && this.func_94530_a(stack, slot)) {
                    int limit;
                    int l = stack1.func_190916_E() + stack.func_190916_E();
                    if (l <= (limit = Math.min(stack.func_77976_d(), slot.func_178170_b(stack)))) {
                        stack.func_190920_e(0);
                        stack1.func_190920_e(l);
                        slot.func_75218_e();
                        flag1 = true;
                    } else if (stack1.func_190916_E() < limit) {
                        stack.func_190918_g(limit - stack1.func_190916_E());
                        stack1.func_190920_e(limit);
                        slot.func_75218_e();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.func_190926_b()) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.field_75151_b.get(k);
            ItemStack itemstack1 = slot.func_75211_c();
            if (itemstack1.func_190926_b() && slot.func_75214_a(stack) && this.func_94530_a(stack, slot)) {
                int limit = slot.func_178170_b(stack);
                ItemStack stack2 = stack.func_77946_l();
                if (stack2.func_190916_E() > limit) {
                    stack2.func_190920_e(limit);
                    stack.func_190918_g(limit);
                } else {
                    stack.func_190920_e(0);
                }
                slot.func_75215_d(stack2);
                slot.func_75218_e();
                flag1 = true;
                if (stack.func_190926_b()) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }

    private void syncRecipeToAllOpenWindows(IRecipe lastRecipe, List<EntityPlayerMP> players) {
        players.forEach(otherPlayer -> {
            ((CraftingStationContainer)otherPlayer.field_71070_bA).lastRecipe = lastRecipe;
            PacketHandler.INSTANCE.sendTo((IMessage)new LastRecipePacket(lastRecipe), otherPlayer);
        });
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting inv, InventoryCraftResult result) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (this.lastRecipe == null || !this.lastRecipe.func_77569_a(inv, world)) {
            this.lastRecipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)world);
        }
        if (this.lastRecipe != null) {
            itemstack = this.lastRecipe.func_77572_b(inv);
        }
        result.func_70299_a(0, itemstack);
        if (!world.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
            List<EntityPlayerMP> relevantPlayers = this.getAllPlayersWithThisContainerOpen(this, entityplayermp.func_71121_q());
            this.syncResultToAllOpenWindows(itemstack, relevantPlayers);
            if (this.lastLastRecipe != this.lastRecipe) {
                this.syncRecipeToAllOpenWindows(this.lastRecipe, relevantPlayers);
                this.lastLastRecipe = this.lastRecipe;
            }
        }
    }

    private List<EntityPlayerMP> getAllPlayersWithThisContainerOpen(CraftingStationContainer container, WorldServer server) {
        return server.field_73010_i.stream().filter(player -> this.hasSameContainerOpen(container, (EntityPlayer)player)).map(player -> (EntityPlayerMP)player).collect(Collectors.toList());
    }

    private boolean hasSameContainerOpen(CraftingStationContainer container, EntityPlayer playerToCheck) {
        return playerToCheck instanceof EntityPlayerMP && playerToCheck.field_71070_bA.getClass().isAssignableFrom(((Object)((Object)container)).getClass()) && this.sameGui((CraftingStationContainer)playerToCheck.field_71070_bA);
    }

    public boolean sameGui(CraftingStationContainer otherContainer) {
        return this.tileEntity == otherContainer.tileEntity;
    }

    private void syncResultToAllOpenWindows(ItemStack stack, List<EntityPlayerMP> players) {
        players.forEach(otherPlayer -> {
            otherPlayer.field_71070_bA.func_75141_a(0, stack);
            otherPlayer.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(otherPlayer.field_71070_bA.field_75152_c, 0, stack));
        });
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResult && super.func_94530_a(stack, slot);
    }

    public NonNullList<ItemStack> getRemainingItems() {
        if (this.lastRecipe != null && this.lastRecipe.func_77569_a((InventoryCrafting)this.craftMatrix, this.world)) {
            return this.lastRecipe.func_179532_b((InventoryCrafting)this.craftMatrix);
        }
        return this.craftMatrix.field_70466_a;
    }

    public boolean needsScroll() {
        return this.hasSideContainer && this.subContainerSize > 54;
    }

    public void updateLastRecipeFromServer(IRecipe recipe) {
        this.lastRecipe = recipe;
        this.craftResult.func_70299_a(0, recipe != null ? recipe.func_77572_b((InventoryCrafting)this.craftMatrix) : ItemStack.field_190927_a);
    }

    public int getRows() {
        return (int)Math.ceil((double)this.subContainerSize / 6.0);
    }
}

