/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.ceramics.blocks.BlockBarrel;
import knightminer.ceramics.library.tank.BarrelTank;
import knightminer.ceramics.library.tank.IFastMarkDirty;
import knightminer.ceramics.library.tank.IFluidUpdateReciever;
import knightminer.ceramics.network.BarrelSizeChangedPacket;
import knightminer.ceramics.network.CeramicsNetwork;
import knightminer.ceramics.tileentity.TileBarrelBase;
import knightminer.ceramics.tileentity.TileBarrelExtension;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileBarrel
extends TileBarrelBase
implements IFluidUpdateReciever,
IFastMarkDirty {
    private static final int BASE_CAPACITY = 4000;
    public int height;
    private BarrelTank tank;
    private int baseCapacity;
    private int capacity;
    private int lastStrength;
    public static final String TAG_TANK = "tank";
    public static final String TAG_HEIGHT = "height";
    @Deprecated
    public static final String TAG_TOP = "topPos";
    @Deprecated
    public static final String TAG_CAPACITY = "capacity";
    public static final String TAG_BASE_CAPACITY = "baseCapacity";

    public TileBarrel() {
        this(4000);
    }

    public TileBarrel(int baseCapacity) {
        this.tank = new BarrelTank(baseCapacity, this);
        this.baseCapacity = this.capacity = baseCapacity;
        this.lastStrength = -1;
        this.height = 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public BarrelTank getTank() {
        return this.tank;
    }

    @Override
    public void checkBarrelStructure() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Block teBlock = this.func_145838_q();
        if (!(teBlock instanceof BlockBarrel)) {
            return;
        }
        BlockBarrel barrel = (BlockBarrel)teBlock;
        BlockPos topPos = this.field_174879_c.func_177984_a();
        while (barrel.isValidExtension(this.field_145850_b.func_180495_p(topPos))) {
            TileEntity te = this.field_145850_b.func_175625_s(topPos);
            if (te instanceof TileBarrelExtension) {
                ((TileBarrelExtension)te).setMaster(this.field_174879_c);
            }
            topPos = topPos.func_177984_a();
        }
        this.height = topPos.func_177977_b().func_177956_o() - this.field_174879_c.func_177956_o();
        int newCapacity = this.baseCapacity * (this.height + 1);
        if (newCapacity != this.capacity) {
            this.capacity = newCapacity;
            this.tank.setCapacity(newCapacity);
            this.onTankContentsChanged();
            CeramicsNetwork.sendToAllAround(this.field_145850_b, this.field_174879_c, new BarrelSizeChangedPacket(this.field_174879_c, this.capacity, this.height));
        }
    }

    public int comparatorStrength() {
        return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    public void onTankContentsChanged() {
        int newStrength = this.comparatorStrength();
        if (newStrength != this.lastStrength) {
            this.lastStrength = newStrength;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int y = this.field_174879_c.func_177956_o();
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(y += this.height + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        int oldAmount = this.tank.getFluidAmount();
        this.tank.setFluid(fluid);
        this.tank.renderOffset += this.tank.getFluidAmount() - oldAmount;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSize(int capacity, int height) {
        this.capacity = capacity;
        this.tank.setCapacity(capacity);
        this.height = height;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        tags.func_74782_a(TAG_TANK, (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tags.func_74768_a(TAG_HEIGHT, this.height);
        tags.func_74768_a(TAG_BASE_CAPACITY, this.baseCapacity);
        return tags;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        NBTTagCompound tankTag = tags.func_74775_l(TAG_TANK);
        if (tankTag != null) {
            this.tank.readFromNBT(tankTag);
        }
        if (tags.func_74764_b(TAG_HEIGHT)) {
            this.height = tags.func_74762_e(TAG_HEIGHT);
        } else {
            NBTTagCompound top = tags.func_74775_l(TAG_TOP);
            if (top != null && top.func_74764_b("y")) {
                int y = top.func_74762_e("y");
                this.height = y - this.field_174879_c.func_177956_o();
            }
        }
        if (tags.func_74764_b(TAG_BASE_CAPACITY)) {
            this.baseCapacity = tags.func_74762_e(TAG_BASE_CAPACITY);
        }
        this.capacity = this.baseCapacity * (this.height + 1);
        this.tank.setCapacity(this.capacity);
    }
}

