/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BackpackUtils {
    public static String getBackpackColor(World world, BlockPos pos) {
        TileEntityTravelersBackpack backpack = (TileEntityTravelersBackpack)world.func_175625_s(pos);
        return backpack.getColor();
    }

    public static int convertNameToMeta(String name) {
        for (int x = 0; x < Reference.BACKPACK_NAMES.length; ++x) {
            String string = Reference.BACKPACK_NAMES[x];
            if (!string.toLowerCase().equals(name.toLowerCase())) continue;
            return x;
        }
        return 0;
    }

    public static void onPlayerDeath(World world, EntityPlayer player, ItemStack stack) {
        if (CapabilityUtils.getWearingBackpack(player).func_77960_j() == 64) {
            world.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 4.0f, false);
        }
        ITravelersBackpack cap = CapabilityUtils.getCapability(player);
        if (ConfigHandler.server.backpackDeathPlace) {
            if (!BackpackUtils.tryPlace(world, player, stack)) {
                player.func_70099_a(stack, 1.0f);
                cap.removeWearable();
                if (!world.field_72995_K && ConfigHandler.client.enableBackpackCoordsMessage) {
                    String translation = new TextComponentTranslation("information.travelersbackpack.backpack_drop", new Object[0]).func_150254_d();
                    player.func_145747_a((ITextComponent)new TextComponentString(translation + " X: " + player.func_180425_c().func_177958_n() + " Y: " + player.func_180425_c().func_177956_o() + " Z: " + player.func_180425_c().func_177952_p()));
                }
            }
        } else {
            player.func_70099_a(stack, 1.0f);
            cap.removeWearable();
        }
    }

    private static boolean tryPlace(World world, EntityPlayer player, ItemStack itemstack) {
        int[] positions;
        int X = (int)player.field_70165_t;
        int Z = (int)player.field_70161_v;
        for (int Y : positions = new int[]{0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6}) {
            BlockPos spawn = BackpackUtils.getNearestEmptyChunkCoordinatesSpiral((IBlockAccess)world, X, Z, new BlockPos(X, (int)player.field_70163_u + Y, Z), 12, true, 1, (byte)0, false);
            if (spawn == null) continue;
            return BackpackUtils.placeBackpack(itemstack, player, world, spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p(), EnumFacing.UP);
        }
        return false;
    }

    public static boolean placeBackpack(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, EnumFacing facing) {
        Block block;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((block = ModBlocks.TRAVELERS_BACKPACK).func_176198_a(world, new BlockPos(x, y, z), facing)) {
            BlockPos targetPos;
            if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76220_a()) {
                switch (facing) {
                    case DOWN: {
                        --y;
                        break;
                    }
                    case UP: {
                        ++y;
                        break;
                    }
                    case NORTH: {
                        --z;
                        break;
                    }
                    case SOUTH: {
                        ++z;
                        break;
                    }
                    case WEST: {
                        --x;
                        break;
                    }
                    case EAST: {
                        ++x;
                    }
                }
            }
            if (y <= 0 || y >= world.func_72800_K()) {
                return false;
            }
            if (block.func_176196_c(world, new BlockPos(x, y, z)) && world.func_180495_p(targetPos = new BlockPos(x, y, z)).func_185904_a().func_76222_j() && !world.func_180495_p(targetPos).func_185904_a().func_76220_a()) {
                if (world.func_175656_a(targetPos, ModBlocks.TRAVELERS_BACKPACK.func_176223_P()) && !world.field_72995_K && ConfigHandler.client.enableBackpackCoordsMessage) {
                    String translation = new TextComponentTranslation("information.travelersbackpack.backpack_coords", new Object[0]).func_150254_d();
                    player.func_145747_a((ITextComponent)new TextComponentString(translation + " X: " + x + " Y: " + y + " Z: " + z));
                }
                world.func_184148_a(player, (double)x, (double)y, (double)z, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
                ((TileEntityTravelersBackpack)world.func_175625_s(targetPos)).loadAllData(stack.func_77978_p());
                ((TileEntityTravelersBackpack)world.func_175625_s(targetPos)).setColorFromMeta(stack.func_77960_j());
                if (CapabilityUtils.isWearingBackpack(player)) {
                    ITravelersBackpack cap = CapabilityUtils.getCapability(player);
                    cap.setWearable(ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public static BlockPos findBlock3D(World world, int x, int y, int z, Block block, int hRange, int vRange) {
        for (int i = y - vRange; i <= y + vRange; ++i) {
            for (int j = x - hRange; j <= x + hRange; ++j) {
                for (int k = z - hRange; k <= z + hRange; ++k) {
                    if (world.func_180495_p(new BlockPos(j, i, k)).func_177230_c() != block) continue;
                    return new BlockPos(j, i, k);
                }
            }
        }
        return null;
    }

    public static BlockPos getNearestEmptyChunkCoordinatesSpiral(IBlockAccess world, int origX, int origZ, BlockPos pos, int radius, boolean except, int steps, byte pass, boolean type) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = pos.func_177958_n(); i <= pos.func_177958_n() + steps; ++i) {
                    BlockPos blockPos;
                    BlockPos blockPos2 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, steps, pass, type);
            }
            if (pass == 1) {
                for (j = pos.func_177952_p(); j >= pos.func_177952_p() - steps; --j) {
                    BlockPos blockPos;
                    BlockPos blockPos3 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, ++steps, pass, type);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= pos.func_177958_n() - steps) {
                    BlockPos blockPos;
                    BlockPos blockPos4 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, steps, pass, type);
            }
            if (pass == 1) {
                while (j <= pos.func_177952_p() + steps) {
                    BlockPos blockPos;
                    BlockPos blockPos5 = blockPos = type ? BackpackUtils.checkCoordsForPlayer(world, origX, origZ, pos, except) : BackpackUtils.checkCoordsForBackpack(world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, new BlockPos(i, pos.func_177956_o(), j), radius, except, ++steps, pass, type);
            }
        }
        return null;
    }

    private static BlockPos checkCoordsForBackpack(IBlockAccess world, int origX, int origZ, BlockPos pos, boolean except) {
        if (except && world.isSideSolid(pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP, true) && world.func_175623_d(pos) && !BackpackUtils.areCoordinatesTheSame(new BlockPos(origX, pos.func_177956_o(), origZ), pos)) {
            return pos;
        }
        if (!except && world.isSideSolid(pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP, true) && world.func_175623_d(pos)) {
            return pos;
        }
        return null;
    }

    private static BlockPos checkCoordsForPlayer(IBlockAccess world, int origX, int origZ, BlockPos pos, boolean except) {
        if (except && world.isSideSolid(pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP, true) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP)) && !BackpackUtils.areCoordinatesTheSame2D(origX, origZ, pos.func_177958_n(), pos.func_177952_p())) {
            return pos;
        }
        if (!except && world.isSideSolid(pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP, true) && world.func_175623_d(pos) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
            return pos;
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(BlockPos pos1, BlockPos pos2) {
        return pos1 == pos2;
    }

    private static boolean areCoordinatesTheSame2D(int X1, int Z1, int X2, int Z2) {
        return X1 == X2 && Z1 == Z2;
    }

    public static boolean findSleepingBag(World world, BlockPos pos) {
        Block targetBlock1 = ModBlocks.SLEEPING_BAG_BOTTOM;
        Block targetBlock2 = ModBlocks.SLEEPING_BAG_TOP;
        int n = 0;
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n2 = enumFacingArray.length;
        if (n < n2) {
            EnumFacing facing = enumFacingArray[n];
            return world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == targetBlock1 || world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == targetBlock2;
        }
        return false;
    }
}

