/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.tileentity;

import com.tiviacz.travelersbackpack.blocks.BlockSleepingBag;
import com.tiviacz.travelersbackpack.blocks.BlockTravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.gui.container.ContainerTravelersBackpack;
import com.tiviacz.travelersbackpack.gui.inventory.IInventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.gui.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityTravelersBackpack
extends TileEntity
implements IInventoryTravelersBackpack,
ITickable {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> craftingGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final FluidTank leftTank = new FluidTank(Reference.BASIC_TANK_CAPACITY);
    private final FluidTank rightTank = new FluidTank(Reference.BASIC_TANK_CAPACITY);
    private boolean isSleepingBagDeployed = false;
    private String color = "null";
    private int lastTime = 0;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.saveAllData(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.loadAllData(compound);
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    public void setSleepingBagDeployed(boolean deployed) {
        this.isSleepingBagDeployed = deployed;
    }

    public boolean deploySleepingBag(World world, BlockPos pos) {
        BlockPos sleepingBagPos1;
        BlockPos sleepingBagPos2;
        EnumFacing blockFacing = this.getBlockFacing(world.func_175625_s(this.func_174877_v()));
        this.isThereSleepingBag(blockFacing);
        if (!this.isSleepingBagDeployed && world.func_175623_d(sleepingBagPos2 = (sleepingBagPos1 = pos.func_177972_a(blockFacing)).func_177972_a(blockFacing)) && world.func_175623_d(sleepingBagPos1) && world.func_180495_p(sleepingBagPos1.func_177977_b()).isSideSolid((IBlockAccess)world, sleepingBagPos1.func_177977_b(), EnumFacing.UP) && world.func_180495_p(sleepingBagPos2.func_177977_b()).isSideSolid((IBlockAccess)world, sleepingBagPos2.func_177977_b(), EnumFacing.UP)) {
            world.func_184133_a(null, sleepingBagPos2, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
            if (!world.field_72995_K) {
                world.func_175656_a(sleepingBagPos1, ModBlocks.SLEEPING_BAG_BOTTOM.func_176223_P().func_177226_a((IProperty)BlockSleepingBag.field_185512_D, (Comparable)blockFacing));
                world.func_175656_a(sleepingBagPos2, ModBlocks.SLEEPING_BAG_TOP.func_176223_P().func_177226_a((IProperty)BlockSleepingBag.field_185512_D, (Comparable)blockFacing));
                world.func_175722_b(pos, ModBlocks.SLEEPING_BAG_BOTTOM, false);
                world.func_175722_b(sleepingBagPos2, ModBlocks.SLEEPING_BAG_TOP, false);
            }
            this.isSleepingBagDeployed = true;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(World world) {
        EnumFacing blockFacing = this.getBlockFacing(world.func_175625_s(this.func_174877_v()));
        this.isThereSleepingBag(blockFacing);
        if (this.isSleepingBagDeployed) {
            BlockPos sleepingBagPos1 = this.field_174879_c.func_177972_a(blockFacing);
            BlockPos sleepingBagPos2 = sleepingBagPos1.func_177972_a(blockFacing);
            if (world.func_180495_p(sleepingBagPos1).func_177230_c() == ModBlocks.SLEEPING_BAG_BOTTOM && world.func_180495_p(sleepingBagPos2).func_177230_c() == ModBlocks.SLEEPING_BAG_TOP) {
                world.func_184133_a(null, sleepingBagPos2, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.5f, 1.0f);
                world.func_175698_g(sleepingBagPos1);
                world.func_175698_g(sleepingBagPos2);
                this.isSleepingBagDeployed = false;
                this.func_70296_d();
                return true;
            }
        } else {
            this.isSleepingBagDeployed = false;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(EnumFacing facing) {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing)).func_177230_c() == ModBlocks.SLEEPING_BAG_BOTTOM && this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing).func_177972_a(facing)).func_177230_c() == ModBlocks.SLEEPING_BAG_TOP) {
            return true;
        }
        this.isSleepingBagDeployed = false;
        return false;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public void saveAllData(NBTTagCompound compound) {
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveSleepingBag(compound);
        this.saveColor(compound);
        this.saveTime(compound);
    }

    @Override
    public void loadAllData(NBTTagCompound compound) {
        this.loadTanks(compound);
        this.loadItems(compound);
        this.loadSleepingBag(compound);
        this.loadColor(compound);
        this.loadTime(compound);
    }

    @Override
    public void saveTanks(NBTTagCompound compound) {
        compound.func_74782_a("LeftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("RightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void loadTanks(NBTTagCompound compound) {
        this.leftTank.readFromNBT(compound.func_74775_l("LeftTank"));
        this.rightTank.readFromNBT(compound.func_74775_l("RightTank"));
    }

    public void saveSleepingBag(NBTTagCompound compound) {
        compound.func_74757_a("isSleepingBagDeployed", this.isSleepingBagDeployed);
    }

    public void loadSleepingBag(NBTTagCompound compound) {
        if (compound.func_74764_b("isSleepingBagDeployed")) {
            this.isSleepingBagDeployed = compound.func_74767_n("isSleepingBagDeployed");
        }
    }

    public String getColorFromMeta(int meta) {
        return Reference.BACKPACK_NAMES[meta];
    }

    public void setColorFromMeta(int meta) {
        this.color = Reference.BACKPACK_NAMES[meta];
    }

    @Override
    public String getColor() {
        if (this.color != null) {
            return this.color;
        }
        return "Standard";
    }

    public void saveColor(NBTTagCompound compound) {
        compound.func_74778_a("Color", this.color);
    }

    public void loadColor(NBTTagCompound compound) {
        if (compound.func_74764_b("Color")) {
            this.color = compound.func_74779_i("Color");
        }
    }

    @Override
    public void saveItems(NBTTagCompound compound) {
        ItemStackUtils.saveAllItems(compound, this.inventory, this.craftingGrid);
    }

    @Override
    public void loadItems(NBTTagCompound compound) {
        ItemStackUtils.loadAllItems(compound, this.inventory, this.craftingGrid);
    }

    @Override
    public void saveTime(NBTTagCompound compound) {
        compound.func_74768_a("LastTime", this.lastTime);
    }

    @Override
    public void loadTime(NBTTagCompound compound) {
        this.lastTime = compound.func_74762_e("LastTime");
    }

    public boolean drop(World world, EntityPlayer player, int x, int y, int z) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = new ItemStack(ModItems.TRAVELERS_BACKPACK, 1, BackpackUtils.convertNameToMeta(this.color));
        this.transferToItemStack(stack);
        EntityItem droppedItem = new EntityItem(world, (double)x, (double)y, (double)z, stack);
        return world.func_72838_d((Entity)droppedItem);
    }

    public ItemStack transferToItemStack(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        this.saveTanks(compound);
        this.saveItems(compound);
        this.saveTime(compound);
        stack.func_77982_d(compound);
        return stack;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    private void notifyBlockUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.notifyBlockUpdate();
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 50, this.getUsingPlayer()) || InventoryActions.transferContainerTank(this, this.getRightTank(), 52, this.getUsingPlayer());
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    private EntityPlayer getUsingPlayer() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        if (!this.field_145850_b.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                if (!(entityplayer.field_71070_bA instanceof ContainerTravelersBackpack)) continue;
                return entityplayer;
            }
        }
        return null;
    }

    public EnumFacing getBlockFacing(TileEntity tile) {
        if (tile instanceof TileEntityTravelersBackpack) {
            return (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockTravelersBackpack.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public void markTankDirty() {
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventory.set(index, (Object)ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public String func_70005_c_() {
        return "TileInventoryTravelersBackpack";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public NBTTagCompound getTagCompound(ItemStack stack) {
        return null;
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getCraftingGridInventory() {
        return this.craftingGrid;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    public void func_73660_a() {
        if (BackpackAbilities.hasTileAbility(this.color)) {
            BackpackAbilities.backpackAbilities.executeTileAbility(this.getUsingPlayer(), this.func_145831_w(), this);
        }
    }

    @Override
    public void markTimeDirty() {
    }
}

