/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.proxy;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.client.render.LayerTravelersBackpack;
import com.tiviacz.travelersbackpack.client.render.RendererItemTravelersBackpack;
import com.tiviacz.travelersbackpack.client.render.RendererTileTravelersBackpack;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.proxy.CommonProxy;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    public static KeyBinding openBackpack = new KeyBinding("key.travelersbackpack.inventory", 48, "key.travelersbackpack.category");
    public static KeyBinding toggleTank = new KeyBinding("key.travelersbackpack.toggle_tank", 49, "key.travelersbackpack.category");
    public static KeyBinding cycleTool = new KeyBinding("key.travelersbackpack.cycle_tool", 44, "key.travelersbackpack.category");

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        this.addBackpackItemRenderer();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.registerTESR();
        this.addWearableModel();
        this.registerKeyBindings();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), id));
    }

    public void registerKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)openBackpack);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleTank);
        ClientRegistry.registerKeyBinding((KeyBinding)cycleTool);
    }

    public void registerTESR() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTravelersBackpack.class, (TileEntitySpecialRenderer)new RendererTileTravelersBackpack());
    }

    public void addBackpackItemRenderer() {
        ModItems.TRAVELERS_BACKPACK.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RendererItemTravelersBackpack());
    }

    public void addWearableModel() {
        for (RenderPlayer renderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            renderer.func_177094_a((LayerRenderer)new LayerTravelersBackpack(renderer));
        }
    }

    @Override
    public void handleBackpackCapability(NBTTagCompound tag, int entityID) {
        EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(entityID);
        ITravelersBackpack cap = CapabilityUtils.getCapability(player);
        if (cap != null) {
            cap.setWearable(new ItemStack(tag));
        }
    }
}

