/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SleepingBagPacket
implements IMessage {
    public int x;
    public int y;
    public int z;

    public SleepingBagPacket() {
    }

    public SleepingBagPacket(int X, int Y, int Z) {
        this.x = X;
        this.y = Y;
        this.z = Z;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static class Handler
    implements IMessageHandler<SleepingBagPacket, IMessage> {
        public IMessage onMessage(SleepingBagPacket message, MessageContext ctx) {
            EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (ctx.side.isServer() && sendingPlayer != null) {
                WorldServer playerWorldServer = sendingPlayer.func_71121_q();
                playerWorldServer.func_152344_a(() -> ServerActions.toggleSleepingBag((EntityPlayer)sendingPlayer, message.x, message.y, message.z));
            }
            return null;
        }
    }
}

