/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.api.fluids.effects.FluidEffect;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.fluids.FluidEffectRegistry;
import com.tiviacz.travelersbackpack.gui.inventory.InventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.items.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHose
extends ItemBase {
    public ItemHose(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("mode"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    float j = 0.0f;
                    return 0.0f;
                }
                float j = nbt.func_74762_e("Mode");
                return j;
            }
        });
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (ItemHose.getHoseMode(stack) == 3) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 24;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (CapabilityUtils.isWearingBackpack(playerIn)) {
            InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(playerIn);
            if (ItemHose.getHoseMode(stack) == 1 && target instanceof EntityCow) {
                FluidTank tank = this.getSelectedFluidTank(stack, inv);
                FluidStack milk = null;
                if (FluidRegistry.isFluidRegistered((String)"milk")) {
                    milk = new FluidStack(FluidRegistry.getFluid((String)"milk"), 1000);
                }
                if (milk == null) {
                    return false;
                }
                if (tank.getFluid() == null || tank.getFluidAmount() > 0 && tank.getFluidAmount() + 1000 <= tank.getCapacity() && tank.getFluid().isFluidEqual(milk)) {
                    tank.fill(milk, true);
                    playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), SoundEvents.field_187564_an, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    inv.markTankDirty();
                    ((EntityCow)target).func_70625_a((Entity)playerIn, 0.1f, 0.1f);
                    return true;
                }
            }
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            ItemStack stack = player.func_184614_ca();
            InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
            FluidTank tank = this.getSelectedFluidTank(stack, inv);
            IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)worldIn, (BlockPos)pos, (EnumFacing)facing);
            if (fluidHandler != null) {
                int fluidAmount;
                FluidStack fluid;
                if (ItemHose.getHoseMode(stack) == 1 && tank.canFill() && fluidHandler.getTankProperties()[0].canDrain()) {
                    fluid = fluidHandler.getTankProperties()[0].getContents();
                    fluidAmount = tank.fill(fluidHandler.drain(1000, false), false);
                    if ((tank.getFluid() == null || tank.getFluidAmount() > 0 && tank.getFluidAmount() + fluidAmount <= tank.getCapacity() && tank.getFluid().isFluidEqual(fluid)) && fluidAmount > 0) {
                        tank.fill(fluidHandler.drain(1000, true), true);
                        worldIn.func_184133_a(null, pos, fluid.getFluid().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        inv.markTankDirty();
                        return EnumActionResult.SUCCESS;
                    }
                }
                if (ItemHose.getHoseMode(stack) == 2 && tank.canDrain() && fluidHandler.getTankProperties()[0].canFill()) {
                    fluid = tank.getFluid();
                    fluidAmount = fluidHandler.fill(tank.drain(1000, false), false);
                    IFluidTankProperties fluidHandlerProp = fluidHandler.getTankProperties()[0];
                    if ((fluidHandlerProp.getContents() == null || fluidHandlerProp.getContents().amount + fluidAmount <= fluidHandlerProp.getCapacity() && fluidHandlerProp.getContents().isFluidEqual(fluid)) && fluidAmount > 0) {
                        fluidHandler.fill(tank.drain(1000, true), true);
                        worldIn.func_184133_a(null, pos, fluid.getFluid().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        inv.markTankDirty();
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    public static int getHoseMode(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e("Mode");
        }
        return 0;
    }

    public static int getHoseTank(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e("Tank");
        }
        return 0;
    }

    public FluidTank getSelectedFluidTank(ItemStack stack, InventoryTravelersBackpack inv) {
        return ItemHose.getHoseTank(stack) == 1 ? inv.getLeftTank() : inv.getRightTank();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (CapabilityUtils.isWearingBackpack(playerIn) && handIn == EnumHand.MAIN_HAND) {
            if (stack.func_77978_p() == null) {
                this.getTagCompound(stack);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(playerIn);
            RayTraceResult result = this.func_77621_a(worldIn, playerIn, true);
            RayTraceResult nonFluidResult = this.func_77621_a(worldIn, playerIn, false);
            FluidTank tank = this.getSelectedFluidTank(stack, inv);
            if (tank != null) {
                if (ItemHose.getHoseMode(stack) == 1 && result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && playerIn.func_175151_a(result.func_178782_a(), result.field_178784_b, stack)) {
                    Block blockResult = worldIn.func_180495_p(result.func_178782_a()).func_177230_c();
                    if (blockResult instanceof IFluidBlock) {
                        int amount;
                        FluidStack fluidStack = new FluidStack(((IFluidBlock)blockResult).getFluid(), 1000);
                        if ((tank.getFluidAmount() == 0 || tank.getFluid().isFluidEqual(fluidStack)) && (amount = tank.fill(fluidStack, false)) > 0 && tank.getFluidAmount() + amount <= tank.getCapacity()) {
                            worldIn.func_175698_g(result.func_178782_a());
                            tank.fill(fluidStack, true);
                            inv.markTankDirty();
                            worldIn.func_184133_a(null, result.func_178782_a(), fluidStack.getFluid().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                        }
                    } else if (blockResult instanceof BlockLiquid) {
                        int amount;
                        BlockLiquidWrapper wrapper = new BlockLiquidWrapper((BlockLiquid)blockResult, worldIn, result.func_178782_a());
                        FluidStack fluidStack = new FluidStack(wrapper.getTankProperties()[0].getContents(), 1000);
                        if ((tank.getFluidAmount() == 0 || tank.getFluid().isFluidEqual(fluidStack)) && (amount = tank.fill(fluidStack, false)) > 0 && tank.getFluidAmount() + amount <= tank.getCapacity()) {
                            worldIn.func_175698_g(result.func_178782_a());
                            tank.fill(fluidStack, true);
                            inv.markTankDirty();
                            worldIn.func_184133_a(null, result.func_178782_a(), fluidStack.getFluid().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                        }
                    }
                }
                if (ItemHose.getHoseMode(stack) == 2 && nonFluidResult != null && nonFluidResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                    FluidStack fluidStack;
                    int x = nonFluidResult.func_178782_a().func_177958_n();
                    int y = nonFluidResult.func_178782_a().func_177956_o();
                    int z = nonFluidResult.func_178782_a().func_177952_p();
                    if (!worldIn.func_180495_p(nonFluidResult.func_178782_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, nonFluidResult.func_178782_a())) {
                        switch (nonFluidResult.field_178784_b) {
                            case WEST: {
                                --x;
                                break;
                            }
                            case EAST: {
                                ++x;
                                break;
                            }
                            case DOWN: {
                                --y;
                                break;
                            }
                            case NORTH: {
                                --z;
                                break;
                            }
                            case SOUTH: {
                                ++z;
                                break;
                            }
                            case UP: {
                                ++y;
                                break;
                            }
                        }
                    }
                    BlockPos newResult = new BlockPos(x, y, z);
                    if (tank.getFluid() != null && tank.getFluidAmount() > 0 && (fluidStack = tank.getFluid()).getFluid().canBePlacedInWorld()) {
                        boolean flag;
                        Material material = worldIn.func_180495_p(newResult).func_185904_a();
                        boolean bl = flag = !material.func_76220_a();
                        if (worldIn.field_73011_w.func_177500_n() && fluidStack.getFluid() == FluidRegistry.WATER) {
                            tank.drain(1000, true);
                            inv.markTankDirty();
                            worldIn.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                            for (int i = 0; i < 3; ++i) {
                                double d0 = (double)newResult.func_177958_n() + worldIn.field_73012_v.nextDouble();
                                double d1 = (double)newResult.func_177956_o() + worldIn.field_73012_v.nextDouble() * 0.5 + 0.5;
                                double d2 = (double)newResult.func_177952_p() + worldIn.field_73012_v.nextDouble();
                                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                            }
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                        }
                        FluidStack drainedFluid = tank.drain(1000, false);
                        if (drainedFluid != null && drainedFluid.amount >= 1000) {
                            if (!worldIn.field_72995_K && flag && !material.func_76224_d()) {
                                worldIn.func_175655_b(newResult, true);
                            }
                            if (worldIn.func_175656_a(newResult, fluidStack.getFluid().getBlock().func_176223_P())) {
                                tank.drain(1000, true);
                                worldIn.func_180495_p(newResult).func_189546_a(worldIn, newResult, fluidStack.getFluid().getBlock(), newResult);
                            }
                            worldIn.func_184133_a(null, newResult, drainedFluid.getFluid().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            inv.markTankDirty();
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                        }
                    }
                }
                if (ItemHose.getHoseMode(stack) == 3 && tank.getFluid() != null && FluidEffectRegistry.hasFluidEffectAndCanExecute(tank.getFluid(), worldIn, (Entity)playerIn)) {
                    playerIn.func_184598_c(EnumHand.MAIN_HAND);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        EntityPlayer player;
        if (entityLiving instanceof EntityPlayer && CapabilityUtils.isWearingBackpack(player = (EntityPlayer)entityLiving)) {
            InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
            FluidTank tank = this.getSelectedFluidTank(stack, inv);
            if (ItemHose.getHoseMode(stack) == 3 && tank != null && ServerActions.setFluidEffect(worldIn, player, tank)) {
                FluidEffect targetEffect = FluidEffectRegistry.getFluidEffect(tank.getFluid().getFluid());
                tank.drain(targetEffect.amountRequired, true);
                inv.markTankDirty();
            }
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer && !CapabilityUtils.isWearingBackpack((EntityPlayer)entityIn) && stack.func_77978_p() != null) {
            stack.func_77982_d(null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ItemHose.getHoseMode(stack) == 0) {
            tooltip.add("Hose not assigned");
        } else if (stack.func_77978_p() != null) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74762_e("Mode") == 1) {
                tooltip.add("Current mode: suck");
            }
            if (tag.func_74762_e("Mode") == 2) {
                tooltip.add("Current mode: spill");
            }
            if (tag.func_74762_e("Mode") == 3) {
                tooltip.add("Current mode: drink");
            }
            if (tag.func_74762_e("Tank") == 1) {
                tooltip.add("Current tank: left");
            }
            if (tag.func_74762_e("Tank") == 2) {
                tooltip.add("Current tank: right");
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        int x = ItemHose.getHoseMode(stack);
        String mode = "";
        String localizedName = new TextComponentTranslation("item.hose.name", new Object[0]).func_150254_d();
        String suckMode = new TextComponentTranslation("item.hose.suck", new Object[0]).func_150254_d();
        String spillMode = new TextComponentTranslation("item.hose.spill", new Object[0]).func_150254_d();
        String drinkMode = new TextComponentTranslation("item.hose.drink", new Object[0]).func_150254_d();
        if (x == 1) {
            mode = " " + suckMode;
        } else if (x == 2) {
            mode = " " + spillMode;
        } else if (x == 3) {
            mode = " " + drinkMode;
        }
        return localizedName + mode;
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(tag = stack.func_77978_p()).func_74764_b("Tank")) {
            tag.func_74768_a("Tank", 1);
        }
        if (!tag.func_74764_b("Mode")) {
            tag.func_74768_a("Mode", 1);
        }
        return tag;
    }
}

