/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.tileentity;

import javax.annotation.Nonnull;
import lyeoj.tfcthings.capability.CapabilitySharpness;
import lyeoj.tfcthings.capability.ISharpness;
import lyeoj.tfcthings.event.TFCThingsEventHandler;
import lyeoj.tfcthings.init.TFCThingsItems;
import lyeoj.tfcthings.init.TFCThingsSoundEvents;
import lyeoj.tfcthings.items.ItemGrindstone;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.blocks.BlockFluidWater;
import net.dries007.tfc.objects.te.TEInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityGrindstone
extends TEInventory
implements ITickable {
    public static final int SLOT_GRINDSTONE = 0;
    public static final int SLOT_INPUT = 1;
    private int rotationTimer = 0;
    private boolean hasGrindstone;

    public TileEntityGrindstone() {
        super(2);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.rotationTimer = nbt.func_74762_e("rotationTimer");
        this.hasGrindstone = this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemGrindstone;
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("rotationTimer", this.rotationTimer);
        return super.func_189515_b(nbt);
    }

    public ItemStack getGrindstone() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean hasGrindstone() {
        return this.hasGrindstone;
    }

    public int getRotationTimer() {
        return this.rotationTimer;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.func_77973_b() instanceof ItemGrindstone;
            }
            case 1: {
                return stack.hasCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null);
            }
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public ItemStack insertOrSwapItem(int slot, ItemStack playerStack) {
        ItemStack grindstoneStack = this.inventory.getStackInSlot(slot);
        if (!(grindstoneStack.func_190926_b() || playerStack.func_77985_e() && grindstoneStack.func_77985_e() && grindstoneStack.func_77973_b() == playerStack.func_77973_b() && (!playerStack.func_77981_g() || playerStack.func_77960_j() == grindstoneStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)playerStack, (ItemStack)grindstoneStack))) {
            this.inventory.setStackInSlot(slot, playerStack);
            return grindstoneStack;
        }
        return this.inventory.insertItem(slot, playerStack, false);
    }

    public void setAndUpdateSlots(int slot) {
        this.markForBlockUpdate();
        if (slot == 0) {
            this.hasGrindstone = this.inventory.getStackInSlot(0).func_77973_b() instanceof ItemGrindstone;
        }
        super.setAndUpdateSlots(slot);
    }

    public void func_73660_a() {
        ItemStack grindstoneStack;
        ItemStack inputStack = this.inventory.getStackInSlot(1);
        if (this.shouldStartGrinding(inputStack, grindstoneStack = this.inventory.getStackInSlot(0))) {
            if (this.rotationTimer > 0) {
                --this.rotationTimer;
            }
            if (this.rotationTimer == 1) {
                this.sharpenItem(inputStack, grindstoneStack);
                this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, TFCThingsSoundEvents.WHETSTONE_SHARPEN, SoundCategory.BLOCKS, 0.2f, 0.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) / 16.0f);
                if (grindstoneStack.func_190926_b()) {
                    for (int i = 0; i < 15; ++i) {
                        this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.875, (double)this.field_174879_c.func_177952_p() + 0.5, (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) / 4.0, this.field_145850_b.field_73012_v.nextDouble() / 4.0, (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) / 4.0, new int[]{Item.func_150891_b((Item)TFCThingsItems.ITEM_GRINDSTONE_QUARTZ)});
                    }
                    this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 1.0f, 0.8f);
                    this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.7f, 0.6f);
                }
                this.setAndUpdateSlots(0);
            }
            if (this.rotationTimer == 0) {
                this.rotationTimer = 90;
                this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, TFCSounds.QUERN_USE, SoundCategory.BLOCKS, 0.2f, 0.8f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) / 16.0f);
            }
        } else {
            this.rotationTimer = 0;
        }
    }

    private BlockPos getFluidLocation() {
        int dir = this.func_145832_p();
        BlockPos check = this.field_174879_c.func_177977_b();
        switch (dir) {
            case 0: {
                check = check.func_177974_f();
                break;
            }
            case 1: {
                check = check.func_177968_d();
                break;
            }
            case 2: {
                check = check.func_177976_e();
                break;
            }
            default: {
                check = check.func_177978_c();
            }
        }
        return check;
    }

    public int getFlowDirection() {
        if (this.field_145850_b.func_180495_p(this.getFluidLocation()).func_177230_c() instanceof BlockFluidWater) {
            BlockFluidWater water = (BlockFluidWater)this.field_145850_b.func_180495_p(this.getFluidLocation()).func_177230_c();
            if (this.func_145832_p() == 0 || this.func_145832_p() == 2) {
                double flow = water.getFlowVector((IBlockAccess)this.field_145850_b, (BlockPos)this.getFluidLocation()).field_72449_c;
                if (flow > 0.0) {
                    return 2;
                }
                if (flow < 0.0) {
                    return 1;
                }
            } else {
                double flow = water.getFlowVector((IBlockAccess)this.field_145850_b, (BlockPos)this.getFluidLocation()).field_72450_a;
                if (flow > 0.0) {
                    return 3;
                }
                if (flow < 0.0) {
                    return 4;
                }
            }
        }
        return 0;
    }

    private boolean shouldStartGrinding(ItemStack inputStack, ItemStack grindstoneStack) {
        if (inputStack.func_190926_b() || grindstoneStack.func_190926_b() || this.getFlowDirection() == 0) {
            return false;
        }
        if (inputStack.hasCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null)) {
            ISharpness capability = TFCThingsEventHandler.getSharpnessCapability(inputStack);
            ItemGrindstone grindstone = (ItemGrindstone)grindstoneStack.func_77973_b();
            return inputStack.func_77958_k() - inputStack.func_77952_i() > 1 && capability.getCharges() < grindstone.getMaxCharges();
        }
        return false;
    }

    private void sharpenItem(ItemStack inputStack, ItemStack grindstoneStack) {
        ISharpness capability = TFCThingsEventHandler.getSharpnessCapability(inputStack);
        ItemGrindstone grindstone = (ItemGrindstone)grindstoneStack.func_77973_b();
        if (capability != null && capability.getCharges() < grindstone.getMaxCharges()) {
            for (int i = 0; i < grindstone.getTier() && capability.getCharges() < grindstone.getMaxCharges(); ++i) {
                capability.addCharge();
            }
            inputStack.func_77972_a(1, (EntityLivingBase)new EntityCow(this.field_145850_b));
            grindstoneStack.func_77972_a(1, (EntityLivingBase)new EntityCow(this.field_145850_b));
        }
    }
}

