/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.objects.Gem;
import net.dries007.tfc.objects.items.ItemGem;
import net.dries007.tfc.objects.te.TEBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityGemDisplay
extends TEBase {
    private final NonNullList<ItemStack> items = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private int grade = 0;
    private int size = 0;

    public boolean isItemEligible(@Nullable ItemStack stack) {
        Item item;
        if (stack != null && !stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ItemGem) {
            if (this.size == 0) {
                this.grade = Gem.Grade.valueOf((int)stack.func_77952_i()).ordinal();
                return true;
            }
            return this.grade == stack.func_77952_i();
        }
        return false;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void onBreakBlock() {
        this.items.forEach(i -> InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)i));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.grade = nbt.func_74762_e("grade");
        this.size = nbt.func_74762_e("size");
        this.items.clear();
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt.func_74775_l("items"), this.items);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("grade", this.grade);
        nbt.func_74768_a("size", this.size);
        nbt.func_74782_a("items", (NBTBase)ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), this.items));
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.markForBlockUpdate();
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() && this.size > 0) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)((ItemStack)this.items.get(this.size - 1)));
            this.items.set(this.size - 1, (Object)ItemStack.field_190927_a);
            --this.size;
        } else if (this.isItemEligible(heldItem) && this.size < this.getMaxStackSize()) {
            if (player.func_184812_l_()) {
                ItemStack temp = heldItem.func_77946_l();
                temp.func_190920_e(1);
                this.items.set(this.size, (Object)temp);
            } else {
                this.items.set(this.size, (Object)heldItem.func_77979_a(1));
            }
            ++this.size;
        }
        this.markForBlockUpdate();
        return true;
    }

    public int getGrade() {
        return this.grade;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxStackSize() {
        Gem.Grade currentGrade = Gem.Grade.valueOf((int)this.grade);
        switch (currentGrade) {
            case CHIPPED: {
                return 8;
            }
            case FLAWED: {
                return 6;
            }
            case NORMAL: {
                return 3;
            }
            case FLAWLESS: {
                return 2;
            }
        }
        return 1;
    }
}

