/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.renderer;

import java.util.ArrayList;
import lyeoj.tfcthings.model.ModelGemBase;
import lyeoj.tfcthings.model.ModelGemChipped;
import lyeoj.tfcthings.model.ModelGemExquisite;
import lyeoj.tfcthings.model.ModelGemFlawed;
import lyeoj.tfcthings.model.ModelGemFlawless;
import lyeoj.tfcthings.model.ModelGemNormal;
import lyeoj.tfcthings.tileentity.TileEntityGemDisplay;
import net.dries007.tfc.objects.Gem;
import net.dries007.tfc.objects.items.ItemGem;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class TESRGemDisplay
extends TileEntitySpecialRenderer<TileEntityGemDisplay> {
    private static final float[][][] ITEM_LOCATION = new float[4][8][3];
    private static final ArrayList<Vec3d> EXQUISITE_LOCATION = new ArrayList();
    private static final ArrayList<Vec3d> FLAWLESS_LOCATION = new ArrayList();
    private static final ArrayList<Vec3d> NORMAL_LOCATION = new ArrayList();
    private static final ArrayList<Vec3d> FLAWED_LOCATION = new ArrayList();
    private static final ArrayList<Vec3d> CHIPPED_LOCATION = new ArrayList();
    private static final float[] META_TO_ANGLE = new float[]{180.0f, 90.0f, 0.0f, 270.0f};
    private final ModelGemExquisite EXQUISITE_MODEL = new ModelGemExquisite();
    private final ModelGemFlawless FLAWLESS_MODEL = new ModelGemFlawless();
    private final ModelGemNormal NORMAL_MODEL = new ModelGemNormal();
    private final ModelGemFlawed FLAWED_MODEL = new ModelGemFlawed();
    private final ModelGemChipped CHIPPED_MODEL = new ModelGemChipped();

    public void render(TileEntityGemDisplay te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int dir = te.func_145832_p();
        float blockScale = 0.5f;
        ArrayList<Vec3d> location = this.getLocation(te);
        ModelGemBase model = this.getModel(te);
        for (int i = 0; i < te.getSize(); ++i) {
            ItemStack stack = (ItemStack)te.getItems().get(i);
            ResourceLocation texture = this.getGemTexture(stack);
            if (((ItemStack)te.getItems().get(i)).func_190926_b()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            Vec3d pos = location.get(i);
            if (dir == 1 || dir == 2 || dir == 5 || dir == 6) {
                pos = new Vec3d(1.0 - pos.field_72450_a, pos.field_72448_b, 1.0 - pos.field_72449_c);
            }
            GlStateManager.func_179137_b((double)(x + (dir % 2 == 0 ? pos.field_72450_a : pos.field_72449_c)), (double)(y + pos.field_72448_b), (double)(z + (dir % 2 == 0 ? pos.field_72449_c : pos.field_72450_a)));
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)blockScale, (float)blockScale, (float)blockScale);
            GlStateManager.func_179141_d();
            this.func_147499_a(texture);
            model.render(0.125f);
            GlStateManager.func_179121_F();
        }
    }

    private ArrayList<Vec3d> getLocation(TileEntityGemDisplay te) {
        switch (Gem.Grade.valueOf((int)te.getGrade())) {
            case EXQUISITE: {
                return EXQUISITE_LOCATION;
            }
            case FLAWLESS: {
                return FLAWLESS_LOCATION;
            }
            case NORMAL: {
                return NORMAL_LOCATION;
            }
            case FLAWED: {
                return FLAWED_LOCATION;
            }
        }
        return CHIPPED_LOCATION;
    }

    private ModelGemBase getModel(TileEntityGemDisplay te) {
        switch (Gem.Grade.valueOf((int)te.getGrade())) {
            case EXQUISITE: {
                return this.EXQUISITE_MODEL;
            }
            case FLAWLESS: {
                return this.FLAWLESS_MODEL;
            }
            case NORMAL: {
                return this.NORMAL_MODEL;
            }
            case FLAWED: {
                return this.FLAWED_MODEL;
            }
        }
        return this.CHIPPED_MODEL;
    }

    private ResourceLocation getGemTexture(ItemStack gem) {
        if (gem.func_77973_b() instanceof ItemGem) {
            ItemGem gemItem = (ItemGem)gem.func_77973_b();
            String type = gemItem.gem.toString().toLowerCase();
            String grade = Gem.Grade.valueOf((int)gem.func_77952_i()).toString().toLowerCase();
            return new ResourceLocation("tfcthings:textures/blocks/gem_display/" + grade + "/" + type + ".png");
        }
        return null;
    }

    static {
        EXQUISITE_LOCATION.add(new Vec3d(0.5, 2.5, 0.5));
        FLAWLESS_LOCATION.add(new Vec3d(0.5, 2.45, 0.25));
        FLAWLESS_LOCATION.add(new Vec3d(0.5, 2.55, 0.75));
        NORMAL_LOCATION.add(new Vec3d(0.25, 2.5, 0.25));
        NORMAL_LOCATION.add(new Vec3d(0.75, 2.5, 0.25));
        NORMAL_LOCATION.add(new Vec3d(0.5, 2.625, 0.775));
        FLAWED_LOCATION.add(new Vec3d(0.75, 2.5, 0.35));
        FLAWED_LOCATION.add(new Vec3d(0.25, 2.5, 0.35));
        FLAWED_LOCATION.add(new Vec3d(0.5, 2.5, 0.15));
        FLAWED_LOCATION.add(new Vec3d(0.5, 2.5, 0.55));
        FLAWED_LOCATION.add(new Vec3d(0.7, 2.625, 0.825));
        FLAWED_LOCATION.add(new Vec3d(0.3, 2.625, 0.825));
        CHIPPED_LOCATION.add(new Vec3d(0.5, 2.5, 0.5));
        CHIPPED_LOCATION.add(new Vec3d(0.75, 2.5, 0.5));
        CHIPPED_LOCATION.add(new Vec3d(0.25, 2.5, 0.5));
        CHIPPED_LOCATION.add(new Vec3d(0.375, 2.5, 0.25));
        CHIPPED_LOCATION.add(new Vec3d(0.625, 2.5, 0.25));
        CHIPPED_LOCATION.add(new Vec3d(0.5, 2.625, 0.8));
        CHIPPED_LOCATION.add(new Vec3d(0.25, 2.625, 0.8));
        CHIPPED_LOCATION.add(new Vec3d(0.75, 2.625, 0.8));
    }
}

