/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.capability.CapabilitySharpness;
import lyeoj.tfcthings.capability.ISharpness;
import lyeoj.tfcthings.event.TFCThingsEventHandler;
import lyeoj.tfcthings.init.TFCThingsSoundEvents;
import lyeoj.tfcthings.items.ItemOreDict;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.types.DefaultMetals;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemWhetstone
extends Item
implements IItemSize,
IMetalItem,
ItemOreDict,
TFCThingsConfigurableItem {
    private int tier;

    public ItemWhetstone(int tier, int durability) {
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77656_e(durability);
        this.tier = tier;
        this.setNoRepair();
        this.func_77625_d(1);
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.SMALL;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.MEDIUM;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 1000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (handIn.equals((Object)EnumHand.MAIN_HAND) && playerIn.func_184592_cb() != null && playerIn.func_184592_cb().hasCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer playerIn = (EntityPlayer)entityLiving;
            if (timeLeft < 985 && playerIn.func_184592_cb() != null && playerIn.func_184592_cb().hasCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null)) {
                ItemStack item = playerIn.func_184592_cb();
                ISharpness capability = TFCThingsEventHandler.getSharpnessCapability(item);
                if (capability != null && capability.getCharges() < this.getMaxCharges()) {
                    for (int i = 0; i < this.tier && capability.getCharges() < this.getMaxCharges(); ++i) {
                        capability.addCharge();
                    }
                    if (Math.random() < 0.8) {
                        item.func_77972_a(1, entityLiving);
                    }
                    stack.func_77972_a(1, entityLiving);
                    playerIn.func_184185_a(TFCThingsSoundEvents.WHETSTONE_SHARPEN, 1.0f, 1.0f);
                } else if (!worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.maximum_sharpness", new Object[0]));
                }
            }
        }
    }

    private int getMaxCharges() {
        switch (this.tier) {
            case 2: {
                return 256;
            }
            case 3: {
                return 384;
            }
        }
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tfcthings.tooltip.whetstone", (Object[])new Object[0]));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public Metal getMetal(ItemStack itemStack) {
        return this.tier > 1 ? (Metal)TFCRegistries.METALS.getValue(DefaultMetals.BLACK_STEEL) : null;
    }

    public int getSmeltAmount(ItemStack itemStack) {
        if (this.tier > 1) {
            if (this.func_77645_m() && itemStack.func_77951_h()) {
                double d = (double)(itemStack.func_77958_k() - itemStack.func_77952_i()) / (double)itemStack.func_77958_k() - 0.1;
                return d < 0.0 ? 0 : MathHelper.func_76128_c((double)(200.0 * d));
            }
            return 200;
        }
        return 0;
    }

    public boolean canMelt(ItemStack stack) {
        return this.tier > 1;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this.tier > 1 ? new ForgeableHeatableHandler(nbt, 0.35f, 1540.0f) : null;
    }

    @Override
    public void initOreDict() {
        OreDictionary.registerOre((String)"tool", (ItemStack)new ItemStack((Item)this, 1, Short.MAX_VALUE));
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableWhetstones;
    }
}

